/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Config;
import br.arca.morcego.component.LocalImage;
import br.arca.morcego.physics.Camera;
import br.arca.morcego.run.Renderer;
import br.arca.morcego.structure.Graph;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Enumeration;
import netscape.javascript.JSObject;

public class Morcego
extends Applet {
    private static final long serialVersionUID = -6155333810060353340L;
    private boolean isStandalone = false;
    private Cursor handCursor = new Cursor(12);
    private BufferedImage bi;
    private Graphics2D bg;
    private Graph graph;
    private Renderer renderer;
    private static Camera camera;
    private static Point origin;
    private static Morcego application;
    private Container container;

    public static void setUp() {
        Morcego.setCamera(new Camera());
        Morcego.setOrigin(new Point(Config.getInteger(Config.originX), Config.getInteger(Config.originY)));
    }

    public void init() {
        application = this;
        this.initConfig();
        this.setSize(Config.getInteger("morcego.width"), Config.getInteger("morcego.height"));
        this.resize(Config.getInteger("morcego.width"), Config.getInteger("morcego.height"));
    }

    public void initConfig() {
        Config.init();
        if (!this.isStandalone) {
            Enumeration vars = Config.listConfigVars();
            while (vars.hasMoreElements()) {
                String varName = (String)vars.nextElement();
                String appletVarName = varName.substring(8, varName.length());
                String value = this.getParameter(appletVarName);
                if (value == null) {
                    value = this.getParameter(varName);
                }
                if (value == null) continue;
                Class<?> type = Config.getValue(varName).getClass();
                try {
                    Config.setValue(varName, Config.decode(value, type));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void start() {
        int logoY;
        int logoX;
        this.bi = new BufferedImage(Config.getInteger("morcego.width"), Config.getInteger("morcego.height"), 1);
        this.bg = this.bi.createGraphics();
        this.bg.setClip(0, 0, Config.getInteger("morcego.width"), Config.getInteger("morcego.height"));
        Morcego.setUp();
        this.graph = new Graph();
        new Thread(this.graph).start();
        this.renderer = new Renderer(this);
        new Thread(this.renderer).start();
        this.container = new Container();
        this.container.setLayout(new BorderLayout());
        if (Config.getBoolean(Config.showMorcegoLogo)) {
            logoX = Config.getInteger(Config.logoX);
            logoY = Config.getInteger(Config.logoY);
            LocalImage logo = new LocalImage("Logo.jpg", logoX, logoY);
            logo.setVisible(true);
            this.addMouseListener(logo);
            this.addMouseMotionListener(logo);
            this.container.add((Component)logo, "Center");
        }
        if (Config.getBoolean(Config.showArcaLogo)) {
            logoX = Config.getInteger(Config.arcaX);
            logoY = Config.getInteger(Config.arcaY);
            LocalImage arca = new LocalImage("Arca.jpg", logoX, logoY);
            arca.setVisible(true);
            this.addMouseListener(arca);
            this.addMouseMotionListener(arca);
            this.container.add((Component)arca, "Center");
        }
        this.graph.setVisible(true);
        this.addMouseListener(this.graph);
        this.addMouseMotionListener(this.graph);
        this.container.add((Component)this.graph, "Center");
        this.container.setVisible(true);
        this.container.addNotify();
    }

    public static void setOrigin(Point point) {
        origin = point;
    }

    public void stop() {
        this.renderer.finish();
        this.graph.finish();
    }

    public Component add(Component c) {
        this.container.add(c);
        return c;
    }

    public void remove(Component c) {
        this.container.remove(c);
    }

    public void destroy() {
        this.removeMouseListener(this.graph);
        this.removeMouseMotionListener(this.graph);
    }

    public void mouseClicked(MouseEvent e) {
        this.graph.mouseClicked(e);
        e.consume();
    }

    public void mousePressed(MouseEvent e) {
        this.graph.mousePressed(e);
        e.consume();
    }

    public void mouseMoved(MouseEvent e) {
        this.graph.mouseMoved(e);
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        this.graph.mouseReleased(e);
        e.consume();
    }

    public void mouseEntered(MouseEvent e) {
        this.graph.mouseEntered(e);
        e.consume();
    }

    public void mouseExited(MouseEvent e) {
        this.graph.mouseExited(e);
        e.consume();
    }

    public void mouseDragged(MouseEvent e) {
        this.graph.mouseDragged(e);
        e.consume();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g1) {
        super.paint(g1);
        Graphics2D g = (Graphics2D)g1;
        g.setClip(0, 0, Config.getInteger("morcego.width"), Config.getInteger("morcego.height"));
        g.setBackground(Config.getColor("morcego.backgroundColor"));
        try {
            RenderingHints qualityHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            qualityHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHints(qualityHints);
            if (this.bg != null) {
                this.bg.setRenderingHints(qualityHints);
            }
        }
        catch (NullPointerException ne) {
            System.out.println("ne1");
        }
        if (this.bi != null) {
            this.bg.setColor(Config.getColor("morcego.backgroundColor"));
            this.bg.fillRect(0, 0, this.getSize().width, this.getSize().height);
            Container container = this.container;
            synchronized (container) {
                int i = 0;
                while (i < this.container.getComponentCount()) {
                    Component c = this.container.getComponent(i);
                    c.paint(this.bg);
                    ++i;
                }
            }
            g.drawImage((Image)this.bi, 0, 0, this);
        }
    }

    public void update(Graphics g) {
        if (this.bi == null) {
            g.clearRect(0, 0, this.getSize().width, this.getSize().height);
        }
        this.paint(g);
    }

    public String getAppletInfo() {
        return "Morcego rulez!";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    public static void main(String[] args) {
        Morcego applet = new Morcego();
        applet.isStandalone = true;
        Frame frame = new Frame();
        frame.setTitle("Morcego");
        frame.add(applet);
        applet.init();
        applet.start();
        int width = Config.getInteger("morcego.width");
        int height = Config.getInteger("morcego.height");
        frame.setSize(width, height);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)frame).setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyRenderer() {
        Renderer renderer = Morcego.application.renderer;
        synchronized (renderer) {
            Morcego.application.renderer.render();
        }
    }

    public static Morcego getApplication() {
        return application;
    }

    public static void showDocument(URL url, String string) {
        application.getAppletContext().showDocument(url, string);
    }

    public static void setHandCursor() {
        application.setCursor(Morcego.application.handCursor);
    }

    public static void setDefaultCursor() {
        application.setCursor(Cursor.getDefaultCursor());
    }

    public static Camera getCamera() {
        return camera;
    }

    public static void setCamera(Camera cam) {
        camera = cam;
    }

    public static Point getOrigin() {
        return origin;
    }

    public static void JSCall(String jsCommand) {
        JSObject win = JSObject.getWindow((Applet)application);
        if (win != null) {
            win.eval(jsCommand);
        }
    }

    public void navigateTo(String nodeId) {
        this.graph.navigateTo(this.graph.getNodeById(nodeId));
    }

    public void refresh() {
        Morcego.setUp();
        this.graph.notifyFeeder();
        this.graph.notifyBalancer();
        this.renderer.render();
    }

    public void changeParam(String varName, String value) {
        if (value != null && Config.exists(varName)) {
            Class<?> type = Config.getValue(varName).getClass();
            try {
                Config.setValue(varName, Config.decode(value, type));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.refresh();
    }
}

