/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search.context;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.apache.lucene.search.Query;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.analysis.Definitions;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.search.Hit;
import org.opensolaris.opengrok.search.context.LineMatcher;
import org.opensolaris.opengrok.search.context.PlainLineTokenizer;
import org.opensolaris.opengrok.search.context.QueryMatchers;
import org.opensolaris.opengrok.util.IOUtils;
import org.opensolaris.opengrok.web.Util;

public class Context {
    private final LineMatcher[] m;
    static final int MAXFILEREAD = 0x100000;
    private char[] buffer;
    PlainLineTokenizer tokens;
    String queryAsURI;
    private static final Map<String, Boolean> tokenFields = new HashMap<String, Boolean>();
    private boolean alt = true;

    public Context(Query query, Map<String, String> queryStrings) {
        QueryMatchers qm = new QueryMatchers();
        this.m = qm.getMatchers(query, tokenFields);
        if (this.m != null) {
            this.buildQueryAsURI(queryStrings);
            this.buffer = new char[0x100000];
            this.tokens = new PlainLineTokenizer(null);
        }
    }

    public boolean isEmpty() {
        return this.m == null;
    }

    private void buildQueryAsURI(Map<String, String> subqueries) {
        if (subqueries.isEmpty()) {
            this.queryAsURI = "";
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : subqueries.entrySet()) {
            String field = entry.getKey();
            String queryText = entry.getValue();
            if ("full".equals(field)) {
                field = "q";
            }
            sb.append(field).append("=").append(Util.URIEncode(queryText)).append('&');
        }
        sb.setLength(sb.length() - 1);
        this.queryAsURI = sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getContext(Reader in, Writer out, String urlPrefix, String morePrefix, String path, Definitions tags, boolean limit, boolean isDefSearch, List<Hit> hits) {
        String pathE;
        String urlPrefixE;
        TreeMap<Integer, String[]> matchingTags;
        boolean anything;
        block37: {
            boolean bl = this.alt = !this.alt;
            if (this.m == null) {
                IOUtils.close(in);
                return false;
            }
            anything = false;
            matchingTags = null;
            urlPrefixE = urlPrefix == null ? "" : Util.URIEncodePath(urlPrefix);
            pathE = Util.URIEncodePath(path);
            if (tags != null) {
                matchingTags = new TreeMap<Integer, String[]>();
                try {
                    block15: for (Definitions.Tag tag : tags.getTags()) {
                        for (int i = 0; i < this.m.length; ++i) {
                            if (this.m[i].match(tag.symbol) != 1) continue;
                            String[] desc = new String[]{tag.symbol, Integer.toString(tag.line), tag.type, tag.text};
                            if (in == null) {
                                if (out == null) {
                                    Hit hit = new Hit(path, Util.htmlize(desc[3]).replace(desc[0], "<b>" + desc[0] + "</b>"), desc[1], false, this.alt);
                                    hits.add(hit);
                                    anything = true;
                                    continue block15;
                                }
                                out.write("<a class=\"s\" href=\"");
                                out.write(urlPrefixE);
                                out.write(pathE);
                                out.write("#");
                                out.write(desc[1]);
                                out.write("\"><span class=\"l\">");
                                out.write(desc[1]);
                                out.write("</span> ");
                                out.write(Util.htmlize(desc[3]).replace(desc[0], "<b>" + desc[0] + "</b>"));
                                out.write("</a> <i>");
                                out.write(desc[2]);
                                out.write("</i><br/>");
                                anything = true;
                                continue block15;
                            }
                            matchingTags.put(tag.line, desc);
                            continue block15;
                        }
                    }
                }
                catch (Exception e) {
                    if (hits == null) break block37;
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Could not get context for " + path, e);
                }
            }
        }
        if (in == null) {
            return anything;
        }
        int charsRead = 0;
        boolean truncated = false;
        boolean lim = limit;
        if (!RuntimeEnvironment.getInstance().isQuickContextScan()) {
            lim = false;
        }
        if (lim) {
            block38: {
                try {
                    charsRead = in.read(this.buffer);
                    if (charsRead != 0x100000) break block38;
                    truncated = true;
                    for (int i = charsRead - 1; i > charsRead - 100; --i) {
                        if (this.buffer[i] != '\n') continue;
                        charsRead = i;
                        break;
                    }
                }
                catch (IOException e) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "An error occured while reading data", e);
                    return anything;
                }
            }
            if (charsRead == 0) {
                return anything;
            }
            this.tokens.reInit(this.buffer, charsRead, out, urlPrefixE + pathE + "#", matchingTags);
        } else {
            this.tokens.reInit(in, out, urlPrefixE + pathE + "#", matchingTags);
        }
        if (hits != null) {
            this.tokens.setAlt(this.alt);
            this.tokens.setHitList(hits);
            this.tokens.setFilename(path);
        }
        try {
            String token;
            int matchState = 0;
            int matchedLines = 0;
            block18: while (!((token = this.tokens.yylex()) == null || lim && matchedLines >= 10)) {
                for (int i = 0; i < this.m.length; ++i) {
                    matchState = this.m[i].match(token);
                    if (matchState == 1) {
                        if (!isDefSearch) {
                            this.tokens.printContext();
                        } else if (this.tokens.tags.containsKey(this.tokens.markedLine)) {
                            this.tokens.printContext();
                        }
                        ++matchedLines;
                        continue block18;
                    }
                    if (matchState == 2) {
                        this.tokens.holdOn();
                        continue;
                    }
                    this.tokens.neverMind();
                }
            }
            anything = matchedLines > 0;
            this.tokens.dumpRest();
            if (lim && (truncated || matchedLines == 10) && out != null) {
                out.write("<a href=\"" + Util.URIEncodePath(morePrefix) + pathE + "?" + this.queryAsURI + "\">[all...]</a>");
            }
        }
        catch (IOException e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "Could not get context for " + path, e);
        }
        finally {
            IOUtils.close(in);
            if (out != null) {
                try {
                    out.flush();
                }
                catch (IOException e) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to flush stream: ", e);
                }
            }
        }
        return anything;
    }

    static {
        tokenFields.put("full", Boolean.TRUE);
        tokenFields.put("refs", Boolean.FALSE);
        tokenFields.put("defs", Boolean.FALSE);
    }
}

