/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.search.Hit;
import org.opensolaris.opengrok.search.SearchEngine;
import org.opensolaris.opengrok.util.Getopt;

final class Search {
    private static final String usage = "USAGE: Search -R <configuration.xml> [-d | -r | -p | -h | -f | -t] 'query string' ..\n\t -R <configuration.xml> Read configuration from the specified file\n\t -d Symbol Definitions\n\t -r Symbol References\n\t -p Path\n\t -h History\n\t -f Full text\n\t -t Type";
    private SearchEngine engine;
    final List<Hit> results = new ArrayList<Hit>();
    int totalResults = 0;
    int nhits = 0;

    Search() {
    }

    protected boolean parseCmdLine(String[] argv) {
        int cmd;
        this.engine = new SearchEngine();
        Getopt getopt = new Getopt(argv, "R:d:r:p:h:f:t:");
        try {
            getopt.parse();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println(usage);
            return false;
        }
        while ((cmd = getopt.getOpt()) != -1) {
            switch (cmd) {
                case 82: {
                    try {
                        RuntimeEnvironment.getInstance().readConfiguration(new File(getopt.getOptarg()));
                        break;
                    }
                    catch (Exception e) {
                        System.err.println("Failed to read config file: ");
                        System.err.println(e.getMessage());
                        return false;
                    }
                }
                case 100: {
                    this.engine.setDefinition(getopt.getOptarg());
                    break;
                }
                case 114: {
                    this.engine.setSymbol(getopt.getOptarg());
                    break;
                }
                case 112: {
                    this.engine.setFile(getopt.getOptarg());
                    break;
                }
                case 104: {
                    this.engine.setHistory(getopt.getOptarg());
                    break;
                }
                case 102: {
                    this.engine.setFreetext(getopt.getOptarg());
                    break;
                }
                case 116: {
                    this.engine.setType(getopt.getOptarg());
                }
            }
        }
        return true;
    }

    protected boolean search() {
        if (RuntimeEnvironment.getInstance().getDataRootPath() == null) {
            System.err.println("You must specify a configuration file");
            System.err.println(usage);
            return false;
        }
        if (this.engine == null || !this.engine.isValidQuery()) {
            System.err.println("You did not specify a valid query");
            System.err.println(usage);
            return false;
        }
        this.results.clear();
        this.nhits = this.engine.search();
        if (this.nhits > 0) {
            this.engine.results(0, this.nhits, this.results);
        }
        this.totalResults = this.engine.totalHits;
        return true;
    }

    protected void dumpResults() {
        if (this.results.isEmpty()) {
            System.err.println("Your search \"" + this.engine.getQuery() + "\" did not match any files.");
        } else {
            String root = RuntimeEnvironment.getInstance().getSourceRootPath();
            System.out.println("Printing results 1 - " + this.nhits + " of " + this.totalResults + " total matching documents collected.");
            for (Hit hit : this.results) {
                File file = new File(root, hit.getPath());
                System.out.println(file.getAbsolutePath() + ":" + hit.getLineno() + " [" + hit.getLine() + "]");
            }
            if (this.nhits < this.totalResults) {
                System.out.println("Printed results 1 - " + this.nhits + " of " + this.totalResults + " total matching documents collected.");
                System.out.println("Collect the rest (y/n) ?");
                BufferedReader in = null;
                try {
                    in = new BufferedReader(new InputStreamReader(System.in, "UTF-8"));
                    String line = in.readLine();
                    if (null == line || line.length() == 0 || line.charAt(0) == 'n') {
                        return;
                    }
                }
                catch (Exception ex) {
                    System.err.println(ex.getMessage());
                }
                this.engine.results(this.nhits, this.totalResults, this.results);
                for (Hit hit : this.results) {
                    File file = new File(root, hit.getPath());
                    System.out.println(file.getAbsolutePath() + ":" + hit.getLineno() + " [" + hit.getLine() + "]");
                }
            }
        }
    }

    public static void main(String[] argv) {
        Search searcher = new Search();
        boolean success = false;
        if (searcher.parseCmdLine(argv) && searcher.search()) {
            success = true;
            searcher.dumpResults();
        }
        if (!success) {
            System.exit(1);
        }
    }
}

