/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.opensolaris.opengrok.analysis.CompatibleAnalyser;
import org.opensolaris.opengrok.configuration.RuntimeEnvironment;
import org.opensolaris.opengrok.search.SearchEngine;

class CustomQueryParser
extends QueryParser {
    CustomQueryParser(String field) {
        super(SearchEngine.LUCENE_VERSION, field, (Analyzer)new CompatibleAnalyser());
        this.setDefaultOperator(AND_OPERATOR);
        this.setAllowLeadingWildcard(RuntimeEnvironment.getInstance().isAllowLeadingWildcard());
        this.setLowercaseExpandedTerms(false);
    }

    private static boolean isCaseSensitive(String field) {
        return "defs".equals(field) || "refs".equals(field);
    }

    private static String getCanonicalTerm(String field, String term) {
        return CustomQueryParser.isCaseSensitive(field) ? term : term.toLowerCase();
    }

    protected Query getFuzzyQuery(String field, String term, float min) throws ParseException {
        return super.getFuzzyQuery(field, CustomQueryParser.getCanonicalTerm(field, term), min);
    }

    protected Query getPrefixQuery(String field, String term) throws ParseException {
        return super.getPrefixQuery(field, CustomQueryParser.getCanonicalTerm(field, term));
    }

    protected Query getRangeQuery(String field, String term1, String term2, boolean startinclusive, boolean endinclusive) throws ParseException {
        return super.getRangeQuery(field, CustomQueryParser.getCanonicalTerm(field, term1), CustomQueryParser.getCanonicalTerm(field, term2), startinclusive, endinclusive);
    }

    protected Query getWildcardQuery(String field, String term) throws ParseException {
        return super.getWildcardQuery(field, CustomQueryParser.getCanonicalTerm(field, term));
    }
}

