/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.Repository;
import org.opensolaris.opengrok.util.IOUtils;

class SCCSHistoryParser {
    boolean pass;
    boolean passRecord;
    boolean active;
    int field;
    boolean sep;
    StringBuilder record = new StringBuilder(128);
    private String revision;
    private String author;
    private Date rdate;
    private String comment;
    DateFormat sccsDateFormat;
    Reader in;

    SCCSHistoryParser() {
    }

    History parse(File file, Repository repos) throws HistoryException {
        this.sccsDateFormat = repos.getDateFormat();
        try {
            return this.parseFile(file);
        }
        catch (IOException ioe) {
            throw new HistoryException(ioe);
        }
    }

    private History parseFile(File file) throws IOException {
        File f = SCCSHistoryParser.getSCCSFile(file);
        if (f == null) {
            return null;
        }
        this.in = new BufferedReader(new FileReader(SCCSHistoryParser.getSCCSFile(file)));
        this.sep = false;
        this.pass = false;
        this.passRecord = true;
        this.active = true;
        this.field = 0;
        this.sccsDateFormat = new SimpleDateFormat("yy/MM/dd", Locale.getDefault());
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        while (this.next()) {
            HistoryEntry entry = new HistoryEntry();
            entry.setRevision(this.getRevision());
            entry.setDate(this.getDate());
            entry.setAuthor(this.getAuthor());
            entry.setMessage(this.getComment());
            entry.setActive(this.isActive());
            entries.add(entry);
        }
        IOUtils.close(this.in);
        History history = new History();
        history.setHistoryEntries(entries);
        return history;
    }

    private boolean next() throws IOException {
        int c;
        this.sep = true;
        this.record.setLength(0);
        while ((c = this.read()) > 1) {
            this.record.append((char)c);
        }
        this.revision = null;
        return this.record.length() > 2;
    }

    private void initFields() {
        if (this.revision == null) {
            String[] f = this.record.toString().split(" ", 6);
            if (f.length > 5) {
                this.revision = f[1];
                try {
                    this.rdate = this.sccsDateFormat.parse(f[2] + " " + f[3]);
                }
                catch (ParseException e) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "An error occured while parsing date", e);
                    this.rdate = null;
                }
                this.author = f[4];
                this.comment = f[5];
            } else {
                this.rdate = null;
                this.author = null;
                this.comment = null;
            }
        }
    }

    private String getRevision() {
        this.initFields();
        return this.revision;
    }

    private Date getDate() {
        this.initFields();
        return this.rdate;
    }

    private String getAuthor() {
        this.initFields();
        return this.author;
    }

    private String getComment() {
        this.initFields();
        return this.comment;
    }

    private boolean isActive() {
        return this.active;
    }

    private int read() throws IOException {
        int c;
        block10: while ((c = this.in.read()) != -1) {
            switch (c) {
                case 1: {
                    int d = this.in.read();
                    switch (d) {
                        case 99: 
                        case 116: 
                        case 117: {
                            d = this.in.read();
                            if (d != 32) {
                                return d;
                            }
                            this.pass = true;
                            continue block10;
                        }
                        case 100: {
                            d = this.in.read();
                            if (d == 32) {
                                int dt = this.in.read();
                                this.active = dt != 82;
                                this.passRecord = true;
                                this.field = 1;
                                continue block10;
                            }
                            return d;
                        }
                        case -1: 
                        case 68: 
                        case 69: 
                        case 73: 
                        case 84: {
                            return -1;
                        }
                        case 101: {
                            this.pass = false;
                            if (this.sep && this.passRecord) {
                                return 1;
                            }
                            this.passRecord = true;
                            continue block10;
                        }
                    }
                    this.pass = false;
                    continue block10;
                }
                case 32: {
                    if (!this.passRecord) break;
                    if (this.field > 0) {
                        ++this.field;
                        this.pass = true;
                    }
                    if (this.field <= 5) break;
                    this.field = 0;
                    this.pass = false;
                    return c;
                }
            }
            if (!this.pass || !this.passRecord) continue;
            return c;
        }
        return -1;
    }

    protected static File getSCCSFile(File file) {
        return SCCSHistoryParser.getSCCSFile(file.getParent(), file.getName());
    }

    protected static File getSCCSFile(String parent, String name) {
        File f = new File(parent + "/SCCS/s." + name);
        if (!f.exists()) {
            return null;
        }
        return f;
    }
}

