/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jrcs.diff;

import java.util.List;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.PatchFailedException;
import org.apache.commons.jrcs.diff.RevisionVisitor;
import org.apache.commons.jrcs.util.ToString;

public abstract class Delta
extends ToString {
    protected Chunk original;
    protected Chunk revised;
    static Class[][] DeltaClass = new Class[2][2];

    public static Delta newDelta(Chunk chunk, Chunk chunk2) {
        Delta delta;
        Class clazz = DeltaClass[chunk.size() > 0 ? 1 : 0][chunk2.size() > 0 ? 1 : 0];
        try {
            delta = (Delta)clazz.newInstance();
        }
        catch (Throwable throwable) {
            return null;
        }
        delta.init(chunk, chunk2);
        return delta;
    }

    protected Delta() {
    }

    protected Delta(Chunk chunk, Chunk chunk2) {
        this.init(chunk, chunk2);
    }

    protected void init(Chunk chunk, Chunk chunk2) {
        this.original = chunk;
        this.revised = chunk2;
    }

    public abstract void verify(List var1) throws PatchFailedException;

    public final void patch(List list) throws PatchFailedException {
        this.verify(list);
        try {
            this.applyTo(list);
        }
        catch (Exception exception) {
            throw new PatchFailedException(exception.getMessage());
        }
    }

    public abstract void applyTo(List var1);

    public void toString(StringBuffer stringBuffer) {
        this.original.rangeString(stringBuffer);
        stringBuffer.append("x");
        this.revised.rangeString(stringBuffer);
        stringBuffer.append(Diff.NL);
        this.original.toString(stringBuffer, "> ", "\n");
        stringBuffer.append("---");
        stringBuffer.append(Diff.NL);
        this.revised.toString(stringBuffer, "< ", "\n");
    }

    public abstract void toRCSString(StringBuffer var1, String var2);

    public String toRCSString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toRCSString(stringBuffer, string);
        return stringBuffer.toString();
    }

    public Chunk getOriginal() {
        return this.original;
    }

    public Chunk getRevised() {
        return this.revised;
    }

    public abstract void accept(RevisionVisitor var1);

    static {
        try {
            Delta.DeltaClass[0][0] = ChangeDelta.class;
            Delta.DeltaClass[0][1] = AddDelta.class;
            Delta.DeltaClass[1][0] = DeleteDelta.class;
            Delta.DeltaClass[1][1] = ChangeDelta.class;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

