/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class RebootInstances
extends BaseCmd {
    public RebootInstances(String[] args) {
        super("ec2reboot", "ec2-reboot-instances");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        result.addOption(OptionBuilder.create((String)"i"));
        return result;
    }

    protected String getOptionString() {
        return "INSTANCE [INSTANCE [...]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Reboot selected running instances.");
        System.out.println("     The INSTANCE parameter is an instance ID to reboot.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("INSTANCE");
        String[] instanceIds = this.getNonOptions();
        RequestResultPair rsp = jec2.rebootInstances(instanceIds);
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new RebootInstances(args).invoke();
    }
}

