/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureConfirmation {
    private static final String VALUE = "Value";
    protected Element element = null;
    private byte[] signatureValue = null;

    public SignatureConfirmation(Element elem) throws WSSecurityException {
        this.element = elem;
        String sv = this.element.getAttributeNS(null, VALUE);
        if (sv != null) {
            this.signatureValue = Base64.decode(sv);
        }
    }

    public SignatureConfirmation(Document doc, byte[] signVal) {
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2005/xx/oasis-2005xx-wss-wssecurity-secext-1.1.xsd", "wsse11:SignatureConfirmation");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2005/xx/oasis-2005xx-wss-wssecurity-secext-1.1.xsd", "wsse11");
        if (signVal != null) {
            String sv = Base64.encode(signVal);
            this.element.setAttribute(VALUE, sv);
        }
    }

    public Element getElement() {
        return this.element;
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public byte[] getSignatureValue() {
        return this.signatureValue;
    }
}

