/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.sandbox.security.trust2;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis.utils.DOM2Writer;
import org.apache.ws.sandbox.security.trust2.Lifetime;
import org.apache.ws.sandbox.security.trust2.SecurityTokenOrReference;
import org.apache.ws.sandbox.security.trust2.exception.ElementParsingException;
import org.apache.ws.sandbox.security.trust2.exception.EmptyTokenOrReference;
import org.apache.ws.sandbox.security.trust2.exception.TrustException;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class SecurityTokenMessage {
    protected URI context = null;
    protected URI tokenType = null;
    protected URI keyType;
    protected int keySize;
    protected URI signatureAlgorithm;
    protected SecurityTokenOrReference encryption;
    protected SecurityTokenOrReference proofEncryption;
    protected Lifetime lifetime = null;
    protected ArrayList customElements = new ArrayList();
    protected Element element;
    protected Document doc;

    public SecurityTokenMessage(Element element) throws ElementParsingException {
        if (element != null) {
            this.doc = element.getOwnerDocument();
            this.initialize(element);
        }
    }

    public SecurityTokenMessage(Element element, Document doc) throws ElementParsingException {
        if (element != null) {
            this.doc = doc;
            this.initialize(element);
        }
    }

    private void initialize(Element element) throws ElementParsingException {
        try {
            NodeList childNodes;
            Attr context = element.getAttributeNodeNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "Context");
            if (context != null) {
                this.setContext(new URI(context.getValue()));
            }
            if ((childNodes = element.getChildNodes()) != null) {
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node currentNode = childNodes.item(i);
                    if (!"http://schemas.xmlsoap.org/ws/2004/04/trust".equals(currentNode.getNamespaceURI())) {
                        if (!(currentNode instanceof Element)) continue;
                        this.addCustomElement((Element)currentNode);
                        continue;
                    }
                    if (currentNode.getLocalName().equals("TokenType")) {
                        String textContent = this.getTextContent(currentNode);
                        if (textContent == null || textContent.equals("")) continue;
                        this.setTokenType(new URI(textContent));
                        continue;
                    }
                    if (currentNode.getLocalName().equals("Lifetime") || currentNode.getLocalName().equals("LifeTime")) {
                        this.lifetime = new Lifetime(WSSConfig.getDefaultWSConfig(), this.doc, (Element)currentNode);
                        continue;
                    }
                    if (!(currentNode instanceof Element)) continue;
                    this.addCustomElement((Element)currentNode);
                }
            }
        }
        catch (URISyntaxException e) {
            throw new ElementParsingException("URISyntaxException while creating SecurityTokenMessage from XML element: " + e.getMessage());
        }
        catch (WSSecurityException e) {
            throw new ElementParsingException("WSSecurityException while creating SecurityTokenMessage from XML element: " + e.getMessage());
        }
    }

    public SecurityTokenMessage(Document doc) {
        this.doc = doc;
    }

    public void setDocument(Document doc) {
        this.doc = doc;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void setContext(URI context) {
        this.context = context;
    }

    public URI getContext() {
        return this.context;
    }

    public void setTokenType(URI tokenType) {
        this.tokenType = tokenType;
    }

    public URI getTokenType() {
        return this.tokenType;
    }

    public void addCustomElement(Element element) {
        this.customElements.add(element);
    }

    public Element addCustomElement(String tagName) {
        Element element = this.doc.createElement(tagName);
        this.addCustomElement(element);
        return element;
    }

    public Element addCustomElementNS(String namespaceUri, String qualifiedName) {
        Element element = this.doc.createElementNS(namespaceUri, qualifiedName);
        this.addCustomElement(element);
        return element;
    }

    public List getCustomElements() {
        return this.customElements;
    }

    public Element getCustomElement(String namespaceUri, String localName) {
        Iterator itr = this.customElements.iterator();
        while (itr.hasNext()) {
            Element currentElement = (Element)itr.next();
            String elementNs = currentElement.getNamespaceURI();
            if ((namespaceUri != null || elementNs != null) && (namespaceUri == null || !namespaceUri.equals(elementNs))) continue;
            String elementLocalName = currentElement.getLocalName();
            if ((localName != null || elementLocalName != null) && (localName == null || !localName.equals(elementLocalName))) continue;
            return currentElement;
        }
        return null;
    }

    public void setLifetime(Lifetime lifetime) {
        this.lifetime = lifetime;
    }

    public Lifetime getLifetime() {
        return this.lifetime;
    }

    public abstract Element getElement() throws TrustException;

    protected Element getElement(String tagName) throws TrustException {
        this.element = this.doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/trust", tagName);
        if (this.context != null) {
            this.element.setAttributeNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "wst:Context", this.context.toString());
        }
        if (this.tokenType != null) {
            Element tokenTypeElement = this.doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/trust", "wst:TokenType");
            this.setTextContent(tokenTypeElement, this.tokenType.toString());
            this.element.appendChild(tokenTypeElement);
        }
        Iterator itr = this.customElements.iterator();
        while (itr.hasNext()) {
            this.element.appendChild((Element)itr.next());
        }
        if (this.lifetime != null) {
            this.element.appendChild(this.lifetime.getElement());
        }
        return this.element;
    }

    protected Element createTokenOrReferenceElement(String enclosingTagName, SecurityTokenOrReference token) throws TrustException {
        Element element = this.doc.createElementNS("http://schemas.xmlsoap.org/ws/2004/04/trust", enclosingTagName);
        Element tokenElement = token.getElement();
        if (tokenElement == null) {
            throw new EmptyTokenOrReference("SecurityTokenOrReference specified does not contain a security token element or reference element.");
        }
        element.appendChild(tokenElement);
        return element;
    }

    protected void setTextContent(Element element, String string) {
        Text textNode = this.doc.createTextNode(string);
        element.appendChild(textNode);
    }

    protected String getTextContent(Node currentNode) {
        NodeList nodes = currentNode.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            if (nodes.item(j).getNodeValue() == null) continue;
            return nodes.item(j).getNodeValue();
        }
        return null;
    }

    protected Element getFirstNonBlankChildAsElement(Node currentNode) {
        NodeList nodes = currentNode.getChildNodes();
        for (int j = 0; j < nodes.getLength(); ++j) {
            if (nodes.item(j).getLocalName() == null) continue;
            return (Element)nodes.item(j);
        }
        return null;
    }

    public String toString() {
        try {
            return DOM2Writer.nodeToString((Node)this.getElement(), (boolean)true);
        }
        catch (TrustException e) {
            return "TrustException when trying to convert to String: " + e.getMessage();
        }
    }
}

