/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.igoweb.util.Defs;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.TBlock;

public class MsgOut
extends AFrame
implements ActionListener {
    private static final String[] okButton = new String[]{Defs.getString(1436228518)};
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int ERROR_MESSAGE = 0;
    public static final int QUESTION_MESSAGE = 3;
    private final JButton[] buttons;
    private ActionListener listener = null;

    public MsgOut(String title, String message, int msgType) {
        this(title, message, msgType, null, okButton, null);
    }

    public MsgOut(String title, Component body, int msgType) {
        this(title, body, msgType, null, okButton, null);
    }

    public MsgOut(String title, String message, int msgType, Component parent) {
        this(title, message, msgType, parent, okButton, null);
    }

    public MsgOut(String title, Component body, int msgType, Component parent) {
        this(title, body, msgType, parent, okButton, null);
    }

    public MsgOut(String title, String message, int msgType, Component parent, String[] buttons, ActionListener listener) {
        this(title, new TBlock(message, 30), msgType, parent, buttons, listener);
    }

    public MsgOut(String title, Component body, int msgType, Component parent, String[] buttons, ActionListener listener) {
        super(title, parent);
        this.listener = listener;
        this.buttons = new JButton[buttons.length];
        for (int i = 0; i < buttons.length; ++i) {
            this.buttons[i] = new JButton(buttons[i]);
            this.buttons[i].setActionCommand(buttons[i]);
            this.buttons[i].addActionListener(this);
        }
        JOptionPane opPane = new JOptionPane(body, msgType, 0, null, this.buttons);
        this.setContentPane(opPane);
        this.pack(parent);
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.dispose();
        if (this.listener != null) {
            Object source = evt.getSource();
            for (int i = 0; i < this.buttons.length; ++i) {
                if (this.buttons[i] != source) continue;
                this.listener.actionPerformed(new ActionEvent(this, 1001, this.buttons[i].getActionCommand()));
                return;
            }
        }
    }

    public JButton getButton(int index) {
        return this.buttons[index];
    }

    public void addActionListener(ActionListener newListener) {
        this.listener = AWTEventMulticaster.add(this.listener, newListener);
    }
}

