/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.Preferences;
import javax.jnlp.BasicService;
import javax.jnlp.FileContents;
import javax.jnlp.FileOpenService;
import javax.jnlp.FileSaveService;
import javax.jnlp.PersistenceService;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.JnlpIo;

class JnlpInstantiation
extends JnlpIo {
    private final BasicService bs;
    private final PersistenceService persist;

    public JnlpInstantiation() {
        PersistenceService tmpPs;
        BasicService tmpBs;
        try {
            tmpBs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
        }
        catch (UnavailableServiceException excep) {
            JnlpInstantiation.getLogger().warning("JnlpInstantiation: Error getting basic service: " + (Object)((Object)excep));
            tmpBs = null;
        }
        this.bs = tmpBs;
        try {
            tmpPs = (PersistenceService)ServiceManager.lookup((String)"javax.jnlp.PersistenceService");
        }
        catch (UnavailableServiceException excep) {
            JnlpInstantiation.getLogger().warning("JnlpInstantiation: Error getting persistence service: " + (Object)((Object)excep));
            tmpPs = null;
        }
        this.persist = tmpPs;
    }

    @Override
    public InputStream doReadPersist(String persistName) {
        if (this.persist == null) {
            return null;
        }
        try {
            FileContents fc = this.persist.get(new URL(this.bs.getCodeBase(), persistName));
            if (fc == null) {
                JnlpInstantiation.getLogger().warning("JnlpInstantation.doReadPersist: Null file contents for " + persistName);
                return null;
            }
            return fc.getInputStream();
        }
        catch (MalformedURLException excep) {
            JnlpInstantiation.getLogger().log(Level.WARNING, "JnlpInstantation.doReadPersist: Error getting input stream", excep);
            return null;
        }
        catch (IOException excep) {
            JnlpInstantiation.getLogger().log(Level.WARNING, "JnlpInstantation.doReadPersist: Error getting input stream", excep);
            return null;
        }
    }

    @Override
    public OutputStream doWritePersist(String persistName, long size) throws IOException {
        if (this.persist == null) {
            return null;
        }
        try {
            URL url = new URL(this.bs.getCodeBase(), persistName);
            IOException createExcep = null;
            try {
                this.persist.create(url, size);
            }
            catch (IOException excep) {
                createExcep = excep;
            }
            FileContents fc = this.persist.get(url);
            if (fc == null) {
                if (createExcep == null) {
                    JnlpInstantiation.getLogger().warning("JnlpInstantiation.doWritePersist: Null persist file, no create error.");
                } else {
                    JnlpInstantiation.getLogger().log(Level.WARNING, "JnlpInstantiation.doWritePersist: Null persist file. Creation error attached", createExcep);
                }
                return null;
            }
            return fc.getOutputStream(true);
        }
        catch (MalformedURLException excep) {
            return null;
        }
    }

    @Override
    public boolean doShowUrl(URL url) {
        return this.bs == null ? false : this.bs.showDocument(url);
    }

    @Override
    public boolean doInstallStartupListener(final EventListener listener) {
        try {
            SingleInstanceService sis = (SingleInstanceService)ServiceManager.lookup((String)"javax.jnlp.SingleInstanceService");
            sis.addSingleInstanceListener(new SingleInstanceListener(){

                public void newActivation(String[] params) {
                    listener.handleEvent(new Event(this, 0, params));
                }
            });
            return true;
        }
        catch (UnavailableServiceException excep) {
            JnlpInstantiation.getLogger().log(Level.INFO, "JnlpInstantation.doInstallStartupListener: No SingleInstanceService: " + (Object)((Object)excep));
            return false;
        }
    }

    @Override
    JnlpIo.FileAccessResult doOpenFile(String defaultPath, String[] extensions) {
        FileOpenService fos;
        try {
            fos = (FileOpenService)ServiceManager.lookup((String)"javax.jnlp.FileOpenService");
        }
        catch (UnavailableServiceException e) {
            JnlpInstantiation.getLogger().log(Level.INFO, "JnlpInstantation.doOpenFile: No FileOpenService: " + (Object)((Object)e));
            return null;
        }
        if (fos == null) {
            return null;
        }
        try {
            FileContents fc = fos.openFileDialog(defaultPath, extensions);
            if (fc != null && !fc.canRead()) {
                fc = null;
            }
            return new FarImpl(fc);
        }
        catch (IOException excep) {
            return null;
        }
    }

    @Override
    JnlpIo.FileAccessResult doSaveAsFile(File defaultFile, InputStream data) {
        FileSaveService fss;
        try {
            fss = (FileSaveService)ServiceManager.lookup((String)"javax.jnlp.FileSaveService");
        }
        catch (UnavailableServiceException e) {
            JnlpInstantiation.getLogger().log(Level.INFO, "JnlpInstantation.doSaveAsFile: No FileSaveService: " + (Object)((Object)e));
            return null;
        }
        if (fss == null) {
            JnlpInstantiation.getLogger().log(Level.INFO, "JnlpInstantation.doSaveAsFile: Got null FileSaveService");
            return null;
        }
        try {
            FileContents fc = fss.saveFileDialog(defaultFile == null ? null : defaultFile.getPath(), new String[]{"sgf"}, data, defaultFile == null ? null : defaultFile.getName());
            if (fc != null && !fc.canWrite()) {
                fc = null;
            }
            return new FarImpl(fc);
        }
        catch (IOException excep) {
            JnlpInstantiation.getLogger().log(Level.WARNING, "JnlpInstantation.doSaveAsFile: Error in save as", excep);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Preferences doGetPreferences() {
        InputStream in = this.doReadPersist("prefs");
        try {
            JnlpPrefs jnlpPrefs = new JnlpPrefs(in);
            return jnlpPrefs;
        }
        catch (IOException excep) {
            JnlpInstantiation.getLogger().log(Level.WARNING, "JnlpInstantiation.doGetPreferences: Error reading prefs", excep);
            JnlpPrefs jnlpPrefs = new JnlpPrefs();
            return jnlpPrefs;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private class JnlpPrefs
    extends AbstractPreferences {
        private final HashMap<String, String> vals;
        private final HashMap<String, JnlpPrefs> children;

        public JnlpPrefs(InputStream rawIn) throws IOException {
            DataInputStream in;
            super(null, "");
            this.vals = new HashMap();
            this.children = new HashMap();
            if (rawIn == null) {
                JnlpIo.getLogger().warning("JnlpInstantion.JnlpPrefs.new: null input stream");
                return;
            }
            if (rawIn instanceof DataInputStream) {
                in = (DataInputStream)rawIn;
            } else {
                in = new DataInputStream(new BufferedInputStream(rawIn));
                byte vers = in.readByte();
                if (vers != 0) {
                    JnlpIo.getLogger().warning("JnlpInstantiation.JnlpPRefs.new: Unknown store version " + vers);
                    return;
                }
            }
            int numEntries = in.readInt();
            while (--numEntries >= 0) {
                String key = in.readUTF();
                this.vals.put(key, in.readUTF());
            }
            int numChildren = in.readInt();
            while (--numChildren >= 0) {
                String key = in.readUTF();
                this.children.put(in.readUTF(), new JnlpPrefs(in));
            }
        }

        @Override
        protected void putSpi(String key, String value) {
            this.vals.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return this.vals.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this.vals.remove(key);
        }

        @Override
        protected void removeNodeSpi() {
        }

        @Override
        protected String[] keysSpi() {
            return this.flatten(this.vals);
        }

        @Override
        protected String[] childrenNamesSpi() {
            return this.flatten(this.children);
        }

        private String[] flatten(HashMap<String, ?> in) {
            return in.keySet().toArray(new String[in.size()]);
        }

        @Override
        protected AbstractPreferences childSpi(String nodeName) {
            JnlpPrefs np = new JnlpPrefs();
            this.children.put(nodeName, np);
            return np;
        }

        @Override
        public void syncSpi() {
            JnlpIo.getLogger().info("JnlpPrefs.syncSpi()");
        }

        @Override
        public void flushSpi() {
            JnlpIo.getLogger().info("JnlpPrefs.flushSpi()");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            JnlpIo.getLogger().info("JnlpPrefs.flush()");
            FilterOutputStream out = null;
            try {
                OutputStream rawOut = JnlpInstantiation.this.doWritePersist("prefs", 10240L);
                if (rawOut == null) {
                    JnlpIo.getLogger().warning("JnlpInstantiation.JnlpPrefs.flush: null output stream");
                    return;
                }
                out = new DataOutputStream(new BufferedOutputStream(rawOut));
                ((DataOutputStream)out).writeByte(0);
                this.writeTo((DataOutputStream)out);
            }
            catch (IOException excep) {
                JnlpIo.getLogger().log(Level.WARNING, "JnlpInstantiation.JnlpPrefs.flush: Error writing", excep);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        private void writeTo(DataOutputStream out) throws IOException {
            out.writeInt(this.vals.size());
            for (Map.Entry<String, String> entry : this.vals.entrySet()) {
                out.writeUTF(entry.getKey());
                out.writeUTF(entry.getValue());
            }
            out.writeInt(this.children.size());
            for (Map.Entry<String, Object> entry : this.children.entrySet()) {
                out.writeUTF(entry.getKey());
                ((JnlpPrefs)entry.getValue()).writeTo(out);
            }
        }

        public JnlpPrefs() {
            super(null, "");
            this.vals = new HashMap();
            this.children = new HashMap();
        }
    }

    public static class FarImpl
    implements JnlpIo.FileAccessResult {
        public final FileContents fc;

        public FarImpl(FileContents newFc) {
            this.fc = newFc;
        }

        @Override
        public boolean isFileSelected() {
            return this.fc != null;
        }

        @Override
        public String getFileName() {
            try {
                return this.fc.getName();
            }
            catch (IOException excep) {
                JnlpIo.getLogger().log(Level.INFO, "JnlpInstantation.FarImpl.getFileName: Error getting name", excep);
                return null;
            }
        }

        @Override
        public InputStream getInputStream() {
            try {
                return this.fc.getInputStream();
            }
            catch (IOException excep) {
                JnlpIo.getLogger().log(Level.INFO, "JnlpInstantation.FarImpl.getInputStream: Error getting stream", excep);
                return null;
            }
        }

        @Override
        public OutputStream getOutputStream() {
            try {
                return this.fc.getOutputStream(true);
            }
            catch (IOException excep) {
                JnlpIo.getLogger().log(Level.INFO, "JnlpInstantation.FarImpl.getOututStream: Error getting stream", excep);
                return null;
            }
        }
    }
}

