/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class ATextField
extends JTextField {
    private String origString;
    private final ActionListener listener;

    public ATextField() {
        this("", 1, true, null);
    }

    public ATextField(String s) {
        this(s, s.length(), true, null);
    }

    public ATextField(int i) {
        this("", i, true, null);
    }

    public ATextField(String s, int i) {
        this(s, i, true, null);
    }

    public ATextField(boolean editable) {
        this("", 1, editable, null);
    }

    public ATextField(String s, boolean editable) {
        this(s, s.length(), editable, null);
    }

    public ATextField(int i, boolean editable) {
        this("", i, editable, null);
    }

    public ATextField(String s, int i, boolean editable) {
        this(s, i, editable, null);
    }

    public ATextField(ActionListener listener) {
        this("", 1, true, listener);
    }

    public ATextField(String s, ActionListener listener) {
        this(s, s == null ? 0 : s.length(), true, listener);
    }

    public ATextField(int i, ActionListener listener) {
        this("", i, true, listener);
    }

    public ATextField(String s, int i, ActionListener listener) {
        this(s, i, true, listener);
    }

    public ATextField(String s, int i, boolean editable, ActionListener newListener) {
        super(s, i);
        this.origString = s;
        if (!editable) {
            this.setEditable(false);
            this.setBackground(UIManager.getColor("org.igoweb.outputBg"));
        }
        this.listener = newListener == null ? new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ATextField.this.transferFocus();
            }
        } : newListener;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                char c = event.getKeyChar();
                if (c == '\n' || c == '\r') {
                    final String val = ATextField.this.getText();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ATextField.this.listener.actionPerformed(new ActionEvent(ATextField.this, 1001, val));
                        }
                    });
                }
            }
        });
    }

    @Override
    public void setText(String newText) {
        this.origString = newText;
        super.setText(newText);
    }

    public boolean changed() {
        return !this.origString.equals(this.getText());
    }

    @Override
    public void setEditable(boolean isEditable) {
        if (isEditable != this.isEditable()) {
            super.setEditable(isEditable);
            if (this.getBackground() instanceof ColorUIResource) {
                this.setBackground(UIManager.getColor(isEditable ? "org.igoweb.inputBg" : "org.igoweb.outputBg"));
            }
        }
    }
}

