/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.igoweb.util.swing.Prefs;

public class AFrame
extends JFrame {
    private boolean isPainted = false;
    public static boolean exitWhenAllWindowsClosed = true;
    private static Runnable exitChecker = new Runnable(){

        @Override
        public void run() {
            if (exitWhenAllWindowsClosed) {
                Frame[] frames = Frame.getFrames();
                if (frames != null) {
                    for (int i = 0; i < frames.length; ++i) {
                        if (!frames[i].isDisplayable()) continue;
                        return;
                    }
                }
                System.exit(0);
            }
        }
    };

    public AFrame(Component parent) {
        this.setup(parent);
    }

    public AFrame() {
        this.setup(null);
    }

    public AFrame(String name) {
        super(name);
        this.setup(null);
    }

    public AFrame(String name, Component parent) {
        super(name);
        this.setup(parent);
    }

    private static void setOrient(Container cont, ComponentOrientation orient) {
        for (int i = cont.getComponentCount() - 1; i >= 0; --i) {
            Component comp = cont.getComponent(i);
            comp.setComponentOrientation(orient);
            if (!(comp instanceof Container)) continue;
            AFrame.setOrient((Container)comp, orient);
        }
    }

    private void setup(Component parent) {
        this.setContentPane(new ContentPane());
        Image iconImg = (Image)UIManager.getDefaults().get("AFrame.defaultIcon");
        if (iconImg != null) {
            this.setIconImage(iconImg);
        }
        this.setDefaultCloseOperation(2);
        if (parent != null) {
            while (!(parent instanceof Window) && parent.getParent() != null) {
                parent = parent.getParent();
            }
            if (parent instanceof Window) {
                final Window topParent = (Window)parent;
                WindowAdapter wl = new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent event) {
                        if (event.getSource() == topParent) {
                            AFrame.this.dispose();
                        } else {
                            topParent.removeWindowListener(this);
                        }
                    }
                };
                topParent.addWindowListener(wl);
                this.addWindowListener(wl);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.isShowing()) {
            this.savePosition();
        }
        super.dispose();
        SwingUtilities.invokeLater(exitChecker);
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isPainted) {
            this.isPainted = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AFrame.this.firstPaint();
                }
            });
        }
    }

    public void firstPaint() {
    }

    @Override
    public Dimension getPreferredSize() {
        Rectangle savedSize;
        String spp = this.getSavePositionPref();
        if (spp != null && (savedSize = (Rectangle)Prefs.getObj(spp, null)) != null) {
            Dimension screenSize = this.getToolkit().getScreenSize();
            if (savedSize.width > screenSize.width - 15) {
                savedSize.width = screenSize.width - 15;
            }
            if (savedSize.height > screenSize.height - 15) {
                savedSize.height = screenSize.height - 15;
            }
            Dimension min = (Dimension)this.getMinimumSize().clone();
            if (min.width < savedSize.width) {
                min.width = savedSize.width;
            }
            if (min.height < savedSize.height) {
                min.height = savedSize.height;
            }
            return min;
        }
        return this.getDefaultPreferredSize();
    }

    public Dimension getDefaultPreferredSize() {
        return super.getPreferredSize();
    }

    protected String getSavePositionPref() {
        return null;
    }

    @Override
    public void pack() {
        this.pack(null);
    }

    public void pack(Component parent) {
        AFrame.setOrient(this, ComponentOrientation.getOrientation(Locale.getDefault()));
        super.pack();
        if (!this.isShowing()) {
            Rectangle bounds;
            String spp = this.getSavePositionPref();
            if (spp != null) {
                int stateFlags = Prefs.getInt(spp + 'f', 0);
                this.setExtendedState(stateFlags);
                if ((stateFlags & 6) != 0) {
                    return;
                }
            }
            Dimension screenSize = this.getToolkit().getScreenSize();
            Dimension mySize = this.getSize();
            int x = Integer.MAX_VALUE;
            int y = 0;
            if (spp != null && (bounds = (Rectangle)Prefs.getObj(spp, null)) != null) {
                x = bounds.x;
                y = bounds.y;
                if (x + mySize.width / 2 > screenSize.width) {
                    x = screenSize.width - mySize.width / 2;
                } else if (x + mySize.width / 2 < 0) {
                    x = -(mySize.width / 2);
                }
                if (y + mySize.height / 2 > screenSize.height) {
                    y = screenSize.height - mySize.height / 2;
                } else if (y + mySize.height / 2 < 0) {
                    y = -(mySize.height / 2);
                }
            } else {
                while (parent != null && !parent.isShowing()) {
                    parent = parent.getParent();
                }
                if (parent != null) {
                    Point onScreen = parent.getLocationOnScreen();
                    x = onScreen.x + (parent.getWidth() - mySize.width) / 2;
                    y = onScreen.y + (parent.getHeight() - mySize.height) / 2;
                }
            }
            if (x == Integer.MAX_VALUE) {
                x = (screenSize.width - mySize.width) / 2;
                y = (screenSize.height - mySize.height) / 2;
            }
            this.setLocation(x, y);
        }
    }

    @Override
    public void toFront() {
        if (this.getState() != 0) {
            this.setState(0);
        }
        super.toFront();
    }

    public static JPanel createBorderedPanel(LayoutManager layout) {
        return AFrame.createBorderedPanel(new JPanel(layout));
    }

    public static JPanel createBorderedPanel(JPanel jp) {
        jp.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        return jp;
    }

    @Override
    public void hide() {
        if (this.isShowing()) {
            this.savePosition();
        }
        super.hide();
    }

    @Override
    public void setVisible(boolean newVisible) {
        if (!newVisible && this.isShowing()) {
            this.savePosition();
        }
        super.setVisible(newVisible);
    }

    private void savePosition() {
        int stateFlags;
        String spp = this.getSavePositionPref();
        if (spp != null && ((stateFlags = this.getExtendedState()) & 1) == 0) {
            Prefs.putInt(spp + 'f', stateFlags);
            if ((stateFlags & 6) == 0) {
                Prefs.putObj(spp, this.getBounds());
            }
        }
    }

    public static class ContentPane
    extends JPanel {
        public ContentPane() {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Paint paint = (Paint)UIManager.getDefaults().get("AFrame.backgroundPaint");
            if (paint != null) {
                g2d.setPaint(paint);
            }
            g2d.fill(g2d.getClip());
            this.paintChildren(g);
        }
    }
}

