/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.util;

public class MemoryMonitor
implements Runnable {
    private final int delay;
    private Thread thread;

    public MemoryMonitor(int delay) {
        this.delay = delay;
        new Thread(this).start();
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    @Override
    public void run() {
        try {
            Runtime runtime = Runtime.getRuntime();
            while (true) {
                runtime.gc();
                System.err.println("Memory in use: " + (runtime.totalMemory() - runtime.freeMemory()));
                Thread.sleep(this.delay);
            }
        }
        catch (InterruptedException excep) {
            System.err.println("Memory monitor halted.");
            return;
        }
    }
}

