/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.shared.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.igoweb.igoweb.Config;
import org.igoweb.igoweb.shared.AuthLevel;
import org.igoweb.igoweb.shared.User;
import org.igoweb.util.Bundle;
import org.igoweb.util.DbConn;
import org.igoweb.util.DbConnFactory;
import org.igoweb.util.ThreadPool;
import org.igoweb.util.xml.HtmlUtil;

public class Mailer {
    public final Bundle.Multi<?> multiRes;
    private Transport transport;
    private boolean busy = true;
    private long transportDisconnectDelay = 10000L;
    private final ThreadPool threadPool;
    private ThreadPool.DelayedTask disconnectTask;
    private static DataSource kgsIcon = new KgsIconSource("kgsIcon.png", "image/png");
    public final Logger logger;
    private static final Session session;

    public Mailer(Logger logger, Bundle.Multi<?> multiRes, ThreadPool threadPool) {
        this.logger = logger;
        this.multiRes = multiRes;
        this.threadPool = threadPool == null ? new ThreadPool(1) : threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransportDisconnectDelay(long ms) {
        if (ms <= 0L) {
            throw new IllegalArgumentException("Must be positive value");
        }
        Mailer mailer = this;
        synchronized (mailer) {
            this.transportDisconnectDelay = ms;
        }
    }

    public final void send(UserData dest, String title, String body, boolean wrapBody, boolean includeIcon) throws MailException {
        this.send(new UserData[]{dest}, title, body, wrapBody, includeIcon);
    }

    public void send(UserData[] dests, String title, String body, boolean wrapBody, boolean includeIcon) throws MailException {
        String charSet = dests.length > 1 ? "UTF8" : dests[0].bundle.str(-669080758);
        InternetAddress[] addrs = new InternetAddress[dests.length];
        for (int i = 0; i < dests.length; ++i) {
            addrs[i] = dests[i].getFullAddress();
        }
        this.send(addrs, title, wrapBody ? Mailer.wrapHtmlHeaders(body, title, charSet, includeIcon) : body, charSet);
    }

    public final void send(InternetAddress dest, String title, String body, String encoding) throws MailException {
        this.send(new InternetAddress[]{dest}, title, body, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(InternetAddress[] dests, String title, String body, String encoding) throws MailException {
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress("admin@gokgs.com", "KGS Go Server"));
            for (InternetAddress addr : dests) {
                message.addRecipient(Message.RecipientType.TO, (Address)addr);
            }
            message.setSubject(MimeUtility.encodeText((String)title, (String)encoding, null));
            MimeMultipart messageContent = new MimeMultipart("related");
            MimeMultipart htmlContent = new MimeMultipart("alternative");
            MimeBodyPart bp = new MimeBodyPart();
            bp.setText(HtmlUtil.htmlToText(body), encoding);
            htmlContent.addBodyPart((BodyPart)bp);
            bp = new MimeBodyPart();
            bp.setContent((Object)body, "text/html; charset=" + encoding);
            htmlContent.addBodyPart((BodyPart)bp);
            bp = new MimeBodyPart();
            bp.setContent((Multipart)htmlContent);
            messageContent.addBodyPart((BodyPart)bp);
            bp = new MimeBodyPart();
            bp.setDataHandler(new DataHandler(kgsIcon));
            bp.setHeader("Content-ID", "<kgsIcon.png>");
            bp.setDisposition("attachment");
            bp.setFileName("kgsIcon.png");
            messageContent.addBodyPart((BodyPart)bp);
            message.setContent((Multipart)messageContent);
            message.setSentDate(new Date());
            message.saveChanges();
            int failedConnections = 1;
            Mailer mailer = this;
            synchronized (mailer) {
                if (this.transport == null) {
                    this.transport = session.getTransport("smtp");
                }
                while (!this.transport.isConnected()) {
                    try {
                        this.transport.connect(Config.get("smtpHost"), null, null);
                        if (this.disconnectTask != null) {
                            this.disconnectTask.cancel();
                        }
                        this.disconnectTask = this.threadPool.scheduleWithFixedDelay(new Runnable(){

                            @Override
                            public void run() {
                                Mailer.this.delayedDisconnectTransport();
                            }
                        }, this.transportDisconnectDelay, this.transportDisconnectDelay);
                    }
                    catch (MessagingException excep) {
                        if (excep.getNextException() instanceof ConnectException) {
                            if (failedConnections >= 10) {
                                throw new MailException(failedConnections + " failures to connect to SMTP host. Giving up.");
                            }
                            ++failedConnections;
                            this.logger.log(Level.WARNING, "Error connecting to SMTP transport. Will try again in 1 minute.", excep);
                            Thread.sleep(60000L);
                            continue;
                        }
                        throw excep;
                    }
                }
                this.transport.sendMessage((Message)message, message.getAllRecipients());
                this.busy = true;
            }
        }
        catch (UnsupportedEncodingException excep) {
            throw new MailException("Encoding error trying to send email", excep);
        }
        catch (SendFailedException excep) {
            Level level = Level.INFO;
            boolean unsentFound = false;
            Address[] addrs = excep.getValidUnsentAddresses();
            if (addrs != null) {
                for (Address addr : addrs) {
                    level = Level.WARNING;
                    unsentFound = true;
                    this.logger.log(level, "Error sending to valid address " + addr, excep);
                }
            }
            if ((addrs = excep.getInvalidAddresses()) != null) {
                for (Address addr : excep.getInvalidAddresses()) {
                    unsentFound = true;
                    this.logger.log(level, "Error sending to invalid address " + addr, excep);
                }
            }
            if (!unsentFound) {
                throw new MailException("Got a send error, but no list of unsent addresses", excep);
            }
        }
        catch (MessagingException excep) {
            Mailer mailer = this;
            synchronized (mailer) {
                if (this.transport != null) {
                    try {
                        this.transport.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.transport = null;
                }
                if (this.disconnectTask != null) {
                    this.disconnectTask.cancel();
                    this.disconnectTask = null;
                }
            }
            throw new MailException("Messaging exception while sending email: " + excep.getMessage(), excep);
        }
        catch (InterruptedException excep) {
            throw new RuntimeException("Interrupted while waiting", excep);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayedDisconnectTransport() {
        Mailer mailer = this;
        synchronized (mailer) {
            if (this.busy) {
                this.busy = false;
            } else {
                try {
                    if (this.transport != null) {
                        this.transport.close();
                    }
                }
                catch (MessagingException excep) {
                    this.logger.log(Level.WARNING, "Error closing transport", excep);
                }
                this.transport = null;
                if (this.disconnectTask != null) {
                    this.disconnectTask.cancel();
                    this.disconnectTask = null;
                }
            }
        }
    }

    public static InternetAddress buildAddress(String realName, String accountName, String email) throws AddressException {
        if (email == null) {
            throw new IllegalArgumentException("Can't have a null email address");
        }
        try {
            InternetAddress result = new InternetAddress(email, realName == null ? accountName : realName + " (" + accountName + ')', "UTF-8");
            result.validate();
            return result;
        }
        catch (UnsupportedEncodingException excep) {
            throw new RuntimeException("UTF-8 is not supported?", excep);
        }
    }

    public static String wrapHtmlHeaders(String in, String title, String charSet, boolean appendIcon) {
        return "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 TRANSITIONAL//EN\">\n<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + charSet + "\"><title>" + title + "</title></head><body>" + in + (appendIcon ? "<p align=\"center\"><a href=\"http://" + Config.get("webHost") + "/\"><img align=\"center\" border=\"0\" src=\"cid:kgsIcon.png\" alt=\"KGS\"></a></p></body></html>" : "</body></html>");
    }

    static {
        Properties props = System.getProperties();
        props.put("mail.from", "KGS Administrator <" + Config.get("adminEmail") + ">");
        props.put("mail.host", Config.get("smtpHost"));
        props.put("mail.smtp.host", Config.get("smtpHost"));
        props.put("mail.transport.protocol", "smtp");
        session = Session.getDefaultInstance((Properties)props, null);
    }

    private static class KgsIconSource
    implements DataSource {
        private final byte[] data;
        private final String contentType;

        public KgsIconSource(String path, String contentType) {
            this.contentType = contentType;
            try {
                InputStream in = this.getClass().getResourceAsStream(path);
                this.data = this.readStream(in);
                in.close();
            }
            catch (IOException excep) {
                throw new RuntimeException("Cannot load icon", excep);
            }
        }

        private byte[] readStream(InputStream in) throws IOException {
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            int cIn;
            while ((cIn = in.read()) != -1) {
                bytesOut.write(cIn);
            }
            return bytesOut.toByteArray();
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.data);
        }

        public String getName() {
            return "kgsIcon.png";
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Cannot write to object");
        }
    }

    public static class MailException
    extends Exception {
        public MailException(String description) {
            super(description);
        }

        public MailException(String description, Throwable rootCause) {
            super(description, rootCause);
        }
    }

    public static class UserData {
        public final Bundle bundle;
        public final String accountName;
        public final String realName;
        public final String email;
        public final int authLevel;
        private InternetAddress fullAddress;

        public UserData(Bundle bundle, String accountName, String email, String realName, int authLevel) throws MailException {
            if (email == null) {
                throw new MailException("Null email for " + accountName);
            }
            this.bundle = bundle;
            this.accountName = accountName;
            this.email = email;
            this.realName = realName;
            this.authLevel = authLevel;
            try {
                this.fullAddress = Mailer.buildAddress(realName, accountName, email);
            }
            catch (AddressException excep) {
                throw new MailException("Illegal email address for " + accountName + ": " + email, excep);
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public UserData(String accountName, boolean isActive, Bundle.Multi<?> multiRes, DbConnFactory dbFactory) throws MailException {
            DbConn db = dbFactory.getDbConn();
            ResultSet rs = null;
            try {
                PreparedStatement ps = db.get("SELECT name, locale, personal_email, personal_name, auth_level  FROM accounts, accounts_active  WHERE canon_name = ? AND state = ? AND account_id = id");
                ps.setString(1, User.canonName(accountName));
                ps.setString(2, isActive ? "active" : "pending");
                rs = ps.executeQuery();
                if (!rs.next()) throw new MailException("User " + accountName + " is not in SQL database");
                String localeName = rs.getString("locale");
                Bundle tmpBundle = (Bundle)multiRes.get(localeName);
                this.bundle = tmpBundle == null ? (Bundle)multiRes.get(Config.get("masterLocale")) : tmpBundle;
                this.accountName = accountName = rs.getString("name");
                this.realName = rs.getString("personal_name");
                this.email = rs.getString("personal_email");
                this.authLevel = AuthLevel.fromSql(rs.getString("auth_level"));
                if (this.email == null) {
                    throw new MailException("User " + accountName + " has a null email address");
                }
                this.fullAddress = Mailer.buildAddress(this.realName, accountName, this.email);
                db.close(rs);
                return;
            }
            catch (AddressException excep) {
                try {
                    throw new MailException("Illegal email address for " + accountName, excep);
                    catch (SQLException excep2) {
                        db.error();
                        throw new RuntimeException(excep2);
                    }
                }
                catch (Throwable throwable) {
                    db.close(rs);
                    throw throwable;
                }
            }
        }

        public InternetAddress getFullAddress() {
            return this.fullAddress;
        }
    }
}

