/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf.gameInfo;

import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import org.igoweb.util.Defs;

public class DateInfo {
    private static final MessageFormat sgfDateFormatter = new MessageFormat("{0,choice,0#|1#{0,number,0000}-}{1,choice,0#|1#{1,number,00}-}{2,choice,0#|1#{2,number,00}-}");
    private static SimpleDateFormat[] dateFormats = null;
    private int year;
    private int month;
    private int day;
    private String text;
    private GregorianCalendar calendar = new GregorianCalendar();

    public DateInfo() {
        if (dateFormats == null) {
            dateFormats = this.makeDateFormats();
        }
        this.year = 0;
        this.month = 0;
        this.day = 0;
        this.text = "";
    }

    public DateInfo(String sgfText, DateInfo prevDate) throws ParseException {
        if (dateFormats == null) {
            dateFormats = this.makeDateFormats();
        }
        int[] values = new int[3];
        int numValues = 0;
        StringTokenizer datePieces = new StringTokenizer(sgfText, "-");
        while (datePieces.hasMoreElements()) {
            if (numValues >= 3) {
                throw new ParseException("Too many fields in date " + sgfText, 0);
            }
            String strVal = datePieces.nextToken();
            if (strVal.length() == 4) {
                if (numValues != 0) {
                    throw new ParseException("Year not first in " + sgfText, 0);
                }
            } else if (strVal.length() <= 2 && strVal.length() > 0) {
                if (numValues == 0) {
                    values[numValues++] = 0;
                }
            } else {
                throw new ParseException("Odd field " + strVal, 0);
            }
            try {
                values[numValues++] = Integer.parseInt(strVal);
            }
            catch (NumberFormatException excep) {
                throw new ParseException("Odd field " + strVal, 0);
            }
        }
        if (numValues < 1) {
            throw new ParseException("Empty date", 0);
        }
        if (values[0] == 0) {
            if (prevDate == null) {
                throw new ParseException("Can't make a shortcut with no prev", 0);
            }
            if (numValues == 2 && prevDate.month > 0) {
                if (prevDate.day == 0) {
                    values[0] = prevDate.year;
                } else {
                    values[2] = values[1];
                    values[0] = prevDate.year;
                    values[1] = prevDate.month;
                    numValues = 3;
                }
            } else if (numValues == 3) {
                values[0] = prevDate.year;
            } else {
                throw new ParseException("Invalid shortcut " + sgfText, 0);
            }
        }
        this.year = values[0];
        this.month = values[1];
        this.day = values[2];
        if (numValues >= 2 && (this.month < 1 || this.month > 12)) {
            throw new ParseException("Bad month in " + sgfText, 0);
        }
        if (numValues == 3 && (this.day < 1 || this.day > this.calendar.getMaximum(5))) {
            throw new ParseException("Bad day in " + sgfText, 0);
        }
    }

    public String toSgf(DateInfo prevDate) {
        Object[] args = new Object[3];
        StringBuilder result = new StringBuilder();
        if (prevDate == null) {
            args[0] = new Integer(this.year);
            args[1] = new Integer(this.month);
            args[2] = new Integer(this.day);
        } else {
            boolean valid = false;
            if (this.year == prevDate.year) {
                args[0] = new Integer(0);
            } else {
                args[0] = new Integer(this.year);
                valid = true;
            }
            if (this.month == prevDate.month && this.year == prevDate.year) {
                args[1] = new Integer(0);
            } else {
                args[1] = new Integer(this.month);
                valid |= this.month > 0;
            }
            args[2] = new Integer(this.day);
            if (!(valid |= this.day > 0)) {
                return null;
            }
        }
        result.append(sgfDateFormatter.format(args));
        result.setLength(result.length() - 1);
        return result.toString();
    }

    public boolean comesBefore(DateInfo next) {
        return this.year < next.year || this.year == next.year && (this.month < next.month || this.month == next.month && this.day < next.day);
    }

    public SimpleDateFormat[] makeDateFormats() {
        return new SimpleDateFormat[]{new SimpleDateFormat(Defs.getString(-478254164)), new SimpleDateFormat(Defs.getString(-478254163)), new SimpleDateFormat(Defs.getString(-478254162))};
    }

    public String getText() {
        if (this.text == null) {
            SimpleDateFormat fmt = this.month == 0 ? dateFormats[0] : (this.day == 0 ? dateFormats[1] : dateFormats[2]);
            this.text = fmt.format(this.getDate());
        }
        return this.text;
    }

    public Date getDate() {
        this.calendar.set(1, this.year);
        this.calendar.set(2, this.month == 0 ? 0 : this.month - 1 + 0);
        this.calendar.set(5, this.day == 0 ? 1 : this.day);
        return this.calendar.getTime();
    }

    public int getYear() {
        return this.year;
    }

    public void setYear(int newYear) {
        if (this.year != newYear) {
            this.year = newYear;
            this.text = null;
        }
    }

    public int getMonth() {
        return this.month;
    }

    public void setMonth(int newMonth) {
        if (this.month != newMonth) {
            this.month = newMonth;
            if (this.month == 0) {
                this.day = 0;
            }
            this.text = null;
        }
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int newDay) {
        if (this.day != newDay) {
            this.day = newDay;
            if (this.day != 0 && this.month == 0) {
                this.month = 1;
            }
            this.text = null;
        }
    }

    public String toString() {
        return "DateInfo[year=" + this.year + ", month=" + this.month + ", day=" + this.day + ']';
    }
}

