/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.go.swing.sgf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Collator;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.igoweb.go.sgf.Node;
import org.igoweb.go.sgf.Prop;
import org.igoweb.go.sgf.Tree;
import org.igoweb.util.Defs;
import org.igoweb.util.Event;
import org.igoweb.util.EventListener;
import org.igoweb.util.swing.AList;
import org.igoweb.util.swing.DFrame;
import org.igoweb.util.swing.SortedListModel;

public class NodeNameListWin
extends DFrame {
    private final Tree tree;
    private static final Comparator<Node> nodeComparator = new Comparator<Node>(){
        private final Collator coll = Collator.getInstance();

        @Override
        public int compare(Node n1, Node n2) {
            return this.coll.compare(n1.findProp(28).getText(), n2.findProp(28).getText());
        }
    };
    private final SortedListModel<Node> listModel = new SortedListModel<Node>(nodeComparator);
    private final AList<Node> list = new AList<Node>(new NodeRenderer(), 3, new EventListener(){

        @Override
        public void handleEvent(Event event) {
            NodeNameListWin.this.tree.setActiveNode((Node)event.arg);
        }
    }, this.listModel);
    private final EventListener nodeListener = new EventListener(){

        @Override
        public void handleEvent(Event event) {
            NodeNameListWin.this.nodeEvent(event);
        }
    };

    public NodeNameListWin(Tree tree, Component parent) {
        super(Defs.getString(1096335322), parent);
        this.tree = tree;
        this.addButton(Defs.getString(1436228518), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NodeNameListWin.this.dispose();
            }
        });
        tree.addListener(this.nodeListener);
        this.getMainPanel().add("xGrow=t,yGrow=t", this.list);
        Node.NodeIterator iter = tree.nodes();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            if (node.findProp(28) == null) continue;
            this.listModel.add(node);
        }
        this.listModel.sortNow();
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void dispose() {
        this.tree.removeListener(this.nodeListener);
        super.dispose();
    }

    private void nodeEvent(Event event) {
        switch (event.type) {
            case 1: {
                Prop param = (Prop)event.arg;
                if (param.type != 28) break;
                this.listModel.remove(event.source);
                this.listModel.sortNow();
                break;
            }
            case 0: {
                Prop param = (Prop)event.arg;
                if (param.type != 28) break;
                this.listModel.add((Node)event.source);
                this.listModel.sortNow();
                break;
            }
            case 7: {
                this.listModel.changed((Node)event.source);
                this.listModel.changed(this.tree.getNode((Integer)event.arg));
            }
        }
    }

    @Override
    protected String getSavePositionPref() {
        return "^Ict' 3E";
    }

    private class NodeRenderer
    extends JComponent
    implements ListCellRenderer<Node> {
        private final Font stdFont = UIManager.getFont("Label.font");
        private final Font boldFont = this.stdFont.deriveFont(1);
        private Node currentNode;

        @Override
        public Component getListCellRendererComponent(JList<? extends Node> listGui, Node currentNode, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(UIManager.getColor(((AList.InnerList)listGui).mouseUnder() == currentNode ? "org.igoweb.selTextBg" : "org.igoweb.inputBg"));
            this.setEnabled(listGui.isEnabled());
            return this;
        }

        @Override
        public Dimension getMinimumSize() {
            int fontH = UIManager.getInt("org.igoweb.fontH");
            return new Dimension((17 * fontH + 1) / 2, fontH);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        @Override
        public void paint(Graphics g) {
            if (this.currentNode == null) {
                return;
            }
            g.setColor(this.getBackground());
            int width = this.getWidth();
            g.fillRect(0, 0, width, this.getHeight());
            Font font = this.currentNode == NodeNameListWin.this.tree.getActiveNode() ? this.boldFont : this.stdFont;
            g.setFont(font);
            g.setColor(UIManager.getColor("Label.foreground"));
            g.drawString(this.currentNode.findProp(28).getText(), 2, g.getFontMetrics().getAscent());
        }
    }
}

