/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.igoweb.go.Rules;
import org.igoweb.go.swing.RulesWidget;
import org.igoweb.util.Defs;

class LitRulesWidget
extends RulesWidget
implements ActionListener {
    private Timer timer = new Timer(500, this);
    private boolean editRules = true;
    private boolean editHcap = true;
    private boolean useNigiri;
    private boolean blinkBlitz;

    public LitRulesWidget(Rules rules, boolean isEditable) {
        super(rules, true, true, isEditable);
        if (isEditable) {
            BlitzListener timeChangeListener = new BlitzListener();
            this.addFieldChangeListener(4, timeChangeListener);
            this.addFieldChangeListener(5, timeChangeListener);
            this.addFieldChangeListener(6, timeChangeListener);
            this.addFieldChangeListener(7, timeChangeListener);
            this.addFieldChangeListener(8, timeChangeListener);
        }
    }

    public void setUseNigiri(boolean useNigiri) {
        this.useNigiri = useNigiri;
        this.setField(2);
        this.setField(3);
    }

    public void setRulesEditable(boolean editRules) {
        this.editRules = editRules;
        for (int i = 0; i < 9; ++i) {
            this.setField(i);
        }
    }

    public void setHcapEditable(boolean editHcap) {
        this.editHcap = editHcap;
        this.setField(2);
        this.setField(3);
    }

    public void setBlinkBlitz(boolean blink) {
        if (this.blinkBlitz != blink) {
            this.blinkBlitz = blink;
            this.testBlitzChange();
        }
    }

    @Override
    protected boolean isEditable(int field) {
        return (field == 2 || field == 3 ? this.editHcap && !this.useNigiri : this.editRules) && super.isEditable(field);
    }

    @Override
    protected float getMaxKomi() {
        return 100.0f;
    }

    @Override
    protected int getMaxHandicap() {
        return 9;
    }

    public void highlightChanges(Rules expectedRules) {
        Rules rules = this.getRules();
        if (expectedRules == null) {
            expectedRules = rules;
        }
        this.setHighlight(0, rules.getType() != expectedRules.getType());
        this.setHighlight(1, rules.getSize() != expectedRules.getSize());
        this.setHighlight(2, rules.getHandicap() != expectedRules.getHandicap());
        this.setHighlight(3, rules.getKomi() != expectedRules.getKomi());
        this.setHighlight(4, rules.getTimeSystem() != expectedRules.getTimeSystem());
        this.setHighlight(5, rules.getMainTime() != expectedRules.getMainTime());
        this.setHighlight(6, rules.getByoYomiTime() != expectedRules.getByoYomiTime());
        this.setHighlight(7, rules.getByoYomiPeriods() != expectedRules.getByoYomiPeriods());
        this.setHighlight(8, rules.getByoYomiStones() != expectedRules.getByoYomiStones());
    }

    @Override
    public void setRules(Rules newRules) {
        super.setRules(newRules);
        this.testBlitzChange();
    }

    private void testBlitzChange() {
        int sz;
        if (!this.verifyInput(false)) {
            return;
        }
        long estTime = (long)this.getRules().estimateTimePerPlayer() * 19L * 19L;
        int stringId = estTime <= (long)(450 * (sz = this.getRules().getSize()) * sz) ? -903340823 : (estTime <= (long)(900 * sz * sz) ? -903340667 : -451068480);
        String tsTitle = Defs.getString(stringId);
        boolean shouldBlink = false;
        Font font = this.getFont();
        if (stringId != -451068480) {
            font = font.deriveFont(1);
            shouldBlink = this.blinkBlitz;
        }
        if (!(this.timer == null || tsTitle.equals(this.timeSystemBorder.getTitle()) && shouldBlink == this.timer.isRunning())) {
            this.timeSystemBorder.setTitle(tsTitle);
            if (shouldBlink) {
                if (!this.timer.isRunning()) {
                    this.timeSystemBorder.setTitleFont(font);
                    this.timer.start();
                }
            } else {
                this.timeSystemBorder.setTitle(Defs.getString(stringId));
                this.timeSystemBorder.setTitleColor(this.getForeground());
                this.timeSystemBorder.setTitleFont(font);
                this.timer.stop();
            }
            this.repaint();
        }
    }

    @Override
    public void removeNotify() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        super.removeNotify();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Color fg = this.getForeground();
        this.timeSystemBorder.setTitleColor(this.timeSystemBorder.getTitleColor().equals(fg) ? this.getBackground() : fg);
        this.repaint();
    }

    private class BlitzListener
    implements ActionListener,
    Runnable {
        private boolean set = false;

        private BlitzListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!this.set) {
                SwingUtilities.invokeLater(this);
                this.set = true;
            }
        }

        @Override
        public void run() {
            this.set = false;
            LitRulesWidget.this.testBlitzChange();
        }
    }
}

