/*
 * Decompiled with CFR 0.152.
 */
package com.gokgs.client.swing;

import com.gokgs.client.KCBundle;
import com.gokgs.client.KCGame;
import com.gokgs.client.KClient;
import com.gokgs.client.swing.KGameList;
import com.gokgs.client.swing.KGamePanel;
import com.gokgs.client.swing.KGuiClientUtil;
import com.gokgs.client.swing.KResumeMenu;
import com.gokgs.client.swing.KRoomPanel;
import com.gokgs.client.swing.KSimulWindow;
import com.gokgs.client.swing.KViewUserWindow;
import com.gokgs.client.swing.PlaybackWindow;
import com.gokgs.shared.KGameType;
import com.gokgs.shared.KRole;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import org.igoweb.go.swing.GameWindow;
import org.igoweb.igoweb.client.CDetailsChannel;
import org.igoweb.igoweb.client.CGame;
import org.igoweb.igoweb.client.CGlobalGames;
import org.igoweb.igoweb.client.CPlayback;
import org.igoweb.igoweb.client.CRoom;
import org.igoweb.igoweb.client.Client;
import org.igoweb.igoweb.client.ConnMutex;
import org.igoweb.igoweb.client.Connector;
import org.igoweb.igoweb.client.swing.GameList;
import org.igoweb.igoweb.client.swing.GlobalGamePanel;
import org.igoweb.igoweb.client.swing.GuiClient;
import org.igoweb.igoweb.client.swing.GuiClientUtil;
import org.igoweb.igoweb.client.swing.ResumeMenu;
import org.igoweb.igoweb.client.swing.RoomPanel;
import org.igoweb.igoweb.shared.ClientType;
import org.igoweb.igoweb.shared.IBundle;
import org.igoweb.util.Event;
import org.igoweb.util.swing.AFrame;
import org.igoweb.util.swing.SingletonWindow;

public class KGuiClient
extends GuiClient {
    private final SingletonWindow simulWindow = new SingletonWindow();

    public KGuiClient(String userName, String password, ClientType clientType, Connector connector) {
        super(userName, password, clientType, connector);
    }

    public KGuiClient(String userName, String password, ClientType clientType, Connector connector, long clientId) {
        super(userName, password, clientType, connector, clientId);
    }

    @Override
    protected void buildViewUserWindow(CDetailsChannel details, AFrame parent) {
        new KViewUserWindow(details, parent, this.getClient());
    }

    @Override
    protected RoomPanel buildRoomPanel(CRoom room, ResumeMenu resumeMenu) {
        return new KRoomPanel(room, this.getClient(), this.getClientWindow(), resumeMenu);
    }

    @Override
    protected Client buildClient(String userName, String password, ClientType clientType, long clientId, ConnMutex connMutex, Connector connector) {
        return new KClient(userName, password, clientType, clientId, connMutex, connector);
    }

    @Override
    protected void buildGameWindow(CGame game) {
        KGamePanel gameP = new KGamePanel(this.getClient(), (KCGame)game, this.getClientWindow());
        gameP.init();
        if (game.gameType == KGameType.SIMUL && game.getRole() == KRole.WHITE) {
            if (this.simulWindow.isOpen()) {
                ((KSimulWindow)this.simulWindow.getWindow()).addGame(gameP);
            } else {
                this.simulWindow.setWindow(new KSimulWindow(this.getClientWindow(), gameP));
                GuiClientUtil.addToWindowList(this.getClient(), this.simulWindow.getWindow());
            }
        } else {
            GuiClientUtil.addToWindowList(this.getClient(), new GameWindow(-903340719, this.getClientWindow(), gameP));
        }
    }

    @Override
    protected void buildPlaybackWindow(CPlayback playback) {
        new PlaybackWindow(this.getClient(), playback, this.getClientWindow());
    }

    @Override
    protected ResumeMenu buildResumeMenu() {
        return new KResumeMenu(this.getClient());
    }

    @Override
    protected GuiClientUtil buildGuiClientUtil() {
        return new KGuiClientUtil(this.getClient());
    }

    @Override
    public void handleEvent(Event event) {
        KCBundle bundle;
        super.handleEvent(event);
        if (event.type == 86 && (bundle = (KCBundle)IBundle.get()).isApril1()) {
            JCheckBoxMenuItem af = new JCheckBoxMenuItem("April Fools");
            af.setState(bundle.getAprilFools());
            JMenu menu = this.getClientWindow().getJMenuBar().getMenu(0);
            menu.addSeparator();
            menu.add(af);
            af.addActionListener(actionEvent -> bundle.setAprilFools(af.getState()));
        }
    }

    @Override
    protected GlobalGamePanel buildGlobalGamePanel(CGlobalGames gameList) {
        if (gameList == null) {
            throw new IllegalArgumentException();
        }
        return new GlobalGamePanel(this.getClient(), gameList){

            @Override
            public GameList buildGameList(CGlobalGames subGameList, Client client, int flags) {
                return new KGameList(subGameList, client, flags);
            }
        };
    }
}

