/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util.hll;

import org.apache.solr.util.hll.ISchemaVersion;
import org.apache.solr.util.hll.SchemaVersionOne;

class SerializationUtil {
    static int REGISTER_WIDTH_BITS = 3;
    static int REGISTER_WIDTH_MASK = (1 << REGISTER_WIDTH_BITS) - 1;
    static int LOG2_REGISTER_COUNT_BITS = 5;
    static int LOG2_REGISTER_COUNT_MASK = (1 << LOG2_REGISTER_COUNT_BITS) - 1;
    static int EXPLICIT_CUTOFF_BITS = 6;
    static int EXPLICIT_CUTOFF_MASK = (1 << EXPLICIT_CUTOFF_BITS) - 1;
    private static int NIBBLE_BITS = 4;
    private static int NIBBLE_MASK = (1 << NIBBLE_BITS) - 1;
    public static ISchemaVersion VERSION_ONE;
    public static ISchemaVersion DEFAULT_SCHEMA_VERSION;
    public static ISchemaVersion[] REGISTERED_SCHEMA_VERSIONS;

    SerializationUtil() {
    }

    public static ISchemaVersion getSchemaVersion(int schemaVersionNumber) {
        if (schemaVersionNumber >= REGISTERED_SCHEMA_VERSIONS.length || schemaVersionNumber < 0) {
            throw new RuntimeException("Invalid schema version number " + schemaVersionNumber);
        }
        ISchemaVersion schemaVersion = REGISTERED_SCHEMA_VERSIONS[schemaVersionNumber];
        if (schemaVersion == null) {
            throw new RuntimeException("Unknown schema version number " + schemaVersionNumber);
        }
        return schemaVersion;
    }

    public static ISchemaVersion getSchemaVersion(byte[] bytes) {
        byte versionByte = bytes[0];
        int schemaVersionNumber = SerializationUtil.schemaVersion(versionByte);
        return SerializationUtil.getSchemaVersion(schemaVersionNumber);
    }

    public static byte packVersionByte(int schemaVersion, int typeOrdinal) {
        return (byte)((NIBBLE_MASK & schemaVersion) << NIBBLE_BITS | NIBBLE_MASK & typeOrdinal);
    }

    public static byte packCutoffByte(int explicitCutoff, boolean sparseEnabled) {
        int sparseBit = sparseEnabled ? 1 << EXPLICIT_CUTOFF_BITS : 0;
        return (byte)(sparseBit | EXPLICIT_CUTOFF_MASK & explicitCutoff);
    }

    public static byte packParametersByte(int registerWidth, int registerCountLog2) {
        int widthBits = registerWidth - 1 & REGISTER_WIDTH_MASK;
        int countBits = registerCountLog2 & LOG2_REGISTER_COUNT_MASK;
        return (byte)(widthBits << LOG2_REGISTER_COUNT_BITS | countBits);
    }

    public static boolean sparseEnabled(byte cutoffByte) {
        return (cutoffByte >>> EXPLICIT_CUTOFF_BITS & 1) == 1;
    }

    public static int explicitCutoff(byte cutoffByte) {
        return cutoffByte & EXPLICIT_CUTOFF_MASK;
    }

    public static int schemaVersion(byte versionByte) {
        return NIBBLE_MASK & versionByte >>> NIBBLE_BITS;
    }

    public static int typeOrdinal(byte versionByte) {
        return versionByte & NIBBLE_MASK;
    }

    public static int registerWidth(byte parametersByte) {
        return (parametersByte >>> LOG2_REGISTER_COUNT_BITS & REGISTER_WIDTH_MASK) + 1;
    }

    public static int registerCountLog2(byte parametersByte) {
        return parametersByte & LOG2_REGISTER_COUNT_MASK;
    }

    static {
        DEFAULT_SCHEMA_VERSION = VERSION_ONE = new SchemaVersionOne();
        REGISTERED_SCHEMA_VERSIONS = new ISchemaVersion[16];
        SerializationUtil.REGISTERED_SCHEMA_VERSIONS[1] = VERSION_ONE;
    }
}

