/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import org.apache.solr.common.SolrException;
import org.apache.solr.handler.component.DateStatsValues;
import org.apache.solr.handler.component.EnumStatsValues;
import org.apache.solr.handler.component.NumericStatsValues;
import org.apache.solr.handler.component.SortedDateStatsValues;
import org.apache.solr.handler.component.SortedNumericStatsValues;
import org.apache.solr.handler.component.StatsField;
import org.apache.solr.handler.component.StatsValues;
import org.apache.solr.handler.component.StringStatsValues;
import org.apache.solr.schema.AbstractEnumField;
import org.apache.solr.schema.DatePointField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.PointField;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.schema.TrieField;

public class StatsValuesFactory {
    public static StatsValues createStatsValues(StatsField statsField) {
        SchemaField sf = statsField.getSchemaField();
        if (null == sf) {
            return new NumericStatsValues(statsField);
        }
        FieldType fieldType = sf.getType();
        if (TrieDateField.class.isInstance(fieldType) || DatePointField.class.isInstance(fieldType)) {
            DateStatsValues statsValues = new DateStatsValues(statsField);
            if (sf.multiValued()) {
                return new SortedDateStatsValues(statsValues, statsField);
            }
            return statsValues;
        }
        if (TrieField.class.isInstance(fieldType) || PointField.class.isInstance(fieldType)) {
            NumericStatsValues statsValue = new NumericStatsValues(statsField);
            if (sf.multiValued()) {
                return new SortedNumericStatsValues(statsValue, statsField);
            }
            return statsValue;
        }
        if (StrField.class.isInstance(fieldType)) {
            return new StringStatsValues(statsField);
        }
        if (AbstractEnumField.class.isInstance(fieldType)) {
            return new EnumStatsValues(statsField);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field type " + fieldType + " is not currently supported");
    }
}

