/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

class LimitStream
extends TupleStream {
    private final TupleStream stream;
    private final int limit;
    private final int offset;
    private int count;

    LimitStream(TupleStream stream, int limit) {
        this(stream, limit, 0);
    }

    LimitStream(TupleStream stream, int limit, int offset) {
        this.stream = stream;
        this.limit = limit;
        this.offset = offset > 0 ? offset : 0;
        this.count = 0;
    }

    public void open() throws IOException {
        this.stream.open();
    }

    public void close() throws IOException {
        this.stream.close();
    }

    public List<TupleStream> children() {
        ArrayList<TupleStream> children = new ArrayList<TupleStream>();
        children.add(this.stream);
        return children;
    }

    public StreamComparator getStreamSort() {
        return this.stream.getStreamSort();
    }

    public void setStreamContext(StreamContext context) {
        this.stream.setStreamContext(context);
    }

    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.stream.toExplanation(factory)}).withFunctionName("SQL LIMIT").withExpression("--non-expressible--").withImplementingClass(((Object)((Object)this)).getClass().getName()).withExpressionType("stream-decorator");
    }

    public Tuple read() throws IOException {
        if (this.count == 0 && this.offset > 0) {
            while (this.count < this.offset) {
                ++this.count;
                Tuple skip = this.stream.read();
                if (!skip.EOF) continue;
                return skip;
            }
        }
        if (++this.count > this.limit + this.offset) {
            return Tuple.EOF();
        }
        return this.stream.read();
    }
}

