/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.tika.config.Initializable;
import org.apache.tika.config.InitializableProblemHandler;
import org.apache.tika.config.Param;
import org.apache.tika.exception.TikaConfigException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.jdbc.SQLite3DBParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SQLite3Parser
extends AbstractParser
implements Initializable {
    private static volatile boolean HAS_WARNED;
    private static final Object[] LOCK;
    private static final long serialVersionUID = -752276948656079347L;
    private static final MediaType MEDIA_TYPE;
    private static final Set<MediaType> SUPPORTED_TYPES;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        SQLite3DBParser p = new SQLite3DBParser();
        p.parse(stream, handler, metadata, context);
    }

    public void initialize(Map<String, Param> params) throws TikaConfigException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkInitialization(InitializableProblemHandler problemHandler) throws TikaConfigException {
        if (SUPPORTED_TYPES.size() != 0) return;
        if (HAS_WARNED) {
            return;
        }
        Object[] objectArray = LOCK;
        synchronized (LOCK) {
            if (HAS_WARNED) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            problemHandler.handleInitializableProblem("org.apache.tika.parser.SQLite3Parser", "org.xerial's sqlite-jdbc is not loaded.\nPlease provide the jar on your classpath to parse sqlite files.\nSee tika-parsers/pom.xml for the correct version.");
            HAS_WARNED = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    static {
        Set<MediaType> tmp;
        HAS_WARNED = false;
        LOCK = new Object[0];
        MEDIA_TYPE = MediaType.application((String)"x-sqlite3");
        try {
            Class.forName("org.sqlite.JDBC");
            tmp = Collections.singleton(MEDIA_TYPE);
        }
        catch (ClassNotFoundException e) {
            tmp = Collections.EMPTY_SET;
        }
        SUPPORTED_TYPES = Collections.unmodifiableSet(tmp);
    }
}

