/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.StyleConstants;
import javax.swing.text.ViewFactory;

public class LabelView
extends GlyphView {
    Color background;
    Color foreground;
    Font font;
    boolean strikeThrough;
    boolean underline;
    boolean subscript;
    boolean superscript;

    protected void setPropertiesFromAttributes() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        this.background = StyleConstants.getBackground(atts);
        this.foreground = StyleConstants.getForeground(atts);
        this.strikeThrough = StyleConstants.isStrikeThrough(atts);
        this.subscript = StyleConstants.isSubscript(atts);
        this.superscript = StyleConstants.isSuperscript(atts);
        this.underline = StyleConstants.isUnderline(atts);
        String family = StyleConstants.getFontFamily(atts);
        int size = StyleConstants.getFontSize(atts);
        int style = 0;
        if (StyleConstants.isBold(atts)) {
            style |= 1;
        }
        if (StyleConstants.isItalic(atts)) {
            style |= 2;
        }
        this.font = new Font(family, style, size);
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory vf) {
        this.setPropertiesFromAttributes();
    }

    public Color getBackground() {
        return this.background;
    }

    protected void setBackground(Color bg) {
        this.background = bg;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public Font getFont() {
        return this.font;
    }

    protected FontMetrics getFontMetrics() {
        return this.getContainer().getGraphics().getFontMetrics(this.font);
    }

    public boolean isUnderline() {
        return this.underline;
    }

    protected void setUnderline(boolean flag) {
        this.underline = flag;
    }

    public boolean isSubscript() {
        return this.subscript;
    }

    protected void setSubscript(boolean flag) {
        this.subscript = flag;
    }

    public boolean isSuperscript() {
        return this.superscript;
    }

    protected void setSuperscript(boolean flag) {
        this.superscript = flag;
    }

    public boolean isStrikeThrough() {
        return this.strikeThrough;
    }

    protected void setStrikeThrough(boolean flag) {
        this.strikeThrough = flag;
    }

    public LabelView(Element element) {
        super(element);
        this.setPropertiesFromAttributes();
    }
}

