/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.applet.Applet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class InitialContext
implements Context {
    private static final String[] colon_list = new String[]{"java.naming.factory.object", "java.naming.factory.url.pkgs", "java.naming.factory.state"};
    protected Context defaultInitCtx;
    protected boolean gotDefault;
    protected Hashtable myProps;

    protected void init(Hashtable environment) throws NamingException {
        InputStream is;
        Properties p;
        Object url;
        String[] properties = new String[]{"java.naming.dns.url", "java.naming.factory.initial", "java.naming.factory.object", "java.naming.provider.url", "java.naming.factory.state", "java.naming.factory.url.pkgs"};
        this.myProps = environment != null ? (Hashtable)environment.clone() : new Hashtable();
        Applet napplet = (Applet)this.myProps.get("java.naming.applet");
        int i = properties.length - 1;
        while (i >= 0) {
            Object o = this.myProps.get(properties[i]);
            if (o == null) {
                if (napplet != null) {
                    o = napplet.getParameter(properties[i]);
                }
                if (o == null) {
                    o = System.getProperty(properties[i]);
                }
                if (o != null) {
                    this.myProps.put(properties[i], o);
                }
            }
            --i;
        }
        try {
            Enumeration ep = Thread.currentThread().getContextClassLoader().getResources("jndi.naming");
            while (ep.hasMoreElements()) {
                url = (URL)ep.nextElement();
                p = new Properties();
                try {
                    is = ((URL)url).openStream();
                    p.load(is);
                    is.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                InitialContext.merge(this.myProps, p);
            }
        }
        catch (IOException home) {
            // empty catch block
        }
        String home = System.getProperty("gnu.classpath.home.url");
        if (home != null) {
            url = home + "/jndi.properties";
            p = new Properties();
            try {
                is = new URL((String)url).openStream();
                p.load(is);
                is.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            InitialContext.merge(this.myProps, p);
        }
    }

    private static final void merge(Hashtable h1, Hashtable h2) {
        Enumeration e2 = h2.keys();
        while (e2.hasMoreElements()) {
            String key2 = (String)e2.nextElement();
            Object value1 = h1.get(key2);
            if (value1 == null) {
                h1.put(key2, h2.get(key2));
                continue;
            }
            if (key2.compareTo(colon_list[0]) != 0 && key2.compareTo(colon_list[1]) != 0 && key2.compareTo(colon_list[2]) != 0 && key2.compareTo(colon_list[3]) != 0) continue;
            String value2 = (String)h2.get(key2);
            h1.put(key2, (String)value1 + ':' + value2);
        }
    }

    protected Context getDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = NamingManager.getInitialContext(this.myProps);
            this.gotDefault = true;
        }
        return this.defaultInitCtx;
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        if (name.size() > 0) {
            return this.getURLOrDefaultInitCtx(name.get(0));
        }
        return this.getDefaultInitCtx();
    }

    protected Context getURLOrDefaultInitCtx(String name) throws NamingException {
        Context context;
        String scheme = null;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        int colon = name.indexOf(58);
        int slash = name.indexOf(47);
        if (colon > 0 && (slash == -1 || colon < slash)) {
            scheme = name.substring(0, colon);
        }
        if (scheme != null && (context = NamingManager.getURLContext(scheme, this.myProps)) != null) {
            return context;
        }
        return this.getDefaultInitCtx();
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, obj);
    }

    public Object lookup(Name name) throws NamingException {
        try {
            return this.getURLOrDefaultInitCtx(name).lookup(name);
        }
        catch (CannotProceedException cpe) {
            Context ctx = NamingManager.getContinuationContext(cpe);
            return ctx.lookup(cpe.getRemainingName());
        }
    }

    public Object lookup(String name) throws NamingException {
        try {
            return this.getURLOrDefaultInitCtx(name).lookup(name);
        }
        catch (CannotProceedException cpe) {
            Context ctx = NamingManager.getContinuationContext(cpe);
            return ctx.lookup(cpe.getRemainingName());
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, obj);
    }

    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    public void unbind(String name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.getURLOrDefaultInitCtx(oldName).rename(oldName, newName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        this.getURLOrDefaultInitCtx(oldName).rename(oldName, newName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).composeName(name, prefix);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.myProps.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.myProps.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.myProps;
    }

    public void close() throws NamingException {
        this.myProps = null;
        this.defaultInitCtx = null;
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException();
    }

    private final /* synthetic */ void this() {
        this.gotDefault = false;
    }

    public InitialContext(Hashtable environment) throws NamingException {
        this.this();
        this.init(environment);
    }

    protected InitialContext(boolean lazy) throws NamingException {
        this.this();
        if (!lazy) {
            this.init(null);
        }
    }

    public InitialContext() throws NamingException {
        this.this();
        this.init(null);
    }
}

