/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LinkedList
extends AbstractSequentialList
implements List,
Cloneable,
Serializable {
    private static final long serialVersionUID = 876323262645176354L;
    transient Entry first;
    transient Entry last;
    transient int size;

    Entry getEntry(int n) {
        Entry e;
        if (n < this.size / 2) {
            e = this.first;
            while (n-- > 0) {
                e = e.next;
            }
        } else {
            e = this.last;
            while (++n < this.size) {
                e = e.previous;
            }
        }
        return e;
    }

    void removeEntry(Entry e) {
        ++this.modCount;
        --this.size;
        if (this.size == 0) {
            this.last = null;
            this.first = null;
        } else if (e == this.first) {
            this.first = e.next;
            e.next.previous = null;
        } else if (e == this.last) {
            this.last = e.previous;
            e.previous.next = null;
        } else {
            e.next.previous = e.previous;
            e.previous.next = e.next;
        }
    }

    private final void checkBoundsInclusive(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
    }

    private final void checkBoundsExclusive(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size);
        }
    }

    public Object getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.first.data;
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.last.data;
    }

    public Object removeFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        --this.size;
        Object r = this.first.data;
        if (this.first.next != null) {
            this.first.next.previous = null;
        } else {
            this.last = null;
        }
        this.first = this.first.next;
        return r;
    }

    public Object removeLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        --this.size;
        Object r = this.last.data;
        if (this.last.previous != null) {
            this.last.previous.next = null;
        } else {
            this.first = null;
        }
        this.last = this.last.previous;
        return r;
    }

    public void addFirst(Object o) {
        Entry e = new Entry(o);
        ++this.modCount;
        if (this.size == 0) {
            this.first = this.last = e;
        } else {
            e.next = this.first;
            this.first.previous = e;
            this.first = e;
        }
        ++this.size;
    }

    public void addLast(Object o) {
        this.addLastEntry(new Entry(o));
    }

    private final void addLastEntry(Entry e) {
        ++this.modCount;
        if (this.size == 0) {
            this.first = this.last = e;
        } else {
            e.previous = this.last;
            this.last.next = e;
            this.last = e;
        }
        ++this.size;
    }

    public boolean contains(Object o) {
        Entry e = this.first;
        while (e != null) {
            if (LinkedList.equals(o, e.data)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public int size() {
        return this.size;
    }

    public boolean add(Object o) {
        this.addLastEntry(new Entry(o));
        return true;
    }

    public boolean remove(Object o) {
        Entry e = this.first;
        while (e != null) {
            if (LinkedList.equals(o, e.data)) {
                this.removeEntry(e);
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        return this.addAll(this.size, c);
    }

    public boolean addAll(int index, Collection c) {
        this.checkBoundsInclusive(index);
        int csize = c.size();
        if (csize == 0) {
            return false;
        }
        Iterator itr = c.iterator();
        Entry after = null;
        Entry before = null;
        if (index != this.size) {
            after = this.getEntry(index);
            before = after.previous;
        } else {
            before = this.last;
        }
        Entry e = new Entry(itr.next());
        e.previous = before;
        Entry prev = e;
        Entry firstNew = e;
        int pos = 1;
        while (pos < csize) {
            e = new Entry(itr.next());
            e.previous = prev;
            prev.next = e;
            prev = e;
            ++pos;
        }
        ++this.modCount;
        this.size += csize;
        prev.next = after;
        if (after != null) {
            after.previous = e;
        } else {
            this.last = e;
        }
        if (before != null) {
            before.next = firstNew;
        } else {
            this.first = firstNew;
        }
        return true;
    }

    public void clear() {
        if (this.size > 0) {
            ++this.modCount;
            this.first = null;
            this.last = null;
            this.size = 0;
        }
    }

    public Object get(int index) {
        this.checkBoundsExclusive(index);
        return this.getEntry((int)index).data;
    }

    public Object set(int index, Object o) {
        this.checkBoundsExclusive(index);
        Entry e = this.getEntry(index);
        Object old = e.data;
        e.data = o;
        return old;
    }

    public void add(int index, Object o) {
        this.checkBoundsInclusive(index);
        Entry e = new Entry(o);
        if (index < this.size) {
            Entry after;
            ++this.modCount;
            e.next = after = this.getEntry(index);
            e.previous = after.previous;
            if (after.previous == null) {
                this.first = e;
            } else {
                after.previous.next = e;
            }
            after.previous = e;
            ++this.size;
        } else {
            this.addLastEntry(e);
        }
    }

    public Object remove(int index) {
        this.checkBoundsExclusive(index);
        Entry e = this.getEntry(index);
        this.removeEntry(e);
        return e.data;
    }

    public int indexOf(Object o) {
        int index = 0;
        Entry e = this.first;
        while (e != null) {
            if (LinkedList.equals(o, e.data)) {
                return index;
            }
            ++index;
            e = e.next;
        }
        return -1;
    }

    public int lastIndexOf(Object o) {
        int index = this.size - 1;
        Entry e = this.last;
        while (e != null) {
            if (LinkedList.equals(o, e.data)) {
                return index;
            }
            --index;
            e = e.previous;
        }
        return -1;
    }

    public ListIterator listIterator(int index) {
        this.checkBoundsInclusive(index);
        return new LinkedListItr(index);
    }

    public Object clone() {
        LinkedList copy = null;
        try {
            copy = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.clear();
        copy.addAll(this);
        return copy;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.size];
        Entry e = this.first;
        int i = 0;
        while (i < this.size) {
            array[i] = e.data;
            e = e.next;
            ++i;
        }
        return array;
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        } else if (a.length > this.size) {
            a[this.size] = null;
        }
        Entry e = this.first;
        int i = 0;
        while (i < this.size) {
            a[i] = e.data;
            e = e.next;
            ++i;
        }
        return a;
    }

    private final void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.size);
        Entry e = this.first;
        while (e != null) {
            s.writeObject(e.data);
            e = e.next;
        }
    }

    private final void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int i = s.readInt();
        while (--i >= 0) {
            this.addLastEntry(new Entry(s.readObject()));
        }
    }

    private final /* synthetic */ void this() {
        this.size = 0;
    }

    public LinkedList() {
        this.this();
    }

    public LinkedList(Collection c) {
        this.this();
        this.addAll(c);
    }

    private static final class Entry {
        Object data;
        Entry next;
        Entry previous;

        Entry(Object data) {
            this.data = data;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private final class LinkedListItr
    implements ListIterator {
        private int knownMod;
        private Entry next;
        private Entry previous;
        private Entry lastReturned;
        private int position;

        private final void checkMod() {
            if (this.knownMod != LinkedList.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        public final int nextIndex() {
            this.checkMod();
            return this.position;
        }

        public final int previousIndex() {
            this.checkMod();
            return this.position - 1;
        }

        public final boolean hasNext() {
            this.checkMod();
            boolean bl = false;
            if (this.next != null) {
                bl = true;
            }
            return bl;
        }

        public final boolean hasPrevious() {
            this.checkMod();
            boolean bl = false;
            if (this.previous != null) {
                bl = true;
            }
            return bl;
        }

        public final Object next() {
            this.checkMod();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            ++this.position;
            this.lastReturned = this.previous = this.next;
            this.next = this.lastReturned.next;
            return this.lastReturned.data;
        }

        public final Object previous() {
            this.checkMod();
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            --this.position;
            this.lastReturned = this.next = this.previous;
            this.previous = this.lastReturned.previous;
            return this.lastReturned.data;
        }

        public final void remove() {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.lastReturned == this.previous) {
                --this.position;
            }
            this.next = this.lastReturned.next;
            this.previous = this.lastReturned.previous;
            LinkedList.this.removeEntry(this.lastReturned);
            ++this.knownMod;
            this.lastReturned = null;
        }

        public final void add(Object o) {
            this.checkMod();
            ++LinkedList.this.modCount;
            ++this.knownMod;
            ++LinkedList.this.size;
            ++this.position;
            Entry e = new Entry(o);
            e.previous = this.previous;
            e.next = this.next;
            if (this.previous != null) {
                this.previous.next = e;
            } else {
                LinkedList.this.first = e;
            }
            if (this.next != null) {
                this.next.previous = e;
            } else {
                LinkedList.this.last = e;
            }
            this.previous = e;
            this.lastReturned = null;
        }

        public final void set(Object o) {
            this.checkMod();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.lastReturned.data = o;
        }

        private final /* synthetic */ void this() {
            this.knownMod = LinkedList.this.modCount;
        }

        LinkedListItr(int index) {
            this.this();
            if (index == LinkedList.this.size) {
                this.next = null;
                this.previous = LinkedList.this.last;
            } else {
                this.next = LinkedList.this.getEntry(index);
                this.previous = this.next.previous;
            }
            this.position = index;
        }
    }
}

