/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import gnu.xml.aelfred2.JAXPFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class SAXParserFactory {
    private boolean validating;
    private boolean namespaceAware;
    private Schema schema;
    private boolean xIncludeAware;
    static /* synthetic */ Class class$javax$xml$parsers$SAXParserFactory;

    public static SAXParserFactory newInstance() throws FactoryConfigurationError {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            Class clazz = class$javax$xml$parsers$SAXParserFactory;
            if (clazz == null) {
                clazz = class$javax$xml$parsers$SAXParserFactory = SAXParserFactory.class("[Ljavax.xml.parsers.SAXParserFactory;", false);
            }
            loader = clazz.getClassLoader();
        }
        String className = null;
        int count = 0;
        do {
            if ((className = SAXParserFactory.getFactoryClassName(loader, count++)) == null) continue;
            try {
                Class t = loader != null ? loader.loadClass(className) : Class.forName(className);
                return (SAXParserFactory)t.newInstance();
            }
            catch (ClassNotFoundException e) {
                className = null;
            }
            catch (Exception e) {
                throw new FactoryConfigurationError(e, "error instantiating class " + className);
            }
        } while (className == null && count < 3);
        return new JAXPFactory();
    }

    private static final String getFactoryClassName(ClassLoader loader, int attempt) {
        String propertyName = "javax.xml.parsers.SAXParserFactory";
        switch (attempt) {
            case 0: {
                return System.getProperty("javax.xml.parsers.SAXParserFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "jaxp.properties");
                    FileInputStream in = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(in);
                    ((InputStream)in).close();
                    return props.getProperty("javax.xml.parsers.SAXParserFactory");
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream in;
                    InputStream inputStream;
                    String serviceKey = "/META-INF/services/javax.xml.parsers.SAXParserFactory";
                    if (loader != null) {
                        inputStream = loader.getResourceAsStream(serviceKey);
                    } else {
                        Class clazz = class$javax$xml$parsers$SAXParserFactory;
                        if (clazz == null) {
                            clazz = class$javax$xml$parsers$SAXParserFactory = SAXParserFactory.class("[Ljavax.xml.parsers.SAXParserFactory;", false);
                        }
                        inputStream = in = clazz.getResourceAsStream(serviceKey);
                    }
                    if (in != null) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        String ret = r.readLine();
                        r.close();
                        return ret;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public abstract SAXParser newSAXParser() throws ParserConfigurationException, SAXException;

    public void setNamespaceAware(boolean awareness) {
        this.namespaceAware = awareness;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public abstract void setFeature(String var1, boolean var2) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException;

    public abstract boolean getFeature(String var1) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException;

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setXIncludeAware(boolean state) {
        this.xIncludeAware = state;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected SAXParserFactory() {
    }
}

