/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.CellEditorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DefaultTreeCellEditor
implements ActionListener,
TreeCellEditor,
TreeSelectionListener {
    private EventListenerList listenerList;
    protected TreeCellEditor realEditor;
    protected DefaultTreeCellRenderer renderer;
    protected Container editingContainer;
    protected transient Component editingComponent;
    protected boolean canEdit;
    protected transient int offset;
    protected transient JTree tree;
    protected transient TreePath lastPath;
    protected transient Timer timer;
    protected transient int lastRow;
    protected Color borderSelectionColor;
    protected transient Icon editingIcon;
    protected Font font;
    private TreePath tPath;
    static /* synthetic */ Class class$javax$swing$event$CellEditorListener;

    private final void configureEditingComponent(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
        if (tree != null && this.lastPath != null) {
            Object val = this.lastPath.getLastPathComponent();
            boolean isLeaf = tree.getModel().isLeaf(val);
            boolean expanded = tree.isExpanded(this.lastPath);
            this.determineOffset(tree, val, true, expanded, isLeaf, this.lastRow);
            if (isLeaf) {
                renderer.setIcon(renderer.getLeafIcon());
            } else if (expanded) {
                renderer.setIcon(renderer.getOpenIcon());
            } else {
                renderer.setIcon(renderer.getClosedIcon());
            }
            this.editingIcon = renderer.getIcon();
            this.editingComponent = this.getTreeCellEditorComponent(tree, val, true, expanded, isLeaf, this.lastRow);
        }
    }

    private final void writeObject(ObjectOutputStream value0) throws IOException {
    }

    private final void readObject(ObjectInputStream value0) throws IOException, ClassNotFoundException {
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        this.font = font != null ? font : this.renderer.getFont();
    }

    public Font getFont() {
        return this.font;
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        if (this.realEditor == null) {
            this.createTreeCellEditor();
        }
        return this.realEditor.getTreeCellEditorComponent(tree, value, isSelected, expanded, leaf, row);
    }

    public Object getCellEditorValue() {
        return this.editingComponent;
    }

    public boolean isCellEditable(EventObject event) {
        if (this.editingComponent == null) {
            this.configureEditingComponent(this.tree, this.renderer, this.realEditor);
        }
        if (this.editingComponent != null && this.realEditor.isCellEditable(event)) {
            this.prepareForEditing();
            return true;
        }
        if (this.shouldStartEditingTimer(event)) {
            this.startEditingTimer();
        } else if (this.timer.isRunning()) {
            this.timer.stop();
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject event) {
        return true;
    }

    public boolean stopCellEditing() {
        if (this.editingComponent != null && this.realEditor.stopCellEditing()) {
            this.timer.stop();
            return true;
        }
        return false;
    }

    public void cancelCellEditing() {
        if (this.editingComponent != null) {
            this.timer.stop();
            this.realEditor.cancelCellEditing();
        }
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.realEditor.addCellEditorListener(listener);
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.realEditor.removeCellEditorListener(listener);
    }

    public CellEditorListener[] getCellEditorListeners() {
        Class clazz = class$javax$swing$event$CellEditorListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$CellEditorListener = DefaultTreeCellEditor.class("[Ljavax.swing.event.CellEditorListener;", false);
        }
        return (CellEditorListener[])this.listenerList.getListeners(clazz);
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.tPath = this.lastPath;
        this.lastPath = e.getNewLeadSelectionPath();
        this.lastRow = this.tree.getRowForPath(this.lastPath);
        this.configureEditingComponent(this.tree, this.renderer, this.realEditor);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.lastPath != null && this.tPath != null && this.tPath.equals(this.lastPath)) {
            this.tree.startEditingAtPath(this.lastPath);
            this.timer.stop();
        }
    }

    protected void setTree(JTree newTree) {
        this.tree = newTree;
    }

    protected boolean shouldStartEditingTimer(EventObject event) {
        return event instanceof MouseEvent && ((MouseEvent)event).getClickCount() == 1;
    }

    protected void startEditingTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1200, this);
        }
        if (!this.timer.isRunning()) {
            this.timer.start();
        }
    }

    protected boolean canEditImmediately(EventObject event) {
        return event == null || !(event instanceof MouseEvent) || ((MouseEvent)event).getClickCount() > 2 && this.inHitRegion(((MouseEvent)event).getX(), ((MouseEvent)event).getY());
    }

    protected boolean inHitRegion(int x, int y) {
        Rectangle bounds = this.tree.getPathBounds(this.lastPath);
        return bounds.contains(x, y);
    }

    protected void determineOffset(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this.renderer.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, true);
        Icon c = this.renderer.getIcon();
        this.offset = c != null ? this.renderer.getIconTextGap() + c.getIconWidth() : 0;
    }

    protected void prepareForEditing() {
        this.editingContainer.add(this.editingComponent);
    }

    protected Container createContainer() {
        return new EditorContainer();
    }

    protected TreeCellEditor createTreeCellEditor() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.realEditor = new DefaultCellEditor(new DefaultTextField(defaults.getBorder("Tree.selectionBorder")));
        return this.realEditor;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.listenerList = new EventListenerList();
    }

    public DefaultTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer) {
        this(tree, renderer, null);
    }

    public DefaultTreeCellEditor(JTree tree, DefaultTreeCellRenderer renderer, TreeCellEditor editor) {
        this.this();
        this.setTree(tree);
        this.renderer = renderer;
        if (editor == null) {
            editor = this.createTreeCellEditor();
        }
        this.realEditor = editor;
        this.lastPath = tree.getLeadSelectionPath();
        tree.addTreeSelectionListener(this);
        this.editingContainer = this.createContainer();
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        this.setFont(defaults.getFont("Tree.font"));
        this.setBorderSelectionColor(defaults.getColor("Tree.selectionBorderColor"));
        this.editingIcon = renderer.getIcon();
        this.timer = new Timer(1200, this);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class EditorContainer
    extends Container {
        public void EditorContainer() {
        }

        public Dimension getPreferredSize() {
            Dimension containerSize = super.getPreferredSize();
            containerSize.width += DefaultTreeCellEditor.this.offset;
            return containerSize;
        }

        public void paint(Graphics g) {
            Rectangle tr = DefaultTreeCellEditor.this.tree.getPathBounds(DefaultTreeCellEditor.this.lastPath);
            if (tr != null) {
                Insets i = ((DefaultTextField)DefaultTreeCellEditor.this.editingComponent).getBorder().getBorderInsets(this);
                int textIconGap = 3;
                tr.x -= i.left;
                if (DefaultTreeCellEditor.this.editingIcon != null) {
                    DefaultTreeCellEditor.this.editingIcon.paintIcon(this, g, tr.x - DefaultTreeCellEditor.this.editingIcon.getIconWidth() / 2, tr.y + i.top + i.bottom);
                    tr.x += DefaultTreeCellEditor.this.editingIcon.getIconWidth() / 2 + textIconGap;
                }
                tr.width += DefaultTreeCellEditor.this.offset;
                g.translate(tr.x, tr.y);
                DefaultTreeCellEditor.this.editingComponent.setSize(new Dimension(tr.width, tr.height));
                DefaultTreeCellEditor.this.editingComponent.paint(g);
                g.translate(-tr.x, -tr.y);
            }
            super.paint(g);
        }

        public void doLayout() {
            if (DefaultTreeCellEditor.this.tree.isEditing()) {
                this.setLocation(DefaultTreeCellEditor.this.offset, 0);
            }
            super.doLayout();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DefaultTextField
    extends JTextField {
        protected Border border;

        public Font getFont() {
            Font font = super.getFont();
            if (font == null) {
                Container parent = this.getParent();
                if (parent != null) {
                    return parent.getFont();
                }
                return null;
            }
            return font;
        }

        public Border getBorder() {
            return this.border;
        }

        public Dimension getPreferredSize() {
            String s = this.getText();
            Font f = this.getFont();
            if (f != null) {
                FontMetrics fm = this.getToolkit().getFontMetrics(f);
                return new Dimension(SwingUtilities.computeStringWidth(fm, s), fm.getHeight());
            }
            return DefaultTreeCellEditor.this.renderer.getPreferredSize();
        }

        public DefaultTextField(Border border) {
            this.border = border;
        }
    }
}

