/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import gnu.javax.swing.text.html.parser.HTML_401F;
import gnu.javax.swing.text.html.parser.htmlAttributeSet;
import gnu.javax.swing.text.html.parser.support.Parser;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import javax.swing.text.BadLocationException;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.DTD;
import javax.swing.text.html.parser.TagElement;

public class ParserDelegator
extends HTMLEditorKit.Parser
implements Serializable {
    private static final long serialVersionUID = -1276686502624777206L;
    private static DTD dtd = HTML_401F.getInstance();
    HTMLEditorKit.ParserCallback callBack;
    gnuParser gnu;

    public void parse(Reader reader, HTMLEditorKit.ParserCallback a_callback, boolean ignoreCharSet) throws IOException {
        this.callBack = a_callback;
        if (this.gnu == null || !dtd.equals(this.gnu.getDTD())) {
            this.gnu = new gnuParser(dtd);
        }
        this.gnu.parse(reader);
        this.callBack.handleEndOfLineString(this.gnu.getEndOfLineSequence());
        try {
            this.callBack.flush();
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected static void setDefaultDTD() {
        dtd = HTML_401F.getInstance();
    }

    protected static DTD createDTD(DTD a_dtd, String name) {
        DTD.putDTDHash(name, a_dtd);
        DTD dtd_prev = dtd;
        dtd = a_dtd;
        return dtd_prev;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class gnuParser
    extends Parser {
        private static final long serialVersionUID = 1L;

        protected final void handleComment(char[] comment) {
            ParserDelegator.this.callBack.handleComment(comment, this.hTag.where.startPosition);
        }

        protected final void handleEmptyTag(TagElement tag) throws ChangedCharSetException {
            ParserDelegator.this.callBack.handleSimpleTag(tag.getHTMLTag(), this.getAttributes(), this.hTag.where.startPosition);
        }

        protected final void handleEndTag(TagElement tag) {
            ParserDelegator.this.callBack.handleEndTag(tag.getHTMLTag(), this.hTag.where.startPosition);
        }

        protected final void handleError(int line, String message) {
            ParserDelegator.this.callBack.handleError(message, this.hTag.where.startPosition);
        }

        protected final void handleStartTag(TagElement tag) {
            htmlAttributeSet attributes = ParserDelegator.this.gnu.getAttributes();
            if (tag.fictional()) {
                attributes.addAttribute(HTMLEditorKit.ParserCallback.IMPLIED, Boolean.TRUE);
            }
            ParserDelegator.this.callBack.handleStartTag(tag.getHTMLTag(), attributes, this.hTag.where.startPosition);
        }

        protected final void handleText(char[] text) {
            ParserDelegator.this.callBack.handleText(text, this.hTag.where.startPosition);
        }

        DTD getDTD() {
            return this.dtd;
        }

        private gnuParser(DTD d) {
            super(d);
        }
    }
}

