/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabExpander;
import javax.swing.text.TabableView;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class GlyphView
extends View
implements TabableView,
Cloneable {
    GlyphPainter glyphPainter;
    int startOffset;
    int endOffset;

    public GlyphPainter getGlyphPainter() {
        return this.glyphPainter;
    }

    public void setGlyphPainter(GlyphPainter painter) {
        this.glyphPainter = painter;
    }

    protected void checkPainter() {
        if (this.glyphPainter == null) {
            this.glyphPainter = new DefaultGlyphPainter();
        }
    }

    public void paint(Graphics g, Shape a) {
        Element el = this.getElement();
        this.checkPainter();
        this.getGlyphPainter().paint(this, g, a, el.getStartOffset(), el.getEndOffset());
    }

    public float getPreferredSpan(int axis) {
        float span = 0.0f;
        this.checkPainter();
        GlyphPainter painter = this.getGlyphPainter();
        if (axis == 0) {
            Element el = this.getElement();
            TabExpander tabEx = null;
            View parent = this.getParent();
            if (parent instanceof TabExpander) {
                tabEx = (TabExpander)((Object)parent);
            }
            span = painter.getSpan(this, this.getStartOffset(), this.getEndOffset(), tabEx, 0.0f);
        } else {
            span = painter.getHeight(this);
        }
        return span;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        GlyphPainter p = this.getGlyphPainter();
        return p.modelToView(this, pos, b, a);
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
        this.checkPainter();
        GlyphPainter painter = this.getGlyphPainter();
        return painter.viewToModel(this, x, y, a, b);
    }

    public TabExpander getTabExpander() {
        TabExpander te = null;
        View parent = this.getParent();
        if (parent instanceof TabExpander) {
            te = (TabExpander)((Object)parent);
        }
        return te;
    }

    public float getTabbedSpan(float x, TabExpander te) {
        Element el = this.getElement();
        return this.getGlyphPainter().getSpan(this, el.getStartOffset(), el.getEndOffset(), te, x);
    }

    public float getPartialSpan(int p0, int p1) {
        Element el = this.getElement();
        Document doc = el.getDocument();
        Segment seg = new Segment();
        try {
            doc.getText(p0, p1 - p0, seg);
        }
        catch (BadLocationException ex) {
            AssertionError ae = new AssertionError((Object)"BadLocationException must not be thrown here");
            ((Throwable)((Object)ae)).initCause(ex);
            throw ae;
        }
        FontMetrics fm = null;
        return Utilities.getTabbedTextWidth(seg, fm, 0, null, p0);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public Segment getText(int p0, int p1) {
        Segment txt = new Segment();
        try {
            this.getDocument().getText(p0, p1 - p0, txt);
        }
        catch (BadLocationException ex) {
            AssertionError ae = new AssertionError((Object)("BadLocationException should not be thrown here. p0 = " + p0 + ", p1 = " + p1));
            ((Throwable)((Object)ae)).initCause(ex);
            throw ae;
        }
        return txt;
    }

    public Font getFont() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        String family = StyleConstants.getFontFamily(atts);
        int size = StyleConstants.getFontSize(atts);
        int style = 0;
        if (StyleConstants.isBold(atts)) {
            style |= 1;
        }
        if (StyleConstants.isItalic(atts)) {
            style |= 2;
        }
        Font font = new Font(family, style, size);
        return font;
    }

    public Color getForeground() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.getForeground(atts);
    }

    public Color getBackground() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.getBackground(atts);
    }

    public boolean isStikeThrough() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.isStrikeThrough(atts);
    }

    public boolean isSubscript() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.isSubscript(atts);
    }

    public boolean isSuperscript() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.isSuperscript(atts);
    }

    public boolean isUnderline() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        return StyleConstants.isUnderline(atts);
    }

    protected final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            AssertionError err = new AssertionError((Object)"CloneNotSupportedException must not be thrown here");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
    }

    public View breakView(int axis, int p0, float pos, float len) {
        if (axis == 1) {
            return this;
        }
        this.checkPainter();
        GlyphPainter painter = this.getGlyphPainter();
        int breakLocation = painter.getBoundedPosition(this, p0, pos, len);
        BreakIterator lineBreaker = BreakIterator.getLineInstance();
        Segment txt = new Segment();
        try {
            this.getDocument().getText(this.getStartOffset(), this.getEndOffset(), txt);
        }
        catch (BadLocationException ex) {
            AssertionError err = new AssertionError((Object)"BadLocationException must not be thrown here.");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
        lineBreaker.setText(txt);
        int goodBreakLocation = lineBreaker.previous();
        if (goodBreakLocation != -1) {
            breakLocation = goodBreakLocation;
        }
        View brokenView = this.createFragment(p0, breakLocation);
        return brokenView;
    }

    public int getBreakWeight(int axis, float pos, float len) {
        int weight;
        if (axis == 1) {
            weight = super.getBreakWeight(axis, pos, len);
        } else {
            int spanX = (int)this.getPreferredSpan(0);
            int spanY = (int)this.getPreferredSpan(1);
            Rectangle dummyAlloc = new Rectangle(0, 0, spanX, spanY);
            Position.Bias[] biasRet = new Position.Bias[1];
            int offset1 = this.viewToModel(pos, spanY / 2, dummyAlloc, biasRet);
            int offset2 = this.viewToModel(pos, spanY / 2, dummyAlloc, biasRet);
            Segment txt = this.getText(offset1, offset2);
            BreakIterator lineBreaker = BreakIterator.getLineInstance();
            lineBreaker.setText(txt);
            int breakLoc = lineBreaker.previous();
            weight = breakLoc == offset1 ? 0 : (breakLoc == -1 ? 1000 : 2000);
        }
        return weight;
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory vf) {
        this.getParent().preferenceChanged(this, true, true);
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory vf) {
        this.getParent().preferenceChanged(this, true, false);
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory vf) {
        this.getParent().preferenceChanged(this, true, false);
    }

    public View createFragment(int p0, int p1) {
        GlyphView fragment = (GlyphView)this.clone();
        fragment.startOffset = p0;
        fragment.endOffset = p1;
        return fragment;
    }

    public float getAlignment(int axis) {
        float align;
        if (axis == 1) {
            this.checkPainter();
            GlyphPainter painter = this.getGlyphPainter();
            float height = painter.getHeight(this);
            float descent = painter.getDescent(this);
            align = (height - descent) / height;
        } else {
            align = super.getAlignment(axis);
        }
        return align;
    }

    public int getNextVisualPositionFrom(int pos, Position.Bias bias, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        this.checkPainter();
        GlyphPainter painter = this.getGlyphPainter();
        return painter.getNextVisualPositionFrom(this, pos, bias, a, direction, biasRet);
    }

    public GlyphView(Element element) {
        super(element);
        this.startOffset = element.getStartOffset();
        this.endOffset = element.getEndOffset();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class DefaultGlyphPainter
    extends GlyphPainter {
        private static final /* synthetic */ boolean assert;

        public float getHeight(GlyphView view) {
            Font font = view.getFont();
            FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            float height = metrics.getHeight();
            return height;
        }

        public void paint(GlyphView view, Graphics g, Shape a, int p0, int p1) {
            int height = (int)this.getHeight(view);
            Segment txt = view.getText(p0, p1);
            Rectangle bounds = a.getBounds();
            TabExpander tabEx = null;
            View parent = view.getParent();
            if (parent instanceof TabExpander) {
                tabEx = (TabExpander)((Object)parent);
            }
            Color background = view.getBackground();
            g.setColor(background);
            int width = Utilities.getTabbedTextWidth(txt, g.getFontMetrics(), bounds.x, tabEx, txt.offset);
            g.fillRect(bounds.x, bounds.y, width, height);
            g.setColor(view.getForeground());
            g.setFont(view.getFont());
            if (view.isSuperscript()) {
                Utilities.drawTabbedText(txt, bounds.x, bounds.y - height / 2, g, tabEx, txt.offset);
            } else if (view.isSubscript()) {
                Utilities.drawTabbedText(txt, bounds.x, bounds.y + height / 2, g, tabEx, txt.offset);
            } else {
                Utilities.drawTabbedText(txt, bounds.x, bounds.y, g, tabEx, txt.offset);
            }
            if (view.isStikeThrough()) {
                int strikeHeight = (int)(this.getAscent(view) / 2.0f);
                g.drawLine(bounds.x, bounds.y + strikeHeight, bounds.height + width, bounds.y + strikeHeight);
            }
            if (view.isUnderline()) {
                int lineHeight = (int)this.getAscent(view);
                g.drawLine(bounds.x, bounds.y + lineHeight, bounds.height + width, bounds.y + lineHeight);
            }
        }

        public Shape modelToView(GlyphView view, int pos, Position.Bias b, Shape a) throws BadLocationException {
            Element el = view.getElement();
            Font font = view.getFont();
            FontMetrics fm = view.getContainer().getFontMetrics(font);
            Segment txt = view.getText(el.getStartOffset(), pos);
            int width = fm.charsWidth(txt.array, txt.offset, txt.count);
            int height = fm.getHeight();
            Rectangle bounds = a.getBounds();
            Rectangle result = new Rectangle(bounds.x + width, bounds.y, bounds.x + width, height);
            return result;
        }

        public float getSpan(GlyphView view, int p0, int p1, TabExpander te, float x) {
            Element el = view.getElement();
            Font font = view.getFont();
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(font);
            Segment txt = view.getText(p0, p1);
            int span = Utilities.getTabbedTextWidth(txt, fm, (int)x, te, p0);
            return span;
        }

        public float getAscent(GlyphView v) {
            Font font = v.getFont();
            FontMetrics fm = v.getContainer().getFontMetrics(font);
            return fm.getAscent();
        }

        public float getDescent(GlyphView v) {
            Font font = v.getFont();
            FontMetrics fm = v.getContainer().getFontMetrics(font);
            return fm.getDescent();
        }

        public int getBoundedPosition(GlyphView v, int p0, float x, float len) {
            TabExpander te = v.getTabExpander();
            Segment txt = v.getText(p0, v.getEndOffset());
            Font font = v.getFont();
            FontMetrics fm = v.getContainer().getFontMetrics(font);
            int pos = Utilities.getTabbedTextOffset(txt, fm, (int)x, (int)(x + len), te, p0, false);
            return pos;
        }

        public int viewToModel(GlyphView v, float x, float y, Shape a, Position.Bias[] biasRet) {
            Rectangle b = a.getBounds();
            if (!assert && !b.contains(x, y)) {
                throw new AssertionError((Object)("The coordinates are expected to be within the view's bounds: x=" + x + ", y=" + y + "a=" + a));
            }
            int pos = this.getBoundedPosition(v, v.getStartOffset(), b.x, x - (float)b.x);
            return pos;
        }

        DefaultGlyphPainter() {
        }

        static {
            assert = Class.forName("[Ljavax.swing.text.GlyphView;").getComponentType().desiredAssertionStatus() ^ true;
        }
    }

    public static abstract class GlyphPainter {
        public abstract float getAscent(GlyphView var1);

        public abstract float getDescent(GlyphView var1);

        public abstract float getHeight(GlyphView var1);

        public abstract int getBoundedPosition(GlyphView var1, int var2, float var3, float var4);

        public abstract void paint(GlyphView var1, Graphics var2, Shape var3, int var4, int var5);

        public abstract Shape modelToView(GlyphView var1, int var2, Position.Bias var3, Shape var4) throws BadLocationException;

        public abstract int viewToModel(GlyphView var1, float var2, float var3, Shape var4, Position.Bias[] var5);

        public abstract float getSpan(GlyphView var1, int var2, int var3, TabExpander var4, float var5);

        public int getNextVisualPositionFrom(GlyphView v, int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
            int result = pos;
            switch (direction) {
                case 3: {
                    result = pos + 1;
                    break;
                }
                case 7: {
                    result = pos - 1;
                    break;
                }
            }
            return result;
        }

        public GlyphPainter getPainter(GlyphView v, int p0, int p1) {
            return this;
        }
    }
}

