/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.ViewFactory;

public class FieldView
extends PlainView {
    protected FontMetrics getFontMetrics() {
        Container container = this.getContainer();
        return container.getFontMetrics(container.getFont());
    }

    protected Shape adjustAllocation(Shape shape) {
        int x;
        Rectangle rectIn = shape.getBounds();
        int height = (int)this.getPreferredSpan(1);
        int y = rectIn.y + (rectIn.height - height) / 2;
        JTextField textField = (JTextField)this.getContainer();
        int halign = textField.getHorizontalAlignment();
        int width = (int)this.getPreferredSpan(0);
        ComponentOrientation orientation = textField.getComponentOrientation();
        switch (halign) {
            case 0: {
                x = rectIn.x + (rectIn.width - width) / 2;
                break;
            }
            case 4: {
                x = rectIn.x + (rectIn.width - width);
                break;
            }
            case 11: {
                if (orientation.isLeftToRight()) {
                    x = rectIn.x + (rectIn.width - width);
                    break;
                }
                x = rectIn.x;
                break;
            }
            case 10: {
                if (orientation.isLeftToRight()) {
                    x = rectIn.x;
                    break;
                }
                x = rectIn.x + (rectIn.width - width);
                break;
            }
            default: {
                x = rectIn.x;
                break;
            }
        }
        return new Rectangle(x, y, width, height);
    }

    public float getPreferredSpan(int axis) {
        String text;
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException();
        }
        FontMetrics fm = this.getFontMetrics();
        if (axis == 1) {
            return super.getPreferredSpan(axis);
        }
        Element elem = this.getElement();
        try {
            text = elem.getDocument().getText(elem.getStartOffset(), elem.getEndOffset());
        }
        catch (BadLocationException e) {
            text = "";
        }
        return fm.stringWidth(text) + 30;
    }

    public int getResizeWeight(int axis) {
        int n = 0;
        if (axis == 0) {
            n = 1;
        }
        axis = n;
        return n;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias bias) throws BadLocationException {
        Shape newAlloc = this.adjustAllocation(a);
        return super.modelToView(pos, newAlloc, bias);
    }

    public void paint(Graphics g, Shape s) {
        Shape newAlloc = this.adjustAllocation(s);
        super.paint(g, newAlloc);
    }

    public void insertUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        Shape newAlloc = this.adjustAllocation(shape);
        super.insertUpdate(ev, newAlloc, vf);
        this.getContainer().repaint();
    }

    public void removeUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        Shape newAlloc = this.adjustAllocation(shape);
        super.removeUpdate(ev, newAlloc, vf);
        this.getContainer().repaint();
    }

    public void changedUpdate(DocumentEvent ev, Shape shape, ViewFactory vf) {
        Shape newAlloc = this.adjustAllocation(shape);
        super.removeUpdate(ev, newAlloc, vf);
        this.getContainer().repaint();
    }

    public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
        return super.viewToModel(fx, fy, a, bias);
    }

    public FieldView(Element elem) {
        super(elem);
    }
}

