/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SeparatorUI;

public class BasicSeparatorUI
extends SeparatorUI {
    protected Color shadow;
    protected Color highlight;

    public static ComponentUI createUI(JComponent c) {
        return new BasicSeparatorUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JSeparator) {
            JSeparator s = (JSeparator)c;
            this.installDefaults(s);
            this.installListeners(s);
        }
    }

    public void uninstallUI(JComponent c) {
        if (c instanceof JSeparator) {
            JSeparator s = (JSeparator)c;
            this.uninstallListeners(s);
            this.uninstallDefaults(s);
        }
    }

    protected void installDefaults(JSeparator s) {
        this.shadow = UIManager.getColor("Separator.shadow");
        this.highlight = UIManager.getColor("Separator.highlight");
        s.setOpaque(false);
    }

    protected void uninstallDefaults(JSeparator s) {
        this.shadow = null;
        this.highlight = null;
    }

    protected void installListeners(JSeparator s) {
    }

    protected void uninstallListeners(JSeparator s) {
    }

    public void paint(Graphics g, JComponent c) {
        Rectangle r = new Rectangle();
        SwingUtilities.calculateInnerArea(c, r);
        Color saved = g.getColor();
        if (!(c instanceof JSeparator)) {
            return;
        }
        JSeparator s = (JSeparator)c;
        if (s.getOrientation() == 0) {
            int midAB = r.height / 2;
            g.setColor(this.shadow);
            g.drawLine(r.x, r.y + midAB - 1, r.x + r.width, r.y + midAB - 1);
            g.setColor(this.highlight);
            g.fillRect(r.x, r.y + midAB, r.x + r.width, r.y + midAB);
        } else {
            int midAD = r.height / 2 + r.y;
            g.setColor(this.shadow);
            g.drawLine(r.x, r.y, r.x, r.y + r.height);
            g.setColor(this.highlight);
            g.fillRect(r.x + midAD, r.y + r.height, r.x + midAD, r.y + r.height);
        }
        g.setColor(saved);
    }

    public Dimension getPreferredSize(JComponent c) {
        JSeparator s;
        Dimension pref = new Dimension(2, 0);
        if (c instanceof JSeparator && (s = (JSeparator)c).getOrientation() == 0) {
            pref = new Dimension(0, 2);
        }
        return pref;
    }

    public Dimension getMinimumSize(JComponent c) {
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent c) {
        return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
    }
}

