/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MenuSelectionManager {
    private static final MenuSelectionManager manager = new MenuSelectionManager();
    protected ChangeEvent changeEvent;
    protected EventListenerList listenerList;
    private Vector selectedPath;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].stateChanged(this.changeEvent);
            ++i;
        }
    }

    public void addChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = MenuSelectionManager.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = MenuSelectionManager.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public ChangeListener[] getChangeListeners() {
        Class clazz = class$javax$swing$event$ChangeListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$ChangeListener = MenuSelectionManager.class("[Ljavax.swing.event.ChangeListener;", false);
        }
        return (ChangeListener[])this.listenerList.getListeners(clazz);
    }

    public void clearSelectedPath() {
        int i = this.selectedPath.size() - 1;
        while (i >= 0) {
            ((MenuElement)this.selectedPath.get(i)).menuSelectionChanged(false);
            --i;
        }
        this.selectedPath.clear();
        this.fireStateChanged();
    }

    public Component componentForPoint(Component source, Point sourcePoint) {
        Point sourcePointOnScreen = sourcePoint;
        if (source.isShowing()) {
            SwingUtilities.convertPointToScreen(sourcePointOnScreen, source);
        }
        Component resultComp = null;
        int i = 0;
        while (i < this.selectedPath.size()) {
            Component comp = (Component)this.selectedPath.get(i);
            Dimension size = comp.getSize();
            Point compPointOnScreen = comp.getLocationOnScreen();
            if (compPointOnScreen.x <= sourcePointOnScreen.x && sourcePointOnScreen.x < compPointOnScreen.x + size.width && compPointOnScreen.y <= sourcePointOnScreen.y && sourcePointOnScreen.y < compPointOnScreen.y + size.height) {
                Point p = sourcePointOnScreen;
                if (comp.isShowing()) {
                    SwingUtilities.convertPointFromScreen(p, comp);
                }
                resultComp = SwingUtilities.getDeepestComponentAt(comp, p.x, p.y);
                break;
            }
            ++i;
        }
        return resultComp;
    }

    public static MenuSelectionManager defaultManager() {
        return manager;
    }

    public MenuElement[] getSelectedPath() {
        MenuElement[] path = new MenuElement[this.selectedPath.size()];
        int i = 0;
        while (i < path.length) {
            path[i] = (MenuElement)this.selectedPath.get(i);
            ++i;
        }
        return path;
    }

    public boolean isComponentPartOfCurrentMenu(Component c) {
        int i = 0;
        while (i < this.selectedPath.size()) {
            MenuElement[] subElements = ((MenuElement)this.selectedPath.get(i)).getSubElements();
            int j = 0;
            while (j < subElements.length) {
                MenuElement me = subElements[j];
                if (me != null && me.getComponent().equals(c)) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void processKeyEvent(KeyEvent e) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void processMouseEvent(MouseEvent event) {
        Component source = (Component)event.getSource();
        Component mouseOverMenuComp = event.getID() == 506 || event.getID() == 502 ? this.componentForPoint(source, event.getPoint()) : source;
        if (mouseOverMenuComp != null && mouseOverMenuComp instanceof MenuElement) {
            MenuElement[] path = this.getPath(mouseOverMenuComp);
            ((MenuElement)((Object)mouseOverMenuComp)).processMouseEvent(event, path, manager);
        } else if (event.getID() == 502) {
            this.clearSelectedPath();
        }
    }

    public void setSelectedPath(MenuElement[] path) {
        int i;
        if (path == null) {
            this.clearSelectedPath();
            return;
        }
        int minSize = path.length;
        if (path.length > this.selectedPath.size()) {
            minSize = this.selectedPath.size();
            i = this.selectedPath.size();
            while (i < path.length) {
                this.selectedPath.add(path[i]);
                path[i].menuSelectionChanged(true);
                ++i;
            }
        } else if (path.length < this.selectedPath.size()) {
            i = this.selectedPath.size() - 1;
            while (i >= path.length) {
                ((MenuElement)this.selectedPath.get(i)).menuSelectionChanged(false);
                this.selectedPath.remove(i);
                --i;
            }
            minSize = path.length;
        }
        i = minSize - 1;
        while (i >= 0) {
            MenuElement oldSelectedItem = (MenuElement)this.selectedPath.get(i);
            if (path[i].equals(oldSelectedItem)) break;
            oldSelectedItem.menuSelectionChanged(false);
            path[i].menuSelectionChanged(true);
            this.selectedPath.setElementAt(path[i], i);
            --i;
        }
        this.fireStateChanged();
    }

    private final MenuElement[] getPath(Component c) {
        ArrayList path = new ArrayList();
        if (c instanceof JMenu) {
            path.add(((JMenu)c).getPopupMenu());
        }
        while (c instanceof MenuElement) {
            path.add(0, (MenuElement)((Object)c));
            c = c instanceof JPopupMenu ? ((JPopupMenu)c).getInvoker() : c.getParent();
        }
        Object[] pathArray = new MenuElement[path.size()];
        path.toArray(pathArray);
        return pathArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.changeEvent = new ChangeEvent(this);
        this.listenerList = new EventListenerList();
        this.selectedPath = new Vector();
    }

    public MenuSelectionManager() {
        this.this();
    }
}

