/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JTree
extends JComponent
implements Scrollable,
Accessible {
    private static final long serialVersionUID = 7559816092864483649L;
    public static final String CELL_EDITOR_PROPERTY = "cellEditor";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "invokesStopCellEditing";
    public static final String LARGE_MODEL_PROPERTY = "largeModel";
    public static final String ROOT_VISIBLE_PROPERTY = "rootVisible";
    public static final String ROW_HEIGHT_PROPERTY = "rowHeight";
    public static final String SCROLLS_ON_EXPAND_PROPERTY = "scrollsOnExpand";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String SHOWS_ROOT_HANDLES_PROPERTY = "showsRootHandles";
    public static final String TOGGLE_CLICK_COUNT_PROPERTY = "toggleClickCount";
    public static final String TREE_MODEL_PROPERTY = "model";
    public static final String VISIBLE_ROW_COUNT_PROPERTY = "visibleRowCount";
    public static final String ANCHOR_SELECTION_PATH_PROPERTY = "anchorSelectionPath";
    public static final String LEAD_SELECTION_PATH_PROPERTY = "leadSelectionPath";
    public static final String EXPANDS_SELECTED_PATHS_PROPERTY = "expandsSelectedPaths";
    private static final Object EXPANDED = new Object();
    private static final Object COLLAPSED = new Object();
    private boolean dragEnabled;
    private boolean expandsSelectedPaths;
    private TreePath anchorSelectionPath;
    private TreePath leadSelectionPath;
    private Hashtable nodeStates;
    protected transient TreeCellEditor cellEditor;
    protected transient TreeCellRenderer cellRenderer;
    protected boolean editable;
    protected boolean invokesStopCellEditing;
    protected boolean largeModel;
    protected boolean rootVisible;
    protected int rowHeight;
    protected boolean scrollsOnExpand;
    protected transient TreeSelectionModel selectionModel;
    protected boolean showsRootHandles;
    protected int toggleClickCount;
    protected transient TreeModel treeModel;
    protected int visibleRowCount;
    protected transient TreeModelListener treeModelListener;
    protected TreeSelectionRedirector selectionRedirector;
    static /* synthetic */ Class class$javax$swing$event$TreeExpansionListener;
    static /* synthetic */ Class class$javax$swing$event$TreeSelectionListener;
    static /* synthetic */ Class class$javax$swing$event$TreeWillExpandListener;

    public int getRowForPath(TreePath path) {
        TreeUI ui = this.getUI();
        if (ui != null) {
            return ui.getRowForPath(this, path);
        }
        return -1;
    }

    public TreePath getPathForRow(int row) {
        TreeUI ui = this.getUI();
        return ui != null ? ui.getPathForRow(this, row) : null;
    }

    protected TreePath[] getPathBetweenRows(int index0, int index1) {
        TreeUI ui = this.getUI();
        if (ui == null) {
            return null;
        }
        int minIndex = Math.min(index0, index1);
        int maxIndex = Math.max(index0, index1);
        TreePath[] paths = new TreePath[maxIndex - minIndex + 1];
        int i = minIndex;
        while (i <= maxIndex) {
            paths[i - minIndex] = ui.getPathForRow(this, i);
            ++i;
        }
        return paths;
    }

    protected static TreeModel createTreeModel(Object value) {
        return new DefaultTreeModel(new DynamicUtilTreeNode(value, value));
    }

    public TreeUI getUI() {
        return (TreeUI)this.ui;
    }

    public void setUI(TreeUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((TreeUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "TreeUI";
    }

    public AccessibleContext getAccessibleContext() {
        return new AccessibleJTree();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(this.getPreferredSize().width, this.getVisibleRowCount() * this.getRowHeight());
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            boolean bl = false;
            if (((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            boolean bl = false;
            if (((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public void addTreeExpansionListener(TreeExpansionListener listener) {
        Class clazz = class$javax$swing$event$TreeExpansionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeExpansionListener = JTree.class("[Ljavax.swing.event.TreeExpansionListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener listener) {
        Class clazz = class$javax$swing$event$TreeExpansionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeExpansionListener = JTree.class("[Ljavax.swing.event.TreeExpansionListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public TreeExpansionListener[] getTreeExpansionListeners() {
        Class clazz = class$javax$swing$event$TreeExpansionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeExpansionListener = JTree.class("[Ljavax.swing.event.TreeExpansionListener;", false);
        }
        return (TreeExpansionListener[])this.getListeners(clazz);
    }

    public void fireTreeCollapsed(TreePath path) {
        TreeExpansionEvent event = new TreeExpansionEvent(this, path);
        TreeExpansionListener[] listeners = this.getTreeExpansionListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].treeCollapsed(event);
            ++index;
        }
    }

    public void fireTreeExpanded(TreePath path) {
        TreeExpansionEvent event = new TreeExpansionEvent(this, path);
        TreeExpansionListener[] listeners = this.getTreeExpansionListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].treeExpanded(event);
            ++index;
        }
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = JTree.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener listener) {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = JTree.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        Class clazz = class$javax$swing$event$TreeSelectionListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeSelectionListener = JTree.class("[Ljavax.swing.event.TreeSelectionListener;", false);
        }
        return (TreeSelectionListener[])this.getListeners(clazz);
    }

    protected void fireValueChanged(TreeSelectionEvent event) {
        TreeSelectionListener[] listeners = this.getTreeSelectionListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].valueChanged(event);
            ++index;
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener listener) {
        Class clazz = class$javax$swing$event$TreeWillExpandListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeWillExpandListener = JTree.class("[Ljavax.swing.event.TreeWillExpandListener;", false);
        }
        this.listenerList.add(clazz, listener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener listener) {
        Class clazz = class$javax$swing$event$TreeWillExpandListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeWillExpandListener = JTree.class("[Ljavax.swing.event.TreeWillExpandListener;", false);
        }
        this.listenerList.remove(clazz, listener);
    }

    public TreeWillExpandListener[] getTreeWillExpandListeners() {
        Class clazz = class$javax$swing$event$TreeWillExpandListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$TreeWillExpandListener = JTree.class("[Ljavax.swing.event.TreeWillExpandListener;", false);
        }
        return (TreeWillExpandListener[])this.getListeners(clazz);
    }

    public void fireTreeWillCollapse(TreePath path) throws ExpandVetoException {
        TreeExpansionEvent event = new TreeExpansionEvent(this, path);
        TreeWillExpandListener[] listeners = this.getTreeWillExpandListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].treeWillCollapse(event);
            ++index;
        }
    }

    public void fireTreeWillExpand(TreePath path) throws ExpandVetoException {
        TreeExpansionEvent event = new TreeExpansionEvent(this, path);
        TreeWillExpandListener[] listeners = this.getTreeWillExpandListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].treeWillExpand(event);
            ++index;
        }
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public void setModel(TreeModel model) {
        if (this.treeModel == model) {
            return;
        }
        if (this.treeModelListener == null) {
            this.treeModelListener = this.createTreeModelListener();
        }
        if (model != null) {
            model.addTreeModelListener(this.treeModelListener);
        }
        TreeModel oldValue = this.treeModel;
        this.treeModel = model;
        this.firePropertyChange(TREE_MODEL_PROPERTY, oldValue, model);
        this.updateUI();
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean flag) {
        if (this.editable == flag) {
            return;
        }
        boolean oldValue = this.editable;
        this.editable = flag;
        this.firePropertyChange(EDITABLE_PROPERTY, oldValue, this.editable);
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setRootVisible(boolean flag) {
        if (this.rootVisible == flag) {
            return;
        }
        boolean oldValue = this.rootVisible;
        this.rootVisible = flag;
        this.firePropertyChange(ROOT_VISIBLE_PROPERTY, oldValue, flag);
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public void setShowsRootHandles(boolean flag) {
        if (this.showsRootHandles == flag) {
            return;
        }
        boolean oldValue = this.showsRootHandles;
        this.showsRootHandles = flag;
        this.firePropertyChange(SHOWS_ROOT_HANDLES_PROPERTY, oldValue, flag);
    }

    public TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setCellEditor(TreeCellEditor editor) {
        if (this.cellEditor == editor) {
            return;
        }
        TreeCellEditor oldValue = this.cellEditor;
        this.cellEditor = editor;
        this.firePropertyChange(CELL_EDITOR_PROPERTY, oldValue, editor);
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TreeCellRenderer newRenderer) {
        if (this.cellRenderer == newRenderer) {
            return;
        }
        TreeCellRenderer oldValue = this.cellRenderer;
        this.cellRenderer = newRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, oldValue, newRenderer);
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(TreeSelectionModel model) {
        if (this.selectionModel == model) {
            return;
        }
        if (this.selectionModel != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
        }
        TreeSelectionModel oldValue = this.selectionModel;
        this.selectionModel = model;
        if (this.selectionModel != null) {
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, oldValue, model);
        this.revalidate();
        this.repaint();
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int rows) {
        if (this.visibleRowCount == rows) {
            return;
        }
        int oldValue = this.visibleRowCount;
        this.visibleRowCount = rows;
        this.firePropertyChange(VISIBLE_ROW_COUNT_PROPERTY, oldValue, rows);
    }

    public boolean isLargeModel() {
        return this.largeModel;
    }

    public void setLargeModel(boolean large) {
        if (this.largeModel == large) {
            return;
        }
        boolean oldValue = this.largeModel;
        this.largeModel = large;
        this.firePropertyChange(LARGE_MODEL_PROPERTY, oldValue, large);
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public void setRowHeight(int height) {
        if (this.rowHeight == height) {
            return;
        }
        int oldValue = this.rowHeight;
        this.rowHeight = height;
        this.firePropertyChange(ROW_HEIGHT_PROPERTY, oldValue, height);
    }

    public boolean isFixedRowHeight() {
        boolean bl = false;
        if (this.rowHeight > 0) {
            bl = true;
        }
        return bl;
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public void setInvokesStopCellEditing(boolean invoke) {
        if (this.invokesStopCellEditing == invoke) {
            return;
        }
        boolean oldValue = this.invokesStopCellEditing;
        this.invokesStopCellEditing = invoke;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, oldValue, invoke);
    }

    public int getToggleClickCount() {
        return this.toggleClickCount;
    }

    public void setToggleClickCount(int count) {
        if (this.toggleClickCount == count) {
            return;
        }
        int oldValue = this.toggleClickCount;
        this.toggleClickCount = count;
        this.firePropertyChange(TOGGLE_CLICK_COUNT_PROPERTY, oldValue, count);
    }

    /*
     * Unable to fully structure code
     */
    public void scrollPathToVisible(TreePath path) {
        if (path == null) {
            return;
        }
        oPath = path.getPath();
        temp = new TreePath(oPath[0]);
        stop = false;
        i = 1;
        ** GOTO lbl16
        {
            block3: {
                if (i < oPath.length) break block3;
                stop = true;
                ** GOTO lbl15
            }
            temp = temp.pathByAddingChild(oPath[i++]);
            do {
                if (this.isVisible(temp)) continue block0;
lbl15:
                // 2 sources

                this.makeVisible(temp);
lbl16:
                // 2 sources

            } while (!stop);
        }
        rect = this.getPathBounds(path);
        this.scrollRectToVisible(rect);
        this.setSelectionPath(temp);
    }

    public void scrollRowToVisible(int row) {
        this.scrollPathToVisible(this.getPathForRow(row));
    }

    public boolean getScrollsOnExpand() {
        return this.scrollsOnExpand;
    }

    public void setScrollsOnExpand(boolean scroll) {
        if (this.scrollsOnExpand == scroll) {
            return;
        }
        boolean oldValue = this.scrollsOnExpand;
        this.scrollsOnExpand = scroll;
        this.firePropertyChange(SCROLLS_ON_EXPAND_PROPERTY, oldValue, scroll);
    }

    public void setSelectionPath(TreePath path) {
        this.selectionModel.setSelectionPath(path);
    }

    public void setSelectionPaths(TreePath[] paths) {
        this.selectionModel.setSelectionPaths(paths);
    }

    public void setSelectionRow(int row) {
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            this.selectionModel.setSelectionPath(path);
        }
    }

    public void setSelectionRows(int[] rows) {
        if (rows == null || this.getUI() == null) {
            return;
        }
        TreePath[] paths = new TreePath[rows.length];
        int i = rows.length - 1;
        while (i >= 0) {
            paths[i] = this.getPathForRow(rows[i]);
            --i;
        }
        this.setSelectionPaths(paths);
    }

    public void setSelectionInterval(int index0, int index1) {
        TreePath[] paths = this.getPathBetweenRows(index0, index1);
        if (paths != null) {
            this.setSelectionPaths(paths);
        }
    }

    public void addSelectionPath(TreePath path) {
        this.selectionModel.addSelectionPath(path);
    }

    public void addSelectionPaths(TreePath[] paths) {
        this.selectionModel.addSelectionPaths(paths);
    }

    public void addSelectionRow(int row) {
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            this.selectionModel.addSelectionPath(path);
        }
    }

    public void addSelectionRows(int[] rows) {
        if (rows == null || this.getUI() == null) {
            return;
        }
        TreePath[] paths = new TreePath[rows.length];
        int i = rows.length - 1;
        while (i >= 0) {
            paths[i] = this.getPathForRow(rows[i]);
            --i;
        }
        this.addSelectionPaths(paths);
    }

    public void addSelectionInterval(int index0, int index1) {
        TreePath[] paths = this.getPathBetweenRows(index0, index1);
        if (paths != null) {
            this.addSelectionPaths(paths);
        }
    }

    public void removeSelectionPath(TreePath path) {
        this.selectionModel.removeSelectionPath(path);
    }

    public void removeSelectionPaths(TreePath[] paths) {
        this.selectionModel.removeSelectionPaths(paths);
    }

    public void removeSelectionRow(int row) {
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            this.selectionModel.removeSelectionPath(path);
        }
    }

    public void removeSelectionRows(int[] rows) {
        if (rows == null || this.getUI() == null) {
            return;
        }
        TreePath[] paths = new TreePath[rows.length];
        int i = rows.length - 1;
        while (i >= 0) {
            paths[i] = this.getPathForRow(rows[i]);
            --i;
        }
        this.removeSelectionPaths(paths);
    }

    public void removeSelectionInterval(int index0, int index1) {
        TreePath[] paths = this.getPathBetweenRows(index0, index1);
        if (paths != null) {
            this.removeSelectionPaths(paths);
        }
    }

    public void clearSelection() {
        this.selectionModel.clearSelection();
        this.setLeadSelectionPath(null);
    }

    public TreePath getLeadSelectionPath() {
        return this.leadSelectionPath;
    }

    public void setLeadSelectionPath(TreePath path) {
        if (this.leadSelectionPath == path) {
            return;
        }
        TreePath oldValue = this.leadSelectionPath;
        this.leadSelectionPath = path;
        this.firePropertyChange(LEAD_SELECTION_PATH_PROPERTY, oldValue, path);
    }

    public TreePath getAnchorSelectionPath() {
        return this.anchorSelectionPath;
    }

    public void setAnchorSelectionPath(TreePath path) {
        if (this.anchorSelectionPath == path) {
            return;
        }
        TreePath oldValue = this.anchorSelectionPath;
        this.anchorSelectionPath = path;
        this.firePropertyChange(ANCHOR_SELECTION_PATH_PROPERTY, oldValue, path);
    }

    public int getLeadSelectionRow() {
        return this.selectionModel.getLeadSelectionRow();
    }

    public int getMaxSelectionRow() {
        return this.selectionModel.getMaxSelectionRow();
    }

    public int getMinSelectionRow() {
        return this.selectionModel.getMinSelectionRow();
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public TreePath getSelectionPath() {
        return this.selectionModel.getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.selectionModel.getSelectionPaths();
    }

    public int[] getSelectionRows() {
        return this.selectionModel.getSelectionRows();
    }

    public boolean isPathSelected(TreePath path) {
        return this.selectionModel.isPathSelected(path);
    }

    public boolean isRowSelected(int row) {
        return this.selectionModel.isPathSelected(this.getPathForRow(row));
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean enabled) {
        this.dragEnabled = enabled;
    }

    public int getRowCount() {
        TreeUI ui = this.getUI();
        if (ui != null) {
            return ui.getRowCount(this);
        }
        return 0;
    }

    public void collapsePath(TreePath path) {
        try {
            this.fireTreeWillCollapse(path);
        }
        catch (ExpandVetoException expandVetoException) {
            // empty catch block
        }
        this.setExpandedState(path, false);
        this.fireTreeCollapsed(path);
    }

    public void collapseRow(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            this.collapsePath(path);
        }
    }

    public void expandPath(TreePath path) {
        if (path == null || this.treeModel.isLeaf(path.getLastPathComponent())) {
            return;
        }
        try {
            this.fireTreeWillExpand(path);
        }
        catch (ExpandVetoException expandVetoException) {
            // empty catch block
        }
        this.setExpandedState(path, true);
        this.fireTreeExpanded(path);
    }

    public void expandRow(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return;
        }
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            this.expandPath(path);
        }
    }

    public boolean isCollapsed(TreePath path) {
        return this.isExpanded(path) ^ true;
    }

    public boolean isCollapsed(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return false;
        }
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            return this.isCollapsed(path);
        }
        return false;
    }

    public boolean isExpanded(TreePath path) {
        if (path == null) {
            return false;
        }
        Object state = this.nodeStates.get(path);
        if (state == null || state != EXPANDED) {
            return false;
        }
        TreePath parent = path.getParentPath();
        if (parent != null) {
            return this.isExpanded(parent);
        }
        return true;
    }

    public boolean isExpanded(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return false;
        }
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            return this.isExpanded(path);
        }
        return false;
    }

    public boolean getExpandsSelectedPaths() {
        return this.expandsSelectedPaths;
    }

    public void setExpandsSelectedPaths(boolean flag) {
        if (this.expandsSelectedPaths == flag) {
            return;
        }
        boolean oldValue = this.expandsSelectedPaths;
        this.expandsSelectedPaths = flag;
        this.firePropertyChange(EXPANDS_SELECTED_PATHS_PROPERTY, oldValue, flag);
    }

    public Rectangle getPathBounds(TreePath path) {
        TreeUI ui = this.getUI();
        if (ui == null) {
            return null;
        }
        return ui.getPathBounds(this, path);
    }

    public Rectangle getRowBounds(int row) {
        TreePath path = this.getPathForRow(row);
        if (path != null) {
            return this.getPathBounds(path);
        }
        return null;
    }

    public boolean isEditing() {
        TreeUI ui = this.getUI();
        if (ui != null) {
            return ui.isEditing(this);
        }
        return false;
    }

    public boolean stopEditing() {
        TreeUI ui = this.getUI();
        if (ui != null) {
            return ui.stopEditing(this);
        }
        return false;
    }

    public void cancelEditing() {
        TreeUI ui = this.getUI();
        if (ui != null) {
            ui.cancelEditing(this);
        }
    }

    public void startEditingAtPath(TreePath path) {
        TreeUI ui = this.getUI();
        if (ui != null) {
            ui.startEditingAtPath(this, path);
        }
    }

    public TreePath getEditingPath() {
        TreeUI ui = this.getUI();
        if (ui != null) {
            return ui.getEditingPath(this);
        }
        return null;
    }

    public TreePath getPathForLocation(int x, int y) {
        Rectangle rect;
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path != null && (rect = this.getPathBounds(path)) != null && rect.contains(x, y)) {
            return path;
        }
        return null;
    }

    public int getRowForLocation(int x, int y) {
        TreePath path = this.getPathForLocation(x, y);
        if (path != null) {
            return this.getRowForPath(path);
        }
        return -1;
    }

    public TreePath getClosestPathForLocation(int x, int y) {
        TreeUI ui = this.getUI();
        if (ui != null) {
            return ui.getClosestPathForLocation(this, x, y);
        }
        return null;
    }

    public int getClosestRowForLocation(int x, int y) {
        TreePath path = this.getClosestPathForLocation(x, y);
        if (path != null) {
            return this.getRowForPath(path);
        }
        return -1;
    }

    public Object getLastSelectedPathComponent() {
        TreePath path = this.getSelectionPath();
        if (path != null) {
            return path.getLastPathComponent();
        }
        return null;
    }

    private final void doExpandParents(TreePath path, boolean state) {
        TreePath parent = path.getParentPath();
        if (!this.isExpanded(parent) && parent != null) {
            this.doExpandParents(parent, false);
        }
        this.nodeStates.put(path, state ? EXPANDED : COLLAPSED);
    }

    protected void setExpandedState(TreePath path, boolean state) {
        if (path == null) {
            return;
        }
        TreePath parent = path.getParentPath();
        this.doExpandParents(path, state);
    }

    protected void clearToggledPaths() {
        this.nodeStates.clear();
    }

    protected Enumeration getDescendantToggledPaths(TreePath parent) {
        if (parent == null) {
            return null;
        }
        Enumeration nodes = this.nodeStates.keys();
        Vector result = new Vector();
        while (nodes.hasMoreElements()) {
            TreePath path = (TreePath)nodes.nextElement();
            if (!path.isDescendant(parent)) continue;
            result.addElement(path);
        }
        return result.elements();
    }

    public boolean hasBeenExpanded(TreePath path) {
        if (path == null) {
            return false;
        }
        boolean bl = false;
        if (this.nodeStates.get(path) != null) {
            bl = true;
        }
        return bl;
    }

    public boolean isVisible(TreePath path) {
        if (path == null) {
            return false;
        }
        TreePath parent = path.getParentPath();
        if (parent == null) {
            return true;
        }
        return this.isExpanded(parent);
    }

    public void makeVisible(TreePath path) {
        if (path == null) {
            return;
        }
        this.expandPath(path.getParentPath());
    }

    public boolean isPathEditable(TreePath path) {
        return this.isEditable();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root node");
        DefaultMutableTreeNode child1 = new DefaultMutableTreeNode("Child node 1");
        DefaultMutableTreeNode child11 = new DefaultMutableTreeNode("Child node 1.1");
        DefaultMutableTreeNode child12 = new DefaultMutableTreeNode("Child node 1.2");
        DefaultMutableTreeNode child13 = new DefaultMutableTreeNode("Child node 1.3");
        DefaultMutableTreeNode child2 = new DefaultMutableTreeNode("Child node 2");
        DefaultMutableTreeNode child21 = new DefaultMutableTreeNode("Child node 2.1");
        DefaultMutableTreeNode child22 = new DefaultMutableTreeNode("Child node 2.2");
        DefaultMutableTreeNode child23 = new DefaultMutableTreeNode("Child node 2.3");
        DefaultMutableTreeNode child24 = new DefaultMutableTreeNode("Child node 2.4");
        DefaultMutableTreeNode child3 = new DefaultMutableTreeNode("Child node 3");
        root.add(child1);
        root.add(child2);
        root.add(child3);
        child1.add(child11);
        child1.add(child12);
        child1.add(child13);
        child2.add(child21);
        child2.add(child22);
        child2.add(child23);
        child2.add(child24);
        return new DefaultTreeModel(root);
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return value.toString();
    }

    public String paramString() {
        return "";
    }

    public Enumeration getExpandedDescendants(TreePath path) {
        Enumeration paths = this.nodeStates.keys();
        Vector relevantPaths = new Vector();
        while (paths.hasMoreElements()) {
            TreePath nextPath = (TreePath)paths.nextElement();
            if (this.nodeStates.get(nextPath) != EXPANDED || !path.isDescendant(nextPath)) continue;
            relevantPaths.add(nextPath);
        }
        return relevantPaths.elements();
    }

    public TreePath getNextMatch(String prefix, int startingRow, Position.Bias bias) {
        if (prefix == null) {
            throw new IllegalArgumentException("The argument 'prefix' must not be null.");
        }
        if (startingRow < 0) {
            throw new IllegalArgumentException("The argument 'startingRow' must not be less than zero.");
        }
        int size = this.getRowCount();
        if (startingRow > size) {
            throw new IllegalArgumentException("The argument 'startingRow' must not be greater than the number of elements in the TreeModel.");
        }
        TreePath foundPath = null;
        if (bias == Position.Bias.Forward) {
            int i = startingRow;
            while (i < size) {
                TreePath path = this.getPathForRow(i);
                Object o = path.getLastPathComponent();
                String item = this.convertValueToText(o, this.isRowSelected(i), this.isExpanded(i), this.treeModel.isLeaf(o), i, false);
                if (item.startsWith(prefix)) {
                    foundPath = path;
                    break;
                }
                ++i;
            }
        } else {
            int i = startingRow;
            while (i >= 0) {
                TreePath path = this.getPathForRow(i);
                Object o = path.getLastPathComponent();
                String item = this.convertValueToText(o, this.isRowSelected(i), this.isExpanded(i), this.treeModel.isLeaf(o), i, false);
                if (item.startsWith(prefix)) {
                    foundPath = path;
                    break;
                }
                --i;
            }
        }
        return foundPath;
    }

    protected boolean removeDescendantSelectedPaths(TreePath path, boolean includeSelected) {
        boolean removedSomething = false;
        TreePath[] selected = this.getSelectionPaths();
        int index = 0;
        while (index < selected.length) {
            if (selected[index] == path && includeSelected || selected[index].isDescendant(path)) {
                this.removeSelectionPath(selected[index]);
                removedSomething = true;
            }
            ++index;
        }
        return removedSomething;
    }

    protected void removeDescendantToggledPaths(Enumeration toRemove) {
        while (toRemove.hasMoreElements()) {
            TreePath current = (TreePath)toRemove.nextElement();
            Enumeration descendants = this.getDescendantToggledPaths(current);
            while (descendants.hasMoreElements()) {
                TreePath currentDes = (TreePath)descendants.nextElement();
                if (!this.isExpanded(currentDes)) continue;
                this.nodeStates.remove(currentDes);
            }
        }
    }

    public void treeDidChange() {
        this.repaint();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.nodeStates = new Hashtable();
        this.selectionRedirector = new TreeSelectionRedirector();
    }

    public JTree() {
        this(JTree.createTreeModel(null));
    }

    public JTree(Hashtable value) {
        this(JTree.createTreeModel(value));
    }

    public JTree(Object[] value) {
        this(JTree.createTreeModel(value));
    }

    public JTree(TreeModel model) {
        this.this();
        this.updateUI();
        this.setRootVisible(true);
        this.setModel(model);
        this.setSelectionModel(EmptySelectionModel.sharedInstance());
    }

    public JTree(TreeNode root) {
        this(root, false);
    }

    public JTree(TreeNode root, boolean asksAllowChildren) {
        this(new DefaultTreeModel(root, asksAllowChildren));
    }

    public JTree(Vector value) {
        this(JTree.createTreeModel(value));
    }

    public static class DynamicUtilTreeNode
    extends DefaultMutableTreeNode {
        protected Object childValue;
        protected boolean loadedChildren;
        protected boolean hasChildren;

        public int getChildCount() {
            this.loadChildren();
            return super.getChildCount();
        }

        protected void loadChildren() {
            if (!this.loadedChildren) {
                DynamicUtilTreeNode.createChildren(this, this.childValue);
                this.loadedChildren = true;
            }
        }

        public Enumeration children() {
            this.loadChildren();
            return super.children();
        }

        public TreeNode getChildAt(int pos) {
            this.loadChildren();
            return super.getChildAt(pos);
        }

        public boolean isLeaf() {
            boolean bl = false;
            if (this.childValue == null || !(this.childValue instanceof Hashtable) && !(this.childValue instanceof Vector) && !this.childValue.getClass().isArray()) {
                bl = true;
            }
            return bl;
        }

        public static void createChildren(DefaultMutableTreeNode parent, Object children) {
            block4: {
                block5: {
                    block3: {
                        if (!(children instanceof Hashtable)) break block3;
                        Hashtable tab = (Hashtable)children;
                        Enumeration e = tab.keys();
                        while (e.hasMoreElements()) {
                            Object key = e.nextElement();
                            Object val = tab.get(key);
                            parent.add(new DynamicUtilTreeNode(key, val));
                        }
                        break block4;
                    }
                    if (!(children instanceof Vector)) break block5;
                    Iterator i = ((Vector)children).iterator();
                    while (i.hasNext()) {
                        Object n = i.next();
                        parent.add(new DynamicUtilTreeNode(n, n));
                    }
                    break block4;
                }
                if (children == null || !children.getClass().isArray()) break block4;
                Object[] arr = (Object[])children;
                int i = 0;
                while (i < arr.length) {
                    parent.add(new DynamicUtilTreeNode(arr[i], arr[i]));
                    ++i;
                }
            }
        }

        public DynamicUtilTreeNode(Object value, Object children) {
            super(value);
            this.childValue = children;
            this.loadedChildren = false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleJTree
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    TreeSelectionListener,
    TreeModelListener,
    TreeExpansionListener {
        public void addAccessibleSelection(int i) {
            JTree.this.addSelectionInterval(i, i);
        }

        public void clearAccessibleSelection() {
            JTree.this.clearSelection();
        }

        public void fireVisibleDataPropertyChange() {
            JTree.this.treeDidChange();
        }

        public Accessible getAccessibleAt(Point p) {
            TreePath tp = JTree.this.getClosestPathForLocation(p.x, p.y);
            if (tp != null) {
                return new AccessibleJTreeNode(JTree.this, tp, null);
            }
            return null;
        }

        public Accessible getAccessibleChild(int i) {
            return null;
        }

        public int getAccessibleChildrenCount() {
            TreeModel model = JTree.this.getModel();
            if (model != null) {
                return model.getChildCount(model.getRoot());
            }
            return 0;
        }

        public int getAccessibleIndexInParent() {
            return 0;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        public AccessibleSelection getAccessibleSelection() {
            TreeModel mod = JTree.this.getModel();
            if (mod != null) {
                return new AccessibleJTreeNode(JTree.this, new TreePath(mod.getRoot()), null).getAccessibleSelection();
            }
            return null;
        }

        public Accessible getAccessibleSelection(int i) {
            TreeModel mod = JTree.this.getModel();
            if (mod != null) {
                return new AccessibleJTreeNode(JTree.this, new TreePath(mod.getRoot()), null).getAccessibleSelection(i);
            }
            return null;
        }

        public int getAccessibleSelectionCount() {
            return JTree.this.getSelectionCount();
        }

        public boolean isAccessibleChildSelected(int i) {
            return false;
        }

        public void removeAccessibleSelection(int i) {
            JTree.this.removeSelectionInterval(i, i);
        }

        public void selectAllAccessibleSelection() {
            if (JTree.this.getSelectionModel().getSelectionMode() != 1) {
                JTree.this.addSelectionInterval(0, JTree.this.getVisibleRowCount());
            }
        }

        public void treeCollapsed(TreeExpansionEvent e) {
            JTree.this.fireTreeCollapsed(e.getPath());
        }

        public void treeExpanded(TreeExpansionEvent e) {
            JTree.this.fireTreeExpanded(e.getPath());
        }

        public void treeNodesChanged(TreeModelEvent e) {
        }

        public void treeNodesInserted(TreeModelEvent e) {
        }

        public void treeNodesRemoved(TreeModelEvent e) {
        }

        public void treeStructureChanged(TreeModelEvent e) {
        }

        public void valueChanged(TreeSelectionEvent e) {
            JTree.this.fireValueChanged(e);
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        protected class AccessibleJTreeNode
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent,
        AccessibleSelection,
        AccessibleAction {
            private JTree tree;
            private TreePath tp;
            private Accessible acc;
            private AccessibleStateSet states = new AccessibleStateSet();
            private Vector selectionList = new Vector();
            private Vector actionList = new Vector();
            private TreeModel mod = this.tree.getModel();
            private Cursor cursor;

            public void addAccessibleSelection(int i) {
                Object child;
                if (this.mod != null && (child = this.mod.getChild(this.tp.getLastPathComponent(), i)) != null) {
                    if (!this.states.contains(AccessibleState.MULTISELECTABLE)) {
                        this.clearAccessibleSelection();
                    }
                    this.selectionList.add(child);
                    this.tree.addSelectionPath(this.tp.pathByAddingChild(child));
                }
            }

            public void addFocusListener(FocusListener l) {
                this.tree.addFocusListener(l);
            }

            public void addPropertyChangeListener(PropertyChangeListener l) {
            }

            public void clearAccessibleSelection() {
                this.selectionList.clear();
            }

            public boolean contains(Point p) {
                return this.getBounds().contains(p);
            }

            public boolean doAccessibleAction(int i) {
                if (i >= this.actionList.size() || i < 0) {
                    return false;
                }
                if (this.actionList.get(i).equals("EXPAND")) {
                    this.tree.expandPath(this.tp);
                } else if (this.actionList.get(i).equals("COLLAPSE")) {
                    this.tree.collapsePath(this.tp);
                } else if (this.actionList.get(i).equals("SELECT")) {
                    this.tree.addSelectionPath(this.tp);
                } else if (this.actionList.get(i).equals("DESELECT")) {
                    this.tree.removeSelectionPath(this.tp);
                } else if (this.actionList.get(i).equals("EDIT")) {
                    this.tree.startEditingAtPath(this.tp);
                } else {
                    return false;
                }
                return true;
            }

            public AccessibleAction getAccessibleAction() {
                return this;
            }

            public int getAccessibleActionCount() {
                return this.actionList.size();
            }

            public String getAccessibleActionDescription(int i) {
                if (i < 0 || i >= this.actionList.size()) {
                    return this.actionList.get(i).toString();
                }
                return super.getAccessibleDescription();
            }

            public Accessible getAccessibleAt(Point p) {
                TreePath acc = this.tree.getClosestPathForLocation(p.x, p.y);
                if (acc != null) {
                    return new AccessibleJTreeNode(this.tree, acc, this);
                }
                return null;
            }

            public Accessible getAccessibleChild(int i) {
                Object child;
                if (this.mod != null && (child = this.mod.getChild(this.tp.getLastPathComponent(), i)) != null) {
                    return new AccessibleJTreeNode(this.tree, this.tp.pathByAddingChild(child), this.acc);
                }
                return null;
            }

            public int getAccessibleChildrenCount() {
                TreeModel mod = JTree.this.getModel();
                if (mod != null) {
                    return mod.getChildCount(this.tp.getLastPathComponent());
                }
                return 0;
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleDescription() {
                return super.getAccessibleDescription();
            }

            public int getAccessibleIndexInParent() {
                AccessibleContext parent = this.getAccessibleParent().getAccessibleContext();
                if (parent != null) {
                    int i = 0;
                    while (i < parent.getAccessibleChildrenCount()) {
                        if (parent.getAccessibleChild(i).equals(this)) {
                            return i;
                        }
                        ++i;
                    }
                }
                return -1;
            }

            public String getAccessibleName() {
                return super.getAccessibleName();
            }

            public Accessible getAccessibleParent() {
                return super.getAccessibleParent();
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleJTree.this.getAccessibleRole();
            }

            public AccessibleSelection getAccessibleSelection() {
                return this;
            }

            public Accessible getAccessibleSelection(int i) {
                if (i > 0 && i < this.getAccessibleSelectionCount()) {
                    return new AccessibleJTreeNode(this.tree, this.tp.pathByAddingChild(this.selectionList.get(i)), this.acc);
                }
                return null;
            }

            public int getAccessibleSelectionCount() {
                return this.selectionList.size();
            }

            public AccessibleStateSet getAccessibleStateSet() {
                if (this.isVisible()) {
                    this.states.add(AccessibleState.VISIBLE);
                }
                if (this.tree.isCollapsed(this.tp)) {
                    this.states.add(AccessibleState.COLLAPSED);
                }
                if (this.tree.isEditable()) {
                    this.states.add(AccessibleState.EDITABLE);
                }
                if (this.mod != null && !this.mod.isLeaf(this.tp.getLastPathComponent())) {
                    this.states.add(AccessibleState.EXPANDABLE);
                }
                if (this.tree.isExpanded(this.tp)) {
                    this.states.add(AccessibleState.EXPANDED);
                }
                if (JTree.this.isFocusable()) {
                    this.states.add(AccessibleState.FOCUSABLE);
                }
                if (JTree.this.hasFocus()) {
                    this.states.add(AccessibleState.FOCUSED);
                }
                if (this.tree.getSelectionModel().getSelectionMode() != 1) {
                    this.states.add(AccessibleState.MULTISELECTABLE);
                }
                if (this.tree.isOpaque()) {
                    this.states.add(AccessibleState.OPAQUE);
                }
                if (this.tree.isPathSelected(this.tp)) {
                    this.states.add(AccessibleState.SELECTED);
                }
                if (this.isShowing()) {
                    this.states.add(AccessibleState.SHOWING);
                }
                this.states.add(AccessibleState.SELECTABLE);
                return this.states;
            }

            public AccessibleText getAccessibleText() {
                return super.getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return super.getAccessibleValue();
            }

            public Color getBackground() {
                return this.tree.getBackground();
            }

            public Rectangle getBounds() {
                return this.tree.getPathBounds(this.tp);
            }

            public Cursor getCursor() {
                return this.cursor;
            }

            public Font getFont() {
                return this.tree.getFont();
            }

            public FontMetrics getFontMetrics(Font f) {
                return this.tree.getFontMetrics(f);
            }

            public Color getForeground() {
                return this.tree.getForeground();
            }

            public Locale getLocale() {
                return this.tree.getLocale();
            }

            public Point getLocation() {
                return this.getLocationInJTree();
            }

            protected Point getLocationInJTree() {
                Rectangle bounds = this.tree.getPathBounds(this.tp);
                return new Point(bounds.x, bounds.y);
            }

            public Point getLocationOnScreen() {
                Point loc = this.getLocation();
                SwingUtilities.convertPointToScreen(loc, this.tree);
                return loc;
            }

            public Dimension getSize() {
                Rectangle b = this.getBounds();
                return b.getSize();
            }

            public boolean isAccessibleChildSelected(int i) {
                Object child = this.mod.getChild(this.tp.getLastPathComponent(), i);
                if (child != null) {
                    return this.tree.isPathSelected(this.tp.pathByAddingChild(child));
                }
                return false;
            }

            public boolean isEnabled() {
                return this.tree.isEnabled();
            }

            public boolean isFocusTraversable() {
                return true;
            }

            public boolean isShowing() {
                boolean bl = false;
                if (this.isVisible() && this.tree.isShowing()) {
                    bl = true;
                }
                return bl;
            }

            public boolean isVisible() {
                return this.tree.isVisible(this.tp);
            }

            public void removeAccessibleSelection(int i) {
                Object child;
                if (this.mod != null && (child = this.mod.getChild(this.tp.getLastPathComponent(), i)) != null) {
                    if (!this.states.contains(AccessibleState.MULTISELECTABLE)) {
                        this.clearAccessibleSelection();
                    }
                    if (this.selectionList.contains(child)) {
                        this.selectionList.remove(child);
                        this.tree.removeSelectionPath(this.tp.pathByAddingChild(child));
                    }
                }
            }

            public void removeFocusListener(FocusListener l) {
                this.tree.removeFocusListener(l);
            }

            public void removePropertyChangeListener(PropertyChangeListener l) {
            }

            public void requestFocus() {
                this.tree.requestFocus();
            }

            public void selectAllAccessibleSelection() {
                Object parent = this.tp.getLastPathComponent();
                if (this.mod != null) {
                    int i = 0;
                    while (i < this.mod.getChildCount(parent)) {
                        Object child = this.mod.getChild(parent, i);
                        if (child != null) {
                            if (!this.states.contains(AccessibleState.MULTISELECTABLE)) {
                                this.clearAccessibleSelection();
                            }
                            if (this.selectionList.contains(child)) {
                                this.selectionList.add(child);
                                this.tree.addSelectionPath(this.tp.pathByAddingChild(child));
                            }
                        }
                        ++i;
                    }
                }
            }

            public void setAccessibleDescription(String s) {
                super.setAccessibleDescription(s);
            }

            public void setAccessibleName(String s) {
                super.setAccessibleName(s);
            }

            public void setBackground(Color c) {
            }

            public void setBounds(Rectangle r) {
            }

            public void setCursor(Cursor c) {
                this.cursor = c;
            }

            public void setEnabled(boolean b) {
            }

            public void setFont(Font f) {
            }

            public void setForeground(Color c) {
            }

            public void setLocation(Point p) {
            }

            public void setSize(Dimension d) {
            }

            public void setVisible(boolean b) {
            }

            public AccessibleJTreeNode(JTree t, TreePath p, Accessible ap) {
                this.cursor = JTree.this.getCursor();
                this.tree = t;
                this.tp = p;
                this.acc = ap;
                TreePath[] selected = this.tree.getSelectionPaths();
                int i = 0;
                while (i < selected.length) {
                    TreePath sel = selected[i];
                    if (sel.getParentPath().equals(this.tp)) {
                        this.selectionList.add(sel);
                    }
                    ++i;
                }
                this.actionList.add("EXPAND");
                this.actionList.add("COLLAPSE");
                this.actionList.add("EDIT");
                this.actionList.add("SELECT");
                this.actionList.add("DESELECT");
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class TreeModelHandler
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent ev) {
        }

        public void treeNodesInserted(TreeModelEvent ev) {
        }

        public void treeNodesRemoved(TreeModelEvent ev) {
        }

        public void treeStructureChanged(TreeModelEvent ev) {
            TreePath path = ev.getTreePath();
            JTree.this.setExpandedState(path, JTree.this.isExpanded(path));
        }

        protected TreeModelHandler() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class TreeSelectionRedirector
    implements TreeSelectionListener,
    Serializable {
        private static final long serialVersionUID = -3505069663646241664L;

        public void valueChanged(TreeSelectionEvent ev) {
            TreeSelectionEvent rewritten = (TreeSelectionEvent)ev.cloneWithSource(JTree.this);
            JTree.this.fireValueChanged(rewritten);
            JTree.this.repaint();
        }

        protected TreeSelectionRedirector() {
        }
    }

    protected static class EmptySelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = -5815023306225701477L;
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }

        public void setSelectionPaths(TreePath[] paths) {
        }

        public void addSelectionPaths(TreePath[] paths) {
        }

        public void removeSelectionPaths(TreePath[] paths) {
        }

        protected EmptySelectionModel() {
        }
    }
}

