/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.security.auth.AuthPermission;
import javax.security.auth.SubjectDomainCombiner;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class Subject
implements Serializable {
    private static final long serialVersionUID = -8308522755600156056L;
    private final Set principals;
    private boolean readOnly;
    private final transient SecureSet pubCred;
    private final transient SecureSet privCred;
    static /* synthetic */ Class class$javax$security$auth$Subject;

    public static final Subject getSubject(AccessControlContext context) {
        DomainCombiner dc;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("getSubject"));
        }
        if (!((dc = context.getDomainCombiner()) instanceof SubjectDomainCombiner)) {
            return null;
        }
        return ((SubjectDomainCombiner)dc).getSubject();
    }

    public static final Object doAs(Subject subject, PrivilegedAction action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAs"));
        }
        AccessControlContext context = new AccessControlContext(AccessController.getContext(), new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(action, context);
    }

    public static final Object doAs(Subject subject, PrivilegedExceptionAction action) throws PrivilegedActionException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAs"));
        }
        AccessControlContext context = new AccessControlContext(AccessController.getContext(), new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(action, context);
    }

    public static final Object doAsPrivileged(Subject subject, PrivilegedAction action, AccessControlContext acc) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        AccessControlContext context = new AccessControlContext(acc, new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(action, context);
    }

    public static final Object doAsPrivileged(Subject subject, PrivilegedExceptionAction action, AccessControlContext acc) throws PrivilegedActionException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("doAsPrivileged"));
        }
        if (acc == null) {
            acc = new AccessControlContext(new ProtectionDomain[0]);
        }
        AccessControlContext context = new AccessControlContext(acc, new SubjectDomainCombiner(subject));
        return AccessController.doPrivileged(action, context);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof Subject)) {
            return false;
        }
        Subject that = (Subject)o;
        boolean bl = false;
        if (this.principals.containsAll(that.getPrincipals()) && this.pubCred.containsAll(that.getPublicCredentials()) && this.privCred.containsAll(that.getPrivateCredentials())) {
            bl = true;
        }
        return bl;
    }

    public final Set getPrincipals() {
        return this.principals;
    }

    public final Set getPrincipals(Class clazz) {
        HashSet result = new HashSet(this.principals.size());
        Iterator it = this.principals.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null || !clazz.isAssignableFrom(o.getClass())) continue;
            result.add(o);
        }
        return Collections.unmodifiableSet(result);
    }

    public final Set getPrivateCredentials() {
        return this.privCred;
    }

    public final Set getPrivateCredentials(Class clazz) {
        HashSet result = new HashSet(this.privCred.size());
        Iterator it = this.privCred.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null || !clazz.isAssignableFrom(o.getClass())) continue;
            result.add(o);
        }
        return Collections.unmodifiableSet(result);
    }

    public final Set getPublicCredentials() {
        return this.pubCred;
    }

    public final Set getPublicCredentials(Class clazz) {
        HashSet result = new HashSet(this.pubCred.size());
        Iterator it = this.pubCred.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o == null || !clazz.isAssignableFrom(o.getClass())) continue;
            result.add(o);
        }
        return Collections.unmodifiableSet(result);
    }

    public final int hashCode() {
        return this.principals.hashCode() + this.privCred.hashCode() + this.pubCred.hashCode();
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final void setReadOnly() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AuthPermission("setReadOnly"));
        }
        this.readOnly = true;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class clazz = class$javax$security$auth$Subject;
        if (clazz == null) {
            clazz = class$javax$security$auth$Subject = Subject.class("[Ljavax.security.auth.Subject;", false);
        }
        return stringBuffer.append(clazz.getName()).append(" [ principals=").append(this.principals).append(", private credentials=").append(this.privCred).append(", public credentials=").append(this.pubCred).append(", read-only=").append(this.readOnly).append(" ]").toString();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public Subject() {
        this.principals = new SecureSet(this, 0);
        this.pubCred = new SecureSet(this, 1);
        this.privCred = new SecureSet(this, 2);
        this.readOnly = false;
    }

    public Subject(boolean readOnly, Set principals, Set pubCred, Set privCred) {
        if (principals == null || pubCred == null || privCred == null) {
            throw new NullPointerException();
        }
        this.principals = new SecureSet(this, 0, principals);
        this.pubCred = new SecureSet(this, 1, pubCred);
        this.privCred = new SecureSet(this, 2, privCred);
        this.readOnly = readOnly;
    }

    private static class SecureSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 7911754171111800359L;
        static final int PRINCIPALS = 0;
        static final int PUBLIC_CREDENTIALS = 1;
        static final int PRIVATE_CREDENTIALS = 2;
        private final Subject subject;
        private final LinkedList elements;
        private final transient int type;

        public synchronized int size() {
            return this.elements.size();
        }

        public Iterator iterator() {
            return this.elements.iterator();
        }

        public synchronized boolean add(Object element) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            SecurityManager sm = System.getSecurityManager();
            switch (this.type) {
                case 0: {
                    if (sm != null) {
                        sm.checkPermission(new AuthPermission("modifyPrincipals"));
                    }
                    if (element instanceof Principal) break;
                    throw new IllegalArgumentException("element is not a Principal");
                }
                case 1: {
                    if (sm == null) break;
                    sm.checkPermission(new AuthPermission("modifyPublicCredentials"));
                    break;
                }
                case 2: {
                    if (sm == null) break;
                    sm.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    break;
                }
                default: {
                    throw new Error("this statement should be unreachable");
                }
            }
            if (this.elements.contains(element)) {
                return false;
            }
            return this.elements.add(element);
        }

        public synchronized boolean remove(Object element) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            SecurityManager sm = System.getSecurityManager();
            switch (this.type) {
                case 0: {
                    if (sm != null) {
                        sm.checkPermission(new AuthPermission("modifyPrincipals"));
                    }
                    if (element instanceof Principal) break;
                    throw new IllegalArgumentException("element is not a Principal");
                }
                case 1: {
                    if (sm == null) break;
                    sm.checkPermission(new AuthPermission("modifyPublicCredentials"));
                    break;
                }
                case 2: {
                    if (sm == null) break;
                    sm.checkPermission(new AuthPermission("modifyPrivateCredentials"));
                    break;
                }
                default: {
                    throw new Error("this statement should be unreachable");
                }
            }
            return this.elements.remove(element);
        }

        public synchronized boolean contains(Object element) {
            return this.elements.contains(element);
        }

        public boolean removeAll(Collection c) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            return super.removeAll(c);
        }

        public boolean retainAll(Collection c) {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            return super.retainAll(c);
        }

        public void clear() {
            if (this.subject.isReadOnly()) {
                throw new IllegalStateException("subject is read-only");
            }
            this.elements.clear();
        }

        private final synchronized void writeObject(ObjectOutputStream out) throws IOException {
            throw new UnsupportedOperationException("FIXME: determine serialization");
        }

        private final void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
            throw new UnsupportedOperationException("FIXME: determine serialization");
        }

        SecureSet(Subject subject, int type, Collection inElements) {
            this(subject, type);
            Iterator it = inElements.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (type == 0 && !(o instanceof Principal)) {
                    throw new IllegalArgumentException(o + " is not a Principal");
                }
                if (this.elements.contains(o)) continue;
                this.elements.add(o);
            }
        }

        SecureSet(Subject subject, int type) {
            this.subject = subject;
            this.type = type;
            this.elements = new LinkedList();
        }
    }
}

