/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import gnu.classpath.ServiceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.imageio.spi.RegisterableService;

public class ServiceRegistry {
    final Class[] categories;
    private final LinkedList[] providers;
    private IdentityHashMap[] constraints;

    public static Iterator lookupProviders(Class spi, ClassLoader loader) {
        return ServiceFactory.lookupProviders(spi, loader);
    }

    public static Iterator lookupProviders(Class spi) {
        return ServiceFactory.lookupProviders(spi);
    }

    public Iterator getCategories() {
        return new Iterator(){
            int index;

            public final boolean hasNext() {
                boolean bl = false;
                if (this.index < ServiceRegistry.this.categories.length - 1) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ServiceRegistry.this.categories[++this.index];
            }

            public final void remove() {
                throw new UnsupportedOperationException();
            }

            private final /* synthetic */ void this() {
                this.index = -1;
            }
            {
                this.this();
            }
        };
    }

    private final synchronized boolean registerServiceProvider(Object provider, int cat) {
        boolean result;
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        Class category = this.categories[cat];
        if (!category.isInstance(provider)) {
            throw new ClassCastException(category.getName());
        }
        LinkedList provs = this.providers[cat];
        if (provs == null) {
            result = true;
            provs = this.providers[cat] = new LinkedList();
        } else {
            result = false;
        }
        provs.add(provider);
        if (provider instanceof RegisterableService) {
            ((RegisterableService)provider).onRegistration(this, category);
        }
        return result;
    }

    public synchronized boolean registerServiceProvider(Object provider, Class category) {
        int i = 0;
        while (i < this.categories.length) {
            if (this.categories[i] == category) {
                return this.registerServiceProvider(provider, i);
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public synchronized void registerServiceProvider(Object provider) {
        boolean ok = false;
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.categories.length) {
            if (this.categories[i].isInstance(provider)) {
                ok = true;
                this.registerServiceProvider(provider, i);
            }
            ++i;
        }
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void registerServiceProviders(Iterator providers) {
        if (providers != null) ** GOTO lbl4
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            this.registerServiceProvider(providers.next());
lbl4:
            // 2 sources

            ** while (providers.hasNext())
        }
lbl5:
        // 1 sources

    }

    private final synchronized boolean deregisterServiceProvider(Object provider, int cat) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        Class category = this.categories[cat];
        if (!category.isInstance(provider)) {
            throw new ClassCastException(category.getName());
        }
        LinkedList provs = this.providers[cat];
        if (provs == null) {
            return false;
        }
        boolean result = provs.remove(provider);
        if (provs.isEmpty()) {
            this.providers[cat] = null;
        }
        if (result && provider instanceof RegisterableService) {
            ((RegisterableService)provider).onDeregistration(this, category);
        }
        return result;
    }

    public synchronized boolean deregisterServiceProvider(Object provider, Class category) {
        int i = 0;
        while (i < this.categories.length) {
            if (this.categories[i] == category) {
                return this.deregisterServiceProvider(provider, i);
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public synchronized void deregisterServiceProvider(Object provider) {
        boolean ok = false;
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.categories.length) {
            if (this.categories[i].isInstance(provider)) {
                ok = true;
                this.deregisterServiceProvider(provider, i);
            }
            ++i;
        }
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    public synchronized void deregisterAll(Class category) {
        boolean ok = false;
        int i = 0;
        while (i < this.categories.length) {
            if (this.categories[i] == category) {
                ok = true;
                while (this.providers[i] != null) {
                    this.deregisterServiceProvider(this.providers[i].get(0), i);
                }
            }
            ++i;
        }
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void deregisterAll() {
        i = 0;
        ** GOTO lbl8
        {
            this.deregisterServiceProvider(this.providers[i].get(0), i);
            do {
                if (this.providers[i] != null) continue block0;
                ++i;
lbl8:
                // 2 sources

            } while (i < this.categories.length);
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.deregisterAll();
    }

    public synchronized boolean contains(Object provider) {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.providers.length) {
            LinkedList p;
            if (this.categories[i].isInstance(provider) && (p = this.providers[i]) != null && p.contains(provider)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final int getCategoryID(Class category) {
        int i = 0;
        while (i < this.categories.length) {
            if (this.categories[i] == category) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException();
    }

    public Iterator getServiceProviders(Class category, boolean useOrdering) {
        return this.getServiceProviders(category, null, useOrdering);
    }

    public synchronized Iterator getServiceProviders(Class category, Filter filter, boolean useOrdering) {
        IdentityHashMap cons;
        int catid = this.getCategoryID(category);
        LinkedList provs = this.providers[catid];
        if (provs == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList result = new ArrayList(provs.size());
        Iterator iter = provs.iterator();
        while (iter.hasNext()) {
            Object provider = iter.next();
            if (filter != null && !filter.filter(provider)) continue;
            result.add(provider);
        }
        if (useOrdering && this.constraints != null && (cons = this.constraints[catid]) != null) {
            Collections.sort(result, new Comparator(){

                public final int compare(Object o1, Object o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    Set s = (Set)cons.get(o1);
                    if (s != null && s.contains(o2)) {
                        return -1;
                    }
                    s = (Set)cons.get(o2);
                    if (s != null && s.contains(o1)) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        return result.iterator();
    }

    public synchronized Object getServiceProviderByClass(Class providerClass) {
        if (providerClass == null) {
            throw new IllegalArgumentException();
        }
        int cat = 0;
        while (cat < this.categories.length) {
            LinkedList provs;
            if (this.categories[cat].isAssignableFrom(providerClass) && (provs = this.providers[cat]) != null) {
                Iterator iter = provs.iterator();
                while (iter.hasNext()) {
                    Object provider = iter.next();
                    if (!providerClass.isInstance(provider)) continue;
                    return provider;
                }
            }
            ++cat;
        }
        return null;
    }

    public synchronized boolean setOrdering(Class category, Object firstProvider, Object secondProvider) {
        return this.addConstraint(this.getCategoryID(category), firstProvider, secondProvider);
    }

    public synchronized boolean unsetOrdering(Class category, Object firstProvider, Object secondProvider) {
        return this.removeConstraint(this.getCategoryID(category), firstProvider, secondProvider);
    }

    private final boolean addConstraint(int catid, Object first, Object second) {
        Set s;
        IdentityHashMap cons;
        this.removeConstraint(catid, second, first);
        if (this.constraints == null) {
            this.constraints = new IdentityHashMap[this.categories.length];
        }
        if ((cons = this.constraints[catid]) == null) {
            cons = this.constraints[catid] = new IdentityHashMap();
        }
        if ((s = (Set)cons.get(first)) == null) {
            s = new HashSet();
            cons.put(first, s);
        }
        return s.add(second);
    }

    private final boolean removeConstraint(int catid, Object first, Object second) {
        if (first == null || second == null || first == second) {
            throw new IllegalArgumentException();
        }
        if (this.constraints == null) {
            return false;
        }
        IdentityHashMap cons = this.constraints[catid];
        if (cons == null) {
            return false;
        }
        Collection s = (Collection)cons.get(first);
        if (s == null) {
            return false;
        }
        if (!s.remove(second)) {
            return false;
        }
        if (cons.isEmpty()) {
            this.constraints[catid] = null;
            boolean anyConstraints = false;
            int i = 0;
            while (i < this.constraints.length) {
                if (this.constraints[i] != null) {
                    anyConstraints = true;
                    break;
                }
                ++i;
            }
            if (!anyConstraints) {
                this.constraints = null;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public ServiceRegistry(Iterator categories) {
        super();
        cats = new ArrayList(10);
        if (categories != null) ** GOTO lbl10
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            cat = (Class)categories.next();
            if (cat == null) {
                throw new IllegalArgumentException();
            }
            cats.add(cat);
lbl10:
            // 2 sources

            ** while (categories.hasNext())
        }
lbl11:
        // 1 sources

        numCats = cats.size();
        this.categories = (Class[])cats.toArray(new Class[numCats]);
        this.providers = new LinkedList[numCats];
    }

    public static interface Filter {
        public boolean filter(Object var1);
    }
}

