/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataController;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public abstract class IIOMetadata {
    protected IIOMetadataController controller;
    protected IIOMetadataController defaultController;
    protected String[] extraMetadataFormatClassNames;
    protected String[] extraMetadataFormatNames;
    protected String nativeMetadataFormatClassName;
    protected String nativeMetadataFormatName;
    protected boolean standardFormatSupported;

    public boolean activateController() {
        if (!this.hasController()) {
            return false;
        }
        return this.getDefaultController().activate(this);
    }

    public IIOMetadataController getController() {
        return this.controller;
    }

    public IIOMetadataController getDefaultController() {
        return this.defaultController;
    }

    public String[] getExtraMetadataFormatNames() {
        return (String[])this.extraMetadataFormatNames.clone();
    }

    public IIOMetadataFormat getMetadataFormat(String formatName) {
        IIOMetadataFormat format;
        if (formatName == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        String formatClassName = null;
        if (this.isStandardMetadataFormatSupported() && formatName.equals(this.nativeMetadataFormatName)) {
            formatClassName = this.nativeMetadataFormatClassName;
        } else {
            String[] extraFormatNames = this.getExtraMetadataFormatNames();
            int i = extraFormatNames.length - 1;
            while (i >= 0) {
                if (extraFormatNames[i].equals(formatName)) {
                    formatClassName = extraFormatNames[i];
                    break;
                }
                --i;
            }
        }
        if (formatClassName == null) {
            throw new IllegalArgumentException("unknown format");
        }
        try {
            format = (IIOMetadataFormat)Class.forName(formatClassName).newInstance();
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException();
            ise.initCause(e);
            throw ise;
        }
        return format;
    }

    public String[] getMetadataFormatNames() {
        String[] formatNames = this.getExtraMetadataFormatNames();
        if (this.isStandardMetadataFormatSupported()) {
            String[] tmp = new String[formatNames.length + 1];
            tmp[0] = this.getNativeMetadataFormatName();
            int i = 1;
            while (i < tmp.length) {
                tmp[i] = formatNames[i - 1];
                ++i;
            }
            formatNames = tmp;
        }
        return formatNames;
    }

    public String getNativeMetadataFormatName() {
        return this.nativeMetadataFormatName;
    }

    public boolean hasController() {
        boolean bl = false;
        if (this.getController() != null) {
            bl = true;
        }
        return bl;
    }

    public abstract boolean isReadOnly();

    public boolean isStandardMetadataFormatSupported() {
        return this.standardFormatSupported;
    }

    public abstract void reset();

    public void setController(IIOMetadataController controller) {
        this.controller = controller;
    }

    public abstract Node getAsTree(String var1);

    protected IIOMetadataNode getStandardChromaNode() {
        return null;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDataNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDocumentNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTextNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTileNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        return null;
    }

    private final void appendChild(IIOMetadataNode node2, IIOMetadataNode child) {
        if (child != null) {
            node2.appendChild(child);
        }
    }

    protected final IIOMetadataNode getStandardTree() {
        IIOMetadataNode node2 = new IIOMetadataNode();
        this.appendChild(node2, this.getStandardChromaNode());
        this.appendChild(node2, this.getStandardCompressionNode());
        this.appendChild(node2, this.getStandardDataNode());
        this.appendChild(node2, this.getStandardDimensionNode());
        this.appendChild(node2, this.getStandardDocumentNode());
        this.appendChild(node2, this.getStandardTextNode());
        this.appendChild(node2, this.getStandardTileNode());
        this.appendChild(node2, this.getStandardTransparencyNode());
        return node2;
    }

    public abstract void mergeTree(String var1, Node var2) throws IIOInvalidTreeException;

    public void setFromTree(String formatName, Node root) throws IIOInvalidTreeException {
        this.reset();
        this.mergeTree(formatName, root);
    }

    protected IIOMetadata() {
    }

    protected IIOMetadata(boolean standardMetadataFormatSupported, String nativeMetadataFormatName, String nativeMetadataFormatClassName, String[] extraMetadataFormatNames, String[] extraMetadataFormatClassNames) {
        if (extraMetadataFormatNames != null && extraMetadataFormatNames.length == 0) {
            throw new IllegalArgumentException("extraMetadataFormatNames may not be empty");
        }
        if (extraMetadataFormatNames == null && extraMetadataFormatClassNames != null || extraMetadataFormatNames != null && extraMetadataFormatClassNames == null || extraMetadataFormatNames != null && extraMetadataFormatClassNames != null && extraMetadataFormatNames.length != extraMetadataFormatClassNames.length) {
            throw new IllegalArgumentException("extraMetadataFormatNames and extraMetadataFormatClassNames have different lengths");
        }
        this.standardFormatSupported = standardMetadataFormatSupported;
        this.nativeMetadataFormatName = nativeMetadataFormatName;
        this.nativeMetadataFormatClassName = nativeMetadataFormatClassName;
        this.extraMetadataFormatNames = extraMetadataFormatNames;
        this.extraMetadataFormatClassNames = extraMetadataFormatClassNames;
    }
}

