/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.TimeZone;

final class VMTimeZone {
    static final TimeZone getDefaultTimeZoneId() {
        TimeZone zone = null;
        String tzid = System.getenv("TZ");
        if (tzid != null && !tzid.equals("")) {
            zone = TimeZone.getDefaultTimeZone(tzid);
        }
        if (zone == null && (tzid = VMTimeZone.readTimeZoneFile("/etc/timezone")) != null && !tzid.equals("")) {
            zone = TimeZone.getDefaultTimeZone(tzid);
        }
        if (zone == null && (tzid = VMTimeZone.readtzFile("/etc/localtime")) != null && !tzid.equals("")) {
            zone = TimeZone.getDefaultTimeZone(tzid);
        }
        if (zone == null && (tzid = VMTimeZone.getSystemTimeZoneId()) != null && !tzid.equals("")) {
            zone = TimeZone.getDefaultTimeZone(tzid);
        }
        return zone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String readTimeZoneFile(String file) {
        String string;
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        InputStreamReader isr = null;
        try {
            try {
                char c;
                FileInputStream fis = new FileInputStream(f);
                BufferedInputStream bis = new BufferedInputStream(fis);
                isr = new InputStreamReader(bis);
                StringBuffer sb = new StringBuffer();
                int i = isr.read();
                while (i != -1 && (Character.isLetter(c = (char)i) || Character.isDigit(c) || c == '/' || c == '-' || c == '_')) {
                    sb.append(c);
                    i = isr.read();
                }
                string = sb.toString();
                Object var4_11 = null;
            }
            catch (IOException ioe) {
                String string2 = null;
                Object var4_12 = null;
                try {
                    if (isr == null) return string2;
                    isr.close();
                    return string2;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var4_13 = null;
            try {}
            catch (IOException ioe2) {
                throw throwable;
            }
            if (isr == null) throw throwable;
            isr.close();
            throw throwable;
        }
        try {}
        catch (IOException ioe2) {
            // empty catch block
            return string;
        }
        if (isr == null) return string;
        isr.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static final String readtzFile(String file) {
        FilterInputStream dis;
        block24: {
            String id;
            String dst_zonename;
            File f = new File(file);
            if (!f.exists()) {
                return null;
            }
            dis = null;
            FileInputStream fis = new FileInputStream(f);
            BufferedInputStream bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            byte[] tzif = new byte[4];
            ((DataInputStream)dis).readFully(tzif);
            if (tzif[0] == 84 && tzif[1] == 90 && tzif[2] == 105 && tzif[3] == 102) {
                VMTimeZone.skipFully(dis, 28L);
            } else {
                VMTimeZone.skipFully(dis, 24L);
            }
            int timecnt = ((DataInputStream)dis).readInt();
            int typecnt = ((DataInputStream)dis).readInt();
            if (typecnt <= 0) break block24;
            int charcnt = ((DataInputStream)dis).readInt();
            VMTimeZone.skipFully(dis, timecnt * 5);
            int abbrind = -1;
            int dst_abbrind = -1;
            int gmt_offset = 0;
            while (typecnt-- > 0) {
                int offset = ((DataInputStream)dis).readInt();
                byte dst = ((DataInputStream)dis).readByte();
                if (dst == 0) {
                    abbrind = ((DataInputStream)dis).readByte();
                    gmt_offset = offset;
                    continue;
                }
                dst_abbrind = ((DataInputStream)dis).readByte();
            }
            if ((gmt_offset *= -1) % 3600 == 0) {
                gmt_offset /= 3600;
            }
            if (abbrind < 0) break block24;
            byte[] names = new byte[charcnt];
            ((DataInputStream)dis).readFully(names);
            int j = abbrind;
            while (j < charcnt && names[j] != 0) {
                ++j;
            }
            String zonename = new String(names, abbrind, j - abbrind, "ASCII");
            if (dst_abbrind >= 0) {
                j = dst_abbrind;
                while (j < charcnt && names[j] != 0) {
                    ++j;
                }
                dst_zonename = new String(names, dst_abbrind, j - dst_abbrind, "ASCII");
            } else {
                dst_zonename = "";
            }
            String offset_string = "".equals(dst_zonename) && (gmt_offset == 0 || zonename.startsWith("GMT+") || zonename.startsWith("GMT-")) ? "" : Integer.toString(gmt_offset);
            String string = id = zonename + offset_string + dst_zonename;
            Object var4_23 = null;
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            return string;
        }
        String string = null;
        Object var4_24 = null;
        try {
            if (dis != null) {
                dis.close();
            }
        }
        catch (IOException ioe2) {
            // empty catch block
        }
        return string;
        catch (IOException ioe) {
            String string2;
            try {
                string2 = null;
                Object var4_25 = null;
            }
            catch (Throwable throwable) {
                Object var4_26 = null;
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (IOException ioe2) {}
                throw throwable;
            }
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            return string2;
        }
    }

    private static final void skipFully(InputStream is, long l) throws IOException {
        while (l > 0L) {
            long k = is.skip(l);
            if (k <= 0L) {
                throw new EOFException();
            }
            l -= k;
        }
    }

    private static final native String getSystemTimeZoneId();

    VMTimeZone() {
    }

    static {
        System.loadLibrary("javautil");
    }
}

