/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import gnu.java.nio.SelectorProviderImpl;
import java.io.IOException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelector;

public abstract class SelectorProvider {
    private static SelectorProvider systemDefaultProvider;

    public abstract DatagramChannel openDatagramChannel() throws IOException;

    public abstract Pipe openPipe() throws IOException;

    public abstract AbstractSelector openSelector() throws IOException;

    public abstract ServerSocketChannel openServerSocketChannel() throws IOException;

    public abstract SocketChannel openSocketChannel() throws IOException;

    public static synchronized SelectorProvider provider() {
        if (systemDefaultProvider == null) {
            String propertyValue = System.getProperty("java.nio.channels.spi.SelectorProvider");
            if (propertyValue == null || propertyValue.equals("")) {
                systemDefaultProvider = new SelectorProviderImpl();
            } else {
                try {
                    systemDefaultProvider = (SelectorProvider)Class.forName(propertyValue).newInstance();
                }
                catch (Exception e) {
                    System.err.println("Could not instantiate class: " + propertyValue);
                    systemDefaultProvider = new SelectorProviderImpl();
                }
            }
        }
        return systemDefaultProvider;
    }

    protected SelectorProvider() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("selectorProvider"));
        }
    }
}

