/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.ByteOrder;
import java.nio.IntBufferImpl;

public abstract class IntBuffer
extends Buffer
implements Comparable {
    int array_offset = 0;
    int[] backing_buffer;

    public static IntBuffer allocate(int capacity) {
        return new IntBufferImpl(capacity);
    }

    public static final IntBuffer wrap(int[] array, int offset, int length) {
        return new IntBufferImpl(array, 0, array.length, offset + length, offset, -1, false);
    }

    public static final IntBuffer wrap(int[] array) {
        return IntBuffer.wrap(array, 0, array.length);
    }

    public IntBuffer get(int[] dst, int offset, int length) {
        IntBuffer.checkArraySize(dst.length, offset, length);
        this.checkForUnderflow(length);
        int i = offset;
        while (i < offset + length) {
            dst[i] = this.get();
            ++i;
        }
        return this;
    }

    public IntBuffer get(int[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public IntBuffer put(IntBuffer src) {
        if (src == this) {
            throw new IllegalArgumentException();
        }
        this.checkForOverflow(src.remaining());
        if (src.remaining() > 0) {
            int[] toPut = new int[src.remaining()];
            src.get(toPut);
            this.put(toPut);
        }
        return this;
    }

    public IntBuffer put(int[] src, int offset, int length) {
        IntBuffer.checkArraySize(src.length, offset, length);
        this.checkForOverflow(length);
        int i = offset;
        while (i < offset + length) {
            this.put(src[i]);
            ++i;
        }
        return this;
    }

    public final IntBuffer put(int[] src) {
        return this.put(src, 0, src.length);
    }

    public final boolean hasArray() {
        boolean bl = false;
        if (this.backing_buffer != null && !this.isReadOnly()) {
            bl = true;
        }
        return bl;
    }

    public final int[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        this.checkIfReadOnly();
        return this.array_offset;
    }

    public int hashCode() {
        int hashCode = this.get(this.position()) + 31;
        int multiplier = 1;
        int i = this.position() + 1;
        while (i < this.limit()) {
            hashCode += (this.get(i) + 30) * (multiplier *= 31);
            ++i;
        }
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IntBuffer) {
            boolean bl = false;
            if (this.compareTo(obj) == 0) {
                bl = true;
            }
            return bl;
        }
        return false;
    }

    public int compareTo(Object obj) {
        IntBuffer other = (IntBuffer)obj;
        int num = Math.min(this.remaining(), other.remaining());
        int pos_this = this.position();
        int pos_other = other.position();
        int count = 0;
        while (count < num) {
            int b;
            int a;
            if ((a = this.get(pos_this++)) != (b = other.get(pos_other++))) {
                if (a < b) {
                    return -1;
                }
                return 1;
            }
            ++count;
        }
        return this.remaining() - other.remaining();
    }

    public abstract ByteOrder order();

    public abstract int get();

    public abstract IntBuffer put(int var1);

    public abstract int get(int var1);

    public abstract IntBuffer put(int var1, int var2);

    public abstract IntBuffer compact();

    public abstract boolean isDirect();

    public abstract IntBuffer slice();

    public abstract IntBuffer duplicate();

    public abstract IntBuffer asReadOnlyBuffer();

    IntBuffer(int capacity, int limit, int position, int mark) {
        super(capacity, limit, position, mark);
    }
}

