/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Choice
extends Component
implements ItemSelectable,
Serializable,
Accessible {
    private static final long serialVersionUID = -4075310674757313071L;
    Vector pItems;
    private int selectedIndex;
    private ItemListener item_listeners;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int index) {
        return (String)this.pItems.elementAt(index);
    }

    public synchronized void add(String item) {
        if (item == null) {
            throw new NullPointerException("item must be non-null");
        }
        this.pItems.addElement(item);
        int i = this.pItems.size() - 1;
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.add(item, i);
        } else if (this.selectedIndex == -1) {
            this.select(0);
        }
    }

    public synchronized void addItem(String item) {
        this.add(item);
    }

    public synchronized void insert(String item, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index may not be less then 0");
        }
        if (index > this.getItemCount()) {
            index = this.getItemCount();
        }
        this.pItems.insertElementAt(item, index);
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.add(item, index);
        } else if (this.selectedIndex == -1 || this.selectedIndex >= index) {
            this.select(0);
        }
    }

    public synchronized void remove(String item) {
        int index = this.pItems.indexOf(item);
        if (index == -1) {
            throw new IllegalArgumentException("item \"" + item + "\" not found in Choice");
        }
        this.remove(index);
    }

    public synchronized void remove(int index) {
        if (index < 0 || index > this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + index);
        }
        this.pItems.removeElementAt(index);
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.remove(index);
        } else if (this.getItemCount() == 0) {
            this.selectedIndex = -1;
        } else if (index == this.selectedIndex) {
            this.select(0);
        }
        if (this.selectedIndex > index) {
            --this.selectedIndex;
        }
    }

    public synchronized void removeAll() {
        if (this.getItemCount() <= 0) {
            return;
        }
        this.pItems.removeAllElements();
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.removeAll();
        }
        this.selectedIndex = -1;
    }

    public synchronized String getSelectedItem() {
        return this.selectedIndex == -1 ? null : (String)this.pItems.elementAt(this.selectedIndex);
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex == -1) {
            return null;
        }
        Object[] objs = new Object[]{this.pItems.elementAt(this.selectedIndex)};
        return objs;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int index) {
        if (index < 0 || index > this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + index);
        }
        this.selectedIndex = index;
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.select(index);
        }
    }

    public synchronized void select(String item) {
        int index = this.pItems.indexOf(item);
        if (index >= 0) {
            this.select(index);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createChoice(this);
        }
        super.addNotify();
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        int index = this.pItems.indexOf((String)event.getItem());
        if (event.getStateChange() == 1) {
            this.selectedIndex = index;
        }
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(event);
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 701 && e.id >= 701 && (this.item_listeners != null || (this.eventMask & 0x200L) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected String paramString() {
        return "selectedIndex=" + this.selectedIndex + ',' + super.paramString();
    }

    public EventListener[] getListeners(Class listenerType) {
        Class clazz = class$java$awt$event$ItemListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ItemListener = Choice.class("[Ljava.awt.event.ItemListener;", false);
        }
        if (listenerType == clazz) {
            return AWTEventMulticaster.getListeners(this.item_listeners, listenerType);
        }
        return super.getListeners(listenerType);
    }

    public ItemListener[] getItemListeners() {
        Class clazz = class$java$awt$event$ItemListener;
        if (clazz == null) {
            clazz = class$java$awt$event$ItemListener = Choice.class("[Ljava.awt.event.ItemListener;", false);
        }
        return (ItemListener[])this.getListeners(clazz);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTChoice();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.pItems = new Vector();
        this.selectedIndex = -1;
    }

    public Choice() {
        this.this();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    protected class AccessibleAWTChoice
    extends Component.AccessibleAWTComponent
    implements AccessibleAction {
        private static final long serialVersionUID = 7175603582428509322L;

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public int getAccessibleActionCount() {
            return Choice.this.pItems.size();
        }

        public String getAccessibleActionDescription(int i) {
            return (String)Choice.this.pItems.get(i);
        }

        public boolean doAccessibleAction(int i) {
            if (i < 0 || i >= Choice.this.pItems.size()) {
                return false;
            }
            Choice.this.processItemEvent(new ItemEvent(Choice.this, 701, this, 1));
            return true;
        }
    }
}

