/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Test;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public final class NameTest
extends Test {
    final QName qName;
    final boolean anyLocalName;
    final boolean any;

    public final boolean matchesAny() {
        return this.any;
    }

    public final boolean matchesAnyLocalName() {
        return this.anyLocalName;
    }

    public final boolean matches(Node node2, int pos, int len) {
        String uri;
        switch (node2.getNodeType()) {
            case 2: {
                uri = node2.getNamespaceURI();
                if ("http://www.w3.org/2000/xmlns/".equals(uri) || "xmlns".equals(node2.getPrefix()) || "xmlns".equals(node2.getNodeName())) {
                    return false;
                }
            }
            case 1: {
                break;
            }
            default: {
                return false;
            }
        }
        if (this.any) {
            return true;
        }
        uri = this.qName.getNamespaceURI();
        String nodeUri = node2.getNamespaceURI();
        String nodeLocalName = node2.getLocalName();
        if (nodeLocalName != null && !this.equal(uri, nodeUri)) {
            return false;
        }
        if (this.anyLocalName) {
            return true;
        }
        String localName = this.qName.getLocalPart();
        if (nodeLocalName != null) {
            nodeLocalName = node2.getNodeName();
        }
        return localName.equals(nodeLocalName);
    }

    final boolean equal(String s1, String s2) {
        boolean bl = false;
        if ((s1 == null || s1.length() == 0) && (s2 == null || s2.length() == 0) || s1 != null && s1.equals(s2)) {
            bl = true;
        }
        return bl;
    }

    public final Test clone(Object context) {
        return new NameTest(this.qName, this.anyLocalName, this.any);
    }

    public final boolean references(QName var) {
        return false;
    }

    public final String toString() {
        if (this.any) {
            return "*";
        }
        return this.qName.toString();
    }

    public NameTest(QName qName, boolean anyLocalName, boolean any) {
        this.anyLocalName = anyLocalName;
        this.any = any;
        this.qName = qName;
    }
}

