/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.AttributeImpl;
import gnu.xml.stream.CharactersImpl;
import gnu.xml.stream.CommentImpl;
import gnu.xml.stream.DTDImpl;
import gnu.xml.stream.EndDocumentImpl;
import gnu.xml.stream.EndElementImpl;
import gnu.xml.stream.EndEntityImpl;
import gnu.xml.stream.EntityDeclarationImpl;
import gnu.xml.stream.LocationImpl;
import gnu.xml.stream.NamespaceImpl;
import gnu.xml.stream.NotationDeclarationImpl;
import gnu.xml.stream.ProcessingInstructionImpl;
import gnu.xml.stream.StartDocumentImpl;
import gnu.xml.stream.StartElementImpl;
import gnu.xml.stream.StartEntityImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLStreamReaderImpl
implements XMLStreamReader,
NamespaceContext {
    private LinkedList events;
    private XMLEvent currentEvent;
    private int eventType;
    private NamespaceSupport namespaces;
    protected String publicId;
    protected String systemId;
    protected XMLResolver resolver;
    protected XMLReporter reporter;
    protected boolean validating;
    protected boolean namespaceAware;
    protected boolean coalescing;
    protected boolean replacingEntityReferences;
    protected boolean externalEntities;
    protected boolean supportDTD;

    public Object getProperty(String name) throws IllegalArgumentException {
        throw new IllegalArgumentException(name);
    }

    public int next() throws XMLStreamException {
        if (this.events.isEmpty()) {
            throw new XMLStreamException("EOF");
        }
        Object event = this.events.removeFirst();
        if (event instanceof Exception) {
            Exception e = (Exception)event;
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
        this.currentEvent = (XMLEvent)event;
        this.eventType = this.currentEvent.getEventType();
        return this.eventType;
    }

    public void require(int type, String namespaceURI, String localName) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public String getElementText() throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public int nextTag() throws XMLStreamException {
        int ret;
        while ((ret = this.next()) != 1 && ret != 2) {
        }
        return ret;
    }

    public boolean hasNext() throws XMLStreamException {
        return this.events.isEmpty() ^ true;
    }

    public void close() throws XMLStreamException {
    }

    public String getNamespaceURI(String prefix) {
        return this.namespaces.getURI(prefix);
    }

    public String getPrefix(String namespaceURI) {
        return this.namespaces.getPrefix(namespaceURI);
    }

    public Iterator getPrefixes(String namespaceURI) {
        LinkedList acc = new LinkedList();
        Enumeration e = this.namespaces.getPrefixes(namespaceURI);
        while (e.hasMoreElements()) {
            acc.add(e.nextElement());
        }
        return acc.iterator();
    }

    public boolean isStartElement() {
        boolean bl = false;
        if (this.eventType == 1) {
            bl = true;
        }
        return bl;
    }

    public boolean isEndElement() {
        boolean bl = false;
        if (this.eventType == 2) {
            bl = true;
        }
        return bl;
    }

    public boolean isCharacters() {
        boolean bl = false;
        if (this.eventType == 4 || this.eventType == 12) {
            bl = true;
        }
        return bl;
    }

    public boolean isWhiteSpace() {
        boolean bl = false;
        if (this.eventType == 6) {
            bl = true;
        }
        return bl;
    }

    public String getAttributeValue(String namespaceURI, String localName) {
        StartElement se = (StartElement)this.currentEvent;
        Iterator i = se.getAttributes();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            QName name = attr.getName();
            if (namespaceURI != null && !namespaceURI.equals(name.getNamespaceURI()) || !localName.equals(name.getLocalPart())) continue;
            return attr.getValue();
        }
        return null;
    }

    public int getAttributeCount() {
        StartElement se = (StartElement)this.currentEvent;
        int count = 0;
        Iterator i = se.getAttributes();
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    public QName getAttributeQName(int index) {
        StartElement se = (StartElement)this.currentEvent;
        int count = 0;
        Iterator i = se.getAttributes();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            if (index == count) {
                return attr.getName();
            }
            ++count;
        }
        return null;
    }

    public String getAttributeNamespace(int index) {
        QName name = this.getAttributeQName(index);
        return name == null ? null : name.getNamespaceURI();
    }

    public String getAttributeName(int index) {
        QName name = this.getAttributeQName(index);
        return name == null ? null : name.getLocalPart();
    }

    public String getAttributePrefix(int index) {
        QName name = this.getAttributeQName(index);
        return name == null ? null : name.getPrefix();
    }

    public String getAttributeType(int index) {
        StartElement se = (StartElement)this.currentEvent;
        int count = 0;
        Iterator i = se.getAttributes();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            if (index == count) {
                QName type = attr.getDTDType();
                return type == null ? "CDATA" : type.toString();
            }
            ++count;
        }
        return null;
    }

    public String getAttributeValue(int index) {
        StartElement se = (StartElement)this.currentEvent;
        int count = 0;
        Iterator i = se.getAttributes();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            if (index == count) {
                return attr.getValue();
            }
            ++count;
        }
        return null;
    }

    public boolean isAttributeSpecified(int index) {
        StartElement se = (StartElement)this.currentEvent;
        int count = 0;
        Iterator i = se.getAttributes();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            if (index == count) {
                return attr.isSpecified();
            }
            ++count;
        }
        return false;
    }

    public int getNamespaceCount() {
        Iterator i = null;
        switch (this.eventType) {
            case 1: {
                i = ((StartElement)this.currentEvent).getNamespaces();
                break;
            }
            case 2: {
                i = ((EndElement)this.currentEvent).getNamespaces();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int count = 0;
        while (i.hasNext()) {
            i.next();
            ++count;
        }
        return count;
    }

    public String getNamespacePrefix(int index) {
        Iterator i = null;
        switch (this.eventType) {
            case 1: {
                i = ((StartElement)this.currentEvent).getNamespaces();
                break;
            }
            case 2: {
                i = ((EndElement)this.currentEvent).getNamespaces();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int count = 0;
        while (i.hasNext()) {
            Namespace ns = (Namespace)i.next();
            if (index == count) {
                return ns.getPrefix();
            }
            ++count;
        }
        return null;
    }

    public String getNamespaceURI(int index) {
        Iterator i = null;
        switch (this.eventType) {
            case 1: {
                i = ((StartElement)this.currentEvent).getNamespaces();
                break;
            }
            case 2: {
                i = ((EndElement)this.currentEvent).getNamespaces();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        int count = 0;
        while (i.hasNext()) {
            Namespace ns = (Namespace)i.next();
            if (index == count) {
                return ns.getNamespaceURI();
            }
            ++count;
        }
        return null;
    }

    public NamespaceContext getNamespaceContext() {
        return this;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getText() {
        switch (this.eventType) {
            case 4: 
            case 6: 
            case 12: {
                return ((Characters)this.currentEvent).getData();
            }
            case 5: {
                return ((Comment)this.currentEvent).getText();
            }
            case 9: {
                return ((EntityReference)this.currentEvent).getReplacementText();
            }
            case 11: {
                return ((DTD)this.currentEvent).getDocumentTypeDeclaration();
            }
        }
        return null;
    }

    public char[] getTextCharacters() {
        String text = this.getText();
        return text == null ? null : text.toCharArray();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        char[] source = this.getTextCharacters();
        int len = Math.min(source.length, length);
        System.arraycopy(source, sourceStart, target, targetStart, len);
        return len;
    }

    public int getTextStart() {
        return 0;
    }

    public int getTextLength() {
        String text = this.getText();
        int n = 0;
        if (text != null) {
            n = text.length();
        }
        return n;
    }

    public String getEncoding() {
        return null;
    }

    public boolean hasText() {
        boolean bl = false;
        if (this.eventType == 4 || this.eventType == 11 || this.eventType == 6 || this.eventType == 9 || this.eventType == 5 || this.eventType == 11) {
            bl = true;
        }
        return bl;
    }

    public Location getLocation() {
        return this.currentEvent.getLocation();
    }

    public QName getName() {
        switch (this.eventType) {
            case 1: {
                return ((StartElement)this.currentEvent).getName();
            }
            case 2: {
                return ((EndElement)this.currentEvent).getName();
            }
            case 10: {
                return ((Attribute)this.currentEvent).getName();
            }
        }
        return null;
    }

    public String getLocalName() {
        QName name = this.getName();
        return name == null ? null : name.getLocalPart();
    }

    public boolean hasName() {
        boolean bl = false;
        if (this.getName() != null) {
            bl = true;
        }
        return bl;
    }

    public String getNamespaceURI() {
        QName name = this.getName();
        return name == null ? null : name.getNamespaceURI();
    }

    public String getPrefix() {
        QName name = this.getName();
        return name == null ? null : name.getPrefix();
    }

    public String getVersion() {
        StartDocument sd = (StartDocument)this.currentEvent;
        return sd.getVersion();
    }

    public boolean isStandalone() {
        StartDocument sd = (StartDocument)this.currentEvent;
        return sd.isStandalone();
    }

    public boolean standaloneSet() {
        StartDocument sd = (StartDocument)this.currentEvent;
        return sd.standaloneSet();
    }

    public String getCharacterEncodingScheme() {
        StartDocument sd = (StartDocument)this.currentEvent;
        return sd.getCharacterEncodingScheme();
    }

    public String getPITarget() {
        ProcessingInstruction pi = (ProcessingInstruction)this.currentEvent;
        return pi.getTarget();
    }

    public String getPIData() {
        ProcessingInstruction pi = (ProcessingInstruction)this.currentEvent;
        return pi.getData();
    }

    protected XMLStreamReaderImpl(InputStream in, String publicId, String systemId, XMLResolver resolver, XMLReporter reporter, boolean validating, boolean namespaceAware, boolean coalescing, boolean replacingEntityReferences, boolean externalEntities, boolean supportDTD) throws XMLStreamException {
        this.publicId = publicId;
        this.systemId = systemId;
        this.resolver = resolver;
        this.reporter = reporter;
        this.validating = validating;
        this.namespaceAware = namespaceAware;
        this.coalescing = coalescing;
        this.replacingEntityReferences = replacingEntityReferences;
        this.externalEntities = externalEntities;
        this.supportDTD = supportDTD;
        this.namespaces = new NamespaceSupport();
        this.events = new LinkedList();
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setNamespaceAware(namespaceAware);
            f.setValidating(validating);
            SAXParser p = f.newSAXParser();
            XMLReader r = p.getXMLReader();
            CallbackHandler ch = new CallbackHandler(r);
            r.setFeature("http://xml.org/sax/features/external-general-entities", externalEntities);
            r.setFeature("http://xml.org/sax/features/namespaces", namespaceAware);
            r.setContentHandler(ch);
            r.setDTDHandler(ch);
            r.setEntityResolver(ch);
            r.setErrorHandler(ch);
            r.setProperty("http://xml.org/sax/properties/lexical-handler", ch);
            InputSource source = new InputSource(in);
            source.setSystemId(systemId);
            r.parse(source);
        }
        catch (SAXException e) {
            this.events.add(e);
        }
        catch (IOException e) {
            this.events.add(e);
        }
        catch (ParserConfigurationException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    protected XMLStreamReaderImpl(Reader reader, String publicId, String systemId, XMLResolver resolver, XMLReporter reporter, boolean validating, boolean namespaceAware, boolean coalescing, boolean replacingEntityReferences, boolean externalEntities, boolean supportDTD) throws XMLStreamException {
        this.publicId = publicId;
        this.systemId = systemId;
        this.resolver = resolver;
        this.reporter = reporter;
        this.validating = validating;
        this.namespaceAware = namespaceAware;
        this.coalescing = coalescing;
        this.replacingEntityReferences = replacingEntityReferences;
        this.externalEntities = externalEntities;
        this.supportDTD = supportDTD;
        this.namespaces = new NamespaceSupport();
        this.events = new LinkedList();
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setNamespaceAware(namespaceAware);
            f.setValidating(validating);
            SAXParser p = f.newSAXParser();
            XMLReader r = p.getXMLReader();
            CallbackHandler ch = new CallbackHandler(r);
            r.setFeature("http://xml.org/sax/features/external-general-entities", externalEntities);
            r.setFeature("http://xml.org/sax/features/namespaces", namespaceAware);
            r.setContentHandler(ch);
            r.setDTDHandler(ch);
            r.setEntityResolver(ch);
            r.setErrorHandler(ch);
            r.setProperty("http://xml.org/sax/properties/lexical-handler", ch);
            InputSource source = new InputSource(reader);
            source.setSystemId(systemId);
            r.parse(source);
        }
        catch (SAXException e) {
            this.events.add(e);
        }
        catch (IOException e) {
            this.events.add(e);
        }
        catch (ParserConfigurationException e) {
            XMLStreamException e2 = new XMLStreamException(e);
            e2.initCause(e);
            throw e2;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CallbackHandler
    implements ContentHandler,
    DTDHandler,
    LexicalHandler,
    DeclHandler,
    EntityResolver,
    ErrorHandler {
        XMLReader reader;
        Locator locator;
        Location location;
        private boolean inCDATA;
        private LinkedList namespaces;
        private LinkedList notations;
        private LinkedList entities;

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
            this.location = new LocationImpl(-1, locator.getColumnNumber(), locator.getLineNumber(), locator.getSystemId());
        }

        public void startDocument() throws SAXException {
            boolean standalone;
            String version = this.locator instanceof Locator2 ? ((Locator2)this.locator).getXMLVersion() : null;
            String encoding = this.locator instanceof Locator2 ? ((Locator2)this.locator).getEncoding() : null;
            boolean standaloneDeclared = standalone = this.reader.getFeature("http://xml.org/sax/features/is-standalone");
            boolean bl = false;
            if (encoding != null) {
                bl = true;
            }
            boolean encodingDeclared = bl;
            XMLStreamReaderImpl.this.events.add(new StartDocumentImpl(this.location, this.location.getLocationURI(), encoding, version, standalone, standaloneDeclared, encodingDeclared));
        }

        public void endDocument() throws SAXException {
            XMLStreamReaderImpl.this.events.add(new EndDocumentImpl(this.location));
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.namespaces.add(new NamespaceImpl(this.location, prefix, uri));
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            LinkedList ns = this.namespaces;
            this.namespaces = new LinkedList();
            int ci = qName.indexOf(58);
            String prefix = null;
            localName = qName;
            if (ci != -1) {
                prefix = qName.substring(0, ci);
                localName = qName.substring(ci + 1);
            }
            QName name = new QName(namespaceURI, localName, prefix);
            LinkedList attrs = new LinkedList();
            StartElementImpl se = new StartElementImpl(this.location, name, attrs, ns, null);
            XMLStreamReaderImpl.this.events.add(se);
            int len = atts.getLength();
            int i = 0;
            while (i < len) {
                String attURI = atts.getURI(i);
                String attQName = atts.getQName(i);
                String value = atts.getValue(i);
                QName type = QName.valueOf(atts.getType(i));
                boolean bl = false;
                if (atts instanceof Attributes2 && ((Attributes2)atts).isSpecified(i)) {
                    bl = true;
                }
                boolean specified = bl;
                ci = attQName.indexOf(58);
                String attPrefix = null;
                String attLocalName = attQName;
                if (ci != -1) {
                    attPrefix = attQName.substring(0, ci);
                    attLocalName = attQName.substring(ci + 1);
                }
                if (!"xmlns".equals(attPrefix) && !"xmlns".equals(attQName)) {
                    QName attrName = new QName(attURI, attLocalName, attPrefix);
                    AttributeImpl attr = new AttributeImpl(this.location, attrName, value, type, specified);
                    attrs.add(attr);
                }
                ++i;
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            int ci = qName.indexOf(58);
            String prefix = null;
            localName = qName;
            if (ci != -1) {
                prefix = qName.substring(0, ci);
                localName = qName.substring(ci + 1);
            }
            QName name = new QName(namespaceURI, localName, prefix);
            XMLStreamReaderImpl.this.events.add(new EndElementImpl(this.location, name, new LinkedList()));
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            boolean whitespace = this.isWhitespace(ch, start, length);
            XMLStreamReaderImpl.this.events.add(new CharactersImpl(this.location, new String(ch, start, length), whitespace, this.inCDATA, false));
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            boolean whitespace = this.isWhitespace(ch, start, length);
            XMLStreamReaderImpl.this.events.add(new CharactersImpl(this.location, new String(ch, start, length), whitespace, this.inCDATA, true));
        }

        boolean isWhitespace(char[] ch, int start, int len) {
            int end = start + len;
            int i = start;
            while (i < end) {
                char c = ch[i];
                if (c != ' ' && c != '\t' && c != '\n' && c != '\r') {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public void processingInstruction(String target, String data) throws SAXException {
            XMLStreamReaderImpl.this.events.add(new ProcessingInstructionImpl(this.location, target, data));
        }

        public void skippedEntity(String name) throws SAXException {
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.notations = new LinkedList();
            this.entities = new LinkedList();
            XMLStreamReaderImpl.this.events.add(new DTDImpl(this.location, null, null, this.notations, this.entities));
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String name) throws SAXException {
            XMLStreamReaderImpl.this.events.add(new StartEntityImpl(this.location, name));
        }

        public void endEntity(String name) throws SAXException {
            XMLStreamReaderImpl.this.events.add(new EndEntityImpl(this.location, name));
        }

        public void startCDATA() throws SAXException {
            this.inCDATA = true;
        }

        public void endCDATA() throws SAXException {
            this.inCDATA = false;
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            XMLStreamReaderImpl.this.events.add(new CommentImpl(this.location, new String(ch, start, length)));
        }

        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            NotationDeclarationImpl n = new NotationDeclarationImpl(this.location, name, publicId, systemId);
            this.notations.add(n);
        }

        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            EntityDeclarationImpl e = new EntityDeclarationImpl(this.location, publicId, systemId, name, notationName, null, null);
            this.entities.add(e);
        }

        public void elementDecl(String name, String model) throws SAXException {
        }

        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        }

        public void internalEntityDecl(String name, String value) throws SAXException {
            EntityDeclarationImpl e = new EntityDeclarationImpl(this.location, null, null, name, null, value, null);
            this.entities.add(e);
        }

        public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
            EntityDeclarationImpl e = new EntityDeclarationImpl(this.location, publicId, systemId, name, null, null, null);
            this.entities.add(e);
        }

        public void warning(SAXParseException e) throws SAXException {
            if (XMLStreamReaderImpl.this.reporter != null) {
                try {
                    XMLStreamReaderImpl.this.reporter.report(e.getMessage(), "warning", e, this.location);
                }
                catch (XMLStreamException e2) {
                    SAXException e3 = new SAXException(e2.getMessage());
                    e3.initCause(e2);
                    throw e3;
                }
            }
        }

        public void error(SAXParseException e) throws SAXException {
            if (XMLStreamReaderImpl.this.reporter != null) {
                try {
                    XMLStreamReaderImpl.this.reporter.report(e.getMessage(), "error", e, this.location);
                }
                catch (XMLStreamException e2) {
                    SAXException e3 = new SAXException(e2.getMessage());
                    e3.initCause(e2);
                    throw e3;
                }
            }
        }

        public void fatalError(SAXParseException e) throws SAXException {
            if (XMLStreamReaderImpl.this.reporter != null) {
                try {
                    XMLStreamReaderImpl.this.reporter.report(e.getMessage(), "fatal-error", e, this.location);
                }
                catch (XMLStreamException e2) {
                    SAXException e3 = new SAXException(e2.getMessage());
                    e3.initCause(e2);
                    throw e3;
                }
            }
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (XMLStreamReaderImpl.this.resolver != null) {
                try {
                    InputStream in = XMLStreamReaderImpl.this.resolver.resolve(systemId);
                    if (in != null) {
                        InputSource ret = new InputSource(in);
                        ret.setPublicId(publicId);
                        ret.setSystemId(systemId);
                        return ret;
                    }
                }
                catch (XMLStreamException e) {
                    SAXException e2 = new SAXException(e.getMessage());
                    e2.initCause(e);
                    throw e2;
                }
            }
            return null;
        }

        private final /* synthetic */ void this() {
            this.namespaces = new LinkedList();
        }

        CallbackHandler(XMLReader reader) {
            this.this();
            this.reader = reader;
        }
    }
}

