/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.FilteredEventReader;
import gnu.xml.stream.FilteredStreamReader;
import gnu.xml.stream.XMLEventAllocatorImpl;
import gnu.xml.stream.XMLEventReaderImpl;
import gnu.xml.stream.XMLStreamReaderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.stream.EventFilter;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XMLInputFactoryImpl
extends XMLInputFactory {
    protected XMLResolver resolver;
    protected XMLReporter reporter;
    protected XMLEventAllocator allocator;
    protected boolean validating;
    protected boolean namespaceAware;
    protected boolean coalescing;
    protected boolean replacingEntityReferences;
    protected boolean externalEntities;
    protected boolean supportDTD;

    public XMLStreamReader createXMLStreamReader(Reader reader) throws XMLStreamException {
        return new XMLStreamReaderImpl(reader, null, null, this.resolver, this.reporter, this.validating, this.namespaceAware, this.coalescing, this.replacingEntityReferences, this.externalEntities, this.supportDTD);
    }

    public XMLStreamReader createXMLStreamReader(Source source) throws XMLStreamException {
        String systemId = source.getSystemId();
        InputStream in = this.getInputStream(source);
        return new XMLStreamReaderImpl(in, null, systemId, this.resolver, this.reporter, this.validating, this.namespaceAware, this.coalescing, this.replacingEntityReferences, this.externalEntities, this.supportDTD);
    }

    public XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return new XMLStreamReaderImpl(in, null, null, this.resolver, this.reporter, this.validating, this.namespaceAware, this.coalescing, this.replacingEntityReferences, this.externalEntities, this.supportDTD);
    }

    public XMLStreamReader createXMLStreamReader(InputStream in, String encoding) throws XMLStreamException {
        return this.createXMLStreamReader(in);
    }

    public XMLEventReader createXMLEventReader(Reader reader) throws XMLStreamException {
        XMLStreamReader sr = this.createXMLStreamReader(reader);
        return new XMLEventReaderImpl(sr, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(XMLStreamReader reader) throws XMLStreamException {
        return new XMLEventReaderImpl(reader, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(Source source) throws XMLStreamException {
        XMLStreamReader sr = this.createXMLStreamReader(source);
        return new XMLEventReaderImpl(sr, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(InputStream in) throws XMLStreamException {
        XMLStreamReader sr = this.createXMLStreamReader(in);
        return new XMLEventReaderImpl(sr, this.allocator, null);
    }

    public XMLEventReader createXMLEventReader(InputStream in, String encoding) throws XMLStreamException {
        XMLStreamReader sr = this.createXMLStreamReader(in, encoding);
        return new XMLEventReaderImpl(sr, this.allocator, null);
    }

    public XMLStreamReader createFilteredReader(XMLStreamReader reader, StreamFilter filter) throws XMLStreamException {
        return new FilteredStreamReader(reader, filter);
    }

    public XMLEventReader createFilteredReader(XMLEventReader reader, EventFilter filter) throws XMLStreamException {
        return new FilteredEventReader(reader, filter);
    }

    public XMLResolver getXMLResolver() {
        return this.resolver;
    }

    public void setXMLResolver(XMLResolver resolver) {
        this.resolver = resolver;
    }

    public XMLReporter getXMLReporter() {
        return this.reporter;
    }

    public void setXMLReporter(XMLReporter reporter) {
        this.reporter = reporter;
    }

    public void setProperty(String name, Object value) throws IllegalArgumentException {
        if (name.equals("javax.xml.stream.isNamespaceAware")) {
            this.namespaceAware = (Boolean)value;
        } else if (name.equals("javax.xml.stream.isValidating")) {
            this.validating = (Boolean)value;
        } else if (name.equals("javax.xml.stream.isCoalescing")) {
            this.coalescing = (Boolean)value;
        } else if (name.equals("javax.xml.stream.isReplacingEntityReferences")) {
            this.replacingEntityReferences = (Boolean)value;
        } else if (name.equals("javax.xml.stream.isSupportingExternalEntities")) {
            this.externalEntities = (Boolean)value;
        } else if (name.equals("javax.xml.stream.supportDTD")) {
            this.supportDTD = (Boolean)value;
        } else if (name.equals("javax.xml.stream.reporter")) {
            this.reporter = (XMLReporter)value;
        } else if (name.equals("javax.xml.stream.resolver")) {
            this.resolver = (XMLResolver)value;
        } else if (name.equals("javax.xml.stream.allocator")) {
            this.allocator = (XMLEventAllocator)value;
        } else {
            throw new IllegalArgumentException(name);
        }
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        if (name.equals("javax.xml.stream.isNamespaceAware")) {
            return this.namespaceAware ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.isValidating")) {
            return this.validating ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.isCoalescing")) {
            return this.coalescing ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.isReplacingEntityReferences")) {
            return this.replacingEntityReferences ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.isSupportingExternalEntities")) {
            return this.externalEntities ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.supportDTD")) {
            return this.supportDTD ? Boolean.TRUE : Boolean.FALSE;
        }
        if (name.equals("javax.xml.stream.reporter")) {
            return this.reporter;
        }
        if (name.equals("javax.xml.stream.resolver")) {
            return this.resolver;
        }
        if (name.equals("javax.xml.stream.allocator")) {
            return this.allocator;
        }
        throw new IllegalArgumentException(name);
    }

    public boolean isPropertySupported(String name) {
        boolean bl = false;
        if (name.equals("javax.xml.stream.isNamespaceAware") || name.equals("javax.xml.stream.isValidating") || name.equals("javax.xml.stream.isCoalescing") || name.equals("javax.xml.stream.isReplacingEntityReferences") || name.equals("javax.xml.stream.isSupportingExternalEntities") || name.equals("javax.xml.stream.supportDTD") || name.equals("javax.xml.stream.reporter") || name.equals("javax.xml.stream.resolver") || name.equals("javax.xml.stream.allocator")) {
            bl = true;
        }
        return bl;
    }

    public void setEventAllocator(XMLEventAllocator allocator) {
        this.allocator = allocator;
    }

    public XMLEventAllocator getEventAllocator() {
        return this.allocator;
    }

    public void setCoalescing(boolean coalescing) {
        this.coalescing = coalescing;
    }

    public boolean isCoalescing() {
        return this.coalescing;
    }

    protected InputStream getInputStream(Source source) throws XMLStreamException {
        InputStream in = null;
        if (source instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)source;
            in = streamSource.getInputStream();
        }
        if (in == null) {
            String systemId = source.getSystemId();
            try {
                URL url = new URL(systemId);
                try {
                    in = url.openStream();
                }
                catch (IOException e2) {
                    XMLStreamException e3 = new XMLStreamException(e2);
                    e3.initCause(e2);
                    throw e3;
                }
            }
            catch (MalformedURLException e) {
                if (File.separatorChar != '/') {
                    systemId = systemId.replace('/', File.separatorChar);
                }
                try {
                    in = new FileInputStream(systemId);
                }
                catch (FileNotFoundException e2) {
                    XMLStreamException e3 = new XMLStreamException(e2);
                    e3.initCause(e2);
                    throw e3;
                }
            }
        }
        return in;
    }

    private final /* synthetic */ void this() {
        this.namespaceAware = true;
        this.replacingEntityReferences = true;
        this.externalEntities = true;
        this.supportDTD = true;
    }

    public XMLInputFactoryImpl() {
        this.this();
        this.allocator = new XMLEventAllocatorImpl();
    }
}

