/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.rmi.CORBA;

import gnu.CORBA.CDR.BufferedCdrOutput;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.ObjectCreator;
import gnu.CORBA.Unexpected;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.StubDelegate;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.Servant;

public class StubDelegateImpl
implements StubDelegate {
    public void connect(Stub self, ORB orb) throws RemoteException {
        StubDelegateImpl.connect(self, orb, null);
    }

    public static void connect(Stub self, ORB orb, POA poa) throws RemoteException {
        Delegate delegate;
        Object oorb = null;
        try {
            Delegate d = self._get_delegate();
            if (d != null) {
                oorb = d.orb(self);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (oorb != null) {
            if (!oorb.equals(orb)) {
                throw new RemoteException("Stub " + self + " is connected to another ORB, " + orb);
            }
            return;
        }
        Tie t = null;
        if (self instanceof Remote) {
            t = Util.getTie((Remote)((Object)self));
        }
        if (t == null) {
            t = StubDelegateImpl.getTieFromStub(self);
        }
        if (t instanceof Servant) {
            try {
                if (poa == null && (poa = POAHelper.narrow(orb.resolve_initial_references("RootPOA"))).the_POAManager().get_state().value() == 0) {
                    poa.the_POAManager().activate();
                }
                ObjectImpl obj = (ObjectImpl)poa.servant_to_reference((Servant)((Object)t));
                delegate = obj._get_delegate();
            }
            catch (Exception ex) {
                throw new Unexpected(ex);
            }
        } else if (t instanceof ObjectImpl) {
            ObjectImpl o = (ObjectImpl)((Object)t);
            orb.connect(o);
            delegate = o._get_delegate();
        } else {
            throw new BAD_PARAM("The Tie must be either Servant or ObjectImpl");
        }
        self._set_delegate(delegate);
    }

    public static Tie getTieFromStub(Object self) {
        Tie t;
        String sn = self.getClass().getName();
        if (!sn.endsWith("_Stub")) {
            throw new BAD_PARAM("The stub name, " + sn + ", does not match _*_Stub pattern");
        }
        String tn = sn.substring(0, sn.length() - "_Stub".length()) + "Impl_Tie";
        Class tieClass = null;
        try {
            tieClass = ObjectCreator.forName(tn);
            t = (Tie)tieClass.newInstance();
            if (self instanceof Remote) {
                Util.registerTarget(t, (Remote)self);
            }
        }
        catch (Exception e) {
            BAD_PARAM bad = new BAD_PARAM("Unable to instantiate '" + tn + '\'');
            bad.initCause(e);
            throw bad;
        }
        return t;
    }

    public boolean equals(Stub self, Object obj) {
        if (obj instanceof ObjectImpl) {
            ObjectImpl other = (ObjectImpl)obj;
            Delegate d1 = other._get_delegate();
            Delegate d2 = self._get_delegate();
            if (d1 == null || d2 == null) {
                boolean bl = false;
                if (d1 == d2) {
                    bl = true;
                }
                return bl;
            }
            return d1.equals(d2);
        }
        return false;
    }

    public int hashCode(Stub self) {
        Delegate d = self._get_delegate();
        int n = 0;
        if (d != null) {
            n = d.hashCode();
        }
        return n;
    }

    public String toString(Stub self) {
        try {
            return self._orb().object_to_string(self);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void readObject(Stub self, ObjectInputStream input) throws IOException, ClassNotFoundException {
        this.readObject(self, input, null);
    }

    public void readObject(Stub self, ObjectInputStream input, ORB orb) throws IOException, ClassNotFoundException {
        byte[] b = (byte[])input.readObject();
        BufferredCdrInput in = new BufferredCdrInput(b);
        if (orb != null) {
            in.setOrb(orb);
        }
        ObjectImpl r = (ObjectImpl)in.read_Object();
        self._set_delegate(r._get_delegate());
    }

    public void writeObject(Stub self, ObjectOutputStream output) throws IOException {
        this.writeObject(self, output, null);
    }

    public void writeObject(Stub self, ObjectOutputStream output, ORB orb) throws IOException {
        BufferedCdrOutput out = new BufferedCdrOutput();
        out.setOrb(orb == null ? self._orb() : orb);
        out.write_Object(self);
        output.writeObject(out.buffer.toByteArray());
    }
}

