/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.bmp;

import gnu.javax.imageio.bmp.BMPDecoder;
import gnu.javax.imageio.bmp.BMPException;
import gnu.javax.imageio.bmp.BMPFileHeader;
import gnu.javax.imageio.bmp.BMPInfoHeader;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;

public class DecodeRLE4
extends BMPDecoder {
    private static final byte ESCAPE = 0;
    private static final byte EOL = 0;
    private static final byte EOB = 1;
    private static final byte DELTA = 2;

    public BufferedImage decode(ImageInputStream in) throws IOException, BMPException {
        IndexColorModel palette = this.readPalette(in);
        this.skipToImage(in);
        Dimension d = this.infoHeader.getSize();
        int h = (int)d.getHeight();
        int w = (int)d.getWidth();
        byte[] data = this.uncompress(w, h, in);
        MultiPixelPackedSampleModel sm = new MultiPixelPackedSampleModel(0, w, h, 4);
        DataBufferByte db = new DataBufferByte(data, w * h, 0);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        return new BufferedImage(palette, raster, false, null);
    }

    private final byte[] uncompress(int w, int h, ImageInputStream in) throws BMPException, IOException {
        byte[] cmd = new byte[2];
        byte[] data = new byte[w * h >> 1];
        boolean offIn = false;
        int x = 0;
        int y = 0;
        w += w & 1;
        w >>= 1;
        try {
            while ((x >> 1) + y * w < w * h) {
                int i;
                if (in.read(cmd) != 2) {
                    throw new IOException("Error reading compressed data.");
                }
                if (cmd[0] == 0) {
                    switch (cmd[1]) {
                        case 1: {
                            return data;
                        }
                        case 0: {
                            x = 0;
                            ++y;
                            break;
                        }
                        case 2: {
                            if (in.read(cmd) != 2) {
                                throw new IOException("Error reading compressed data.");
                            }
                            int dx = cmd[0] & 0xFF;
                            int dy = cmd[1] & 0xFF;
                            x += dx;
                            y += dy;
                            break;
                        }
                        default: {
                            int length;
                            int bytesize = length = cmd[1] & 0xFF;
                            bytesize += bytesize & 1;
                            bytesize >>= 1;
                            bytesize += bytesize & 1;
                            byte[] run = new byte[bytesize];
                            if (in.read(run) != bytesize) {
                                throw new IOException("Error reading compressed data.");
                            }
                            if ((x & 1) == 0) {
                                length += length & 1;
                                System.arraycopy(run, 0, data, (x >> 1) + w * (h - y - 1), length >>= 1);
                            } else {
                                int i2 = 0;
                                while (i2 < length) {
                                    if ((i2 & 1) == 0) {
                                        int n = (x + i2 >> 1) + w * (h - y - 1);
                                        data[n] = (byte)(data[n] | (run[i2 >> 1] & 0xF0) >> 4);
                                    } else {
                                        int n = (x + i2 >> 1) + w * (h - y - 1);
                                        data[n] = (byte)(data[n] | (run[i2 >> 1] & 0xF) << 4);
                                    }
                                    ++i2;
                                }
                            }
                            x += cmd[1] & 0xFF;
                            break;
                        }
                    }
                    continue;
                }
                int length = cmd[0] & 0xFF;
                if ((x & 1) == 0) {
                    length += length & 1;
                    length >>= 1;
                    i = 0;
                    while (i < length) {
                        data[(h - y - 1) * w + i + (x >> 1)] = cmd[1];
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < length) {
                        if ((i & 1) == 0) {
                            int n = (x + i >> 1) + w * (h - y - 1);
                            data[n] = (byte)(data[n] | (cmd[1] & 0xF0) >> 4);
                        } else {
                            int n = (x + i >> 1) + w * (h - y - 1);
                            data[n] = (byte)(data[n] | (cmd[1] & 0xF) << 4);
                        }
                        ++i;
                    }
                }
                x += cmd[0] & 0xFF;
            }
            return data;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BMPException("Invalid RLE data.");
        }
    }

    public DecodeRLE4(BMPFileHeader fh, BMPInfoHeader ih) {
        super(fh, ih);
    }
}

