/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.UnicastConnection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StreamCorruptedException;
import java.rmi.MarshalException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteCall;
import java.rmi.server.UID;
import java.util.Vector;

public class UnicastRemoteCall
implements RemoteCall,
ProtocolConstants {
    private UnicastConnection conn;
    private Object result;
    private Object object;
    private int opnum;
    private long hash;
    Vector vec;
    int ptr;
    private ObjID objid;
    private ObjectOutput oout;
    private ObjectInput oin;

    UnicastConnection getConnection() {
        return this.conn;
    }

    public ObjectOutput getOutputStream() throws IOException {
        if (this.vec == null) {
            this.vec = new Vector();
        }
        return new DummyObjectOutputStream();
    }

    public void releaseOutputStream() throws IOException {
        if (this.vec != null) {
            this.oout = this.conn.getObjectOutputStream();
            int i = 0;
            while (i < this.vec.size()) {
                boolean primitive = (Boolean)this.vec.elementAt(i);
                Object data = this.vec.elementAt(i + 1);
                if (!primitive) {
                    this.oout.writeObject(data);
                } else if (data instanceof Boolean) {
                    this.oout.writeBoolean((Boolean)data);
                } else if (data instanceof Character) {
                    this.oout.writeChar(((Character)data).charValue());
                } else if (data instanceof Byte) {
                    this.oout.writeByte(((Byte)data).byteValue());
                } else if (data instanceof Short) {
                    this.oout.writeShort(((Short)data).shortValue());
                } else if (data instanceof Integer) {
                    this.oout.writeInt((Integer)data);
                } else if (data instanceof Long) {
                    this.oout.writeLong((Long)data);
                }
                i += 2;
            }
            this.vec = null;
        }
        if (this.oout != null) {
            this.oout.flush();
        }
    }

    public ObjectInput startInputStream() throws IOException {
        if (this.conn != null) {
            this.oin = this.conn.startObjectInputStream();
            return this.oin;
        }
        return this.getInputStream();
    }

    public ObjectInput getInputStream() throws IOException {
        if (this.conn != null) {
            if (this.oin == null) {
                this.oin = this.conn.getObjectInputStream();
                return this.oin;
            }
            return this.oin;
        }
        this.ptr = 0;
        return new DummyObjectInputStream();
    }

    public void releaseInputStream() throws IOException {
    }

    public ObjectOutput getResultStream(boolean success) throws IOException, StreamCorruptedException {
        this.vec = new Vector();
        return new DummyObjectOutputStream();
    }

    public void executeCall() throws Exception {
        byte returncode;
        ObjectInput oin;
        try {
            DataOutputStream dout = this.conn.getDataOutputStream();
            dout.write(80);
            this.oout = this.conn.startObjectOutputStream();
            this.objid.write(this.oout);
            this.oout.writeInt(this.opnum);
            this.oout.writeLong(this.hash);
        }
        catch (IOException ex) {
            throw new MarshalException("Try to write header but failed.", ex);
        }
        try {
            this.releaseOutputStream();
            DataInputStream din = this.conn.getDataInputStream();
            if (din.readByte() != 81) {
                throw new RemoteException("Call not acked");
            }
            oin = this.startInputStream();
            returncode = oin.readByte();
            UID.read(oin);
        }
        catch (IOException ex) {
            throw new UnmarshalException("Try to read header but failed:", ex);
        }
        switch (returncode) {
            case 1: {
                return;
            }
            case 2: {
                Object returnobj;
                try {
                    returnobj = oin.readObject();
                }
                catch (Exception ex2) {
                    throw new UnmarshalException("Try to read exception object but failed", ex2);
                }
                if (!(returnobj instanceof Exception)) {
                    throw new UnmarshalException("Should be Exception type here: " + returnobj);
                }
                throw (Exception)returnobj;
            }
        }
        throw new UnmarshalException("Invalid return code");
    }

    public void done() throws IOException {
    }

    boolean isReturnValue() {
        boolean bl = false;
        if (this.vec.size() > 0) {
            bl = true;
        }
        return bl;
    }

    Object returnValue() {
        return this.vec.elementAt(1);
    }

    Object[] getArguments() {
        return this.vec.toArray();
    }

    Object getObject() {
        return this.object;
    }

    int getOpnum() {
        return this.opnum;
    }

    long getHash() {
        return this.hash;
    }

    void setReturnValue(Object obj) {
        this.vec.removeAllElements();
        this.vec.addElement(obj);
    }

    UnicastRemoteCall(UnicastConnection conn) {
        this.conn = conn;
    }

    UnicastRemoteCall(UnicastConnection conn, ObjID objid, int opnum, long hash) throws RemoteException {
        this.conn = conn;
        this.opnum = opnum;
        this.hash = hash;
        this.objid = objid;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DummyObjectOutputStream
    implements ObjectOutput {
        public void writeBoolean(boolean v) throws IOException {
            UnicastRemoteCall.this.vec.addElement(Boolean.TRUE);
            UnicastRemoteCall.this.vec.addElement(v);
        }

        public void writeByte(int v) throws IOException {
            UnicastRemoteCall.this.vec.addElement(Boolean.TRUE);
            UnicastRemoteCall.this.vec.addElement(new Byte((byte)v));
        }

        public void writeChar(int v) throws IOException {
            UnicastRemoteCall.this.vec.addElement(Boolean.TRUE);
            UnicastRemoteCall.this.vec.addElement(new Character((char)v));
        }

        public void writeDouble(double v) throws IOException {
            UnicastRemoteCall.this.vec.addElement(Boolean.TRUE);
            UnicastRemoteCall.this.vec.addElement(new Double(v));
        }

        public void writeFloat(float v) throws IOException {
            UnicastRemoteCall.this.vec.addElement(Boolean.TRUE);
            UnicastRemoteCall.this.vec.addElement(new Float(v));
        }

        public void writeInt(int v) throws IOException {
            UnicastRemoteCall.this.vec.addElement(Boolean.TRUE);
            UnicastRemoteCall.this.vec.addElement(new Integer(v));
        }

        public void writeLong(long v) throws IOException {
            UnicastRemoteCall.this.vec.addElement(Boolean.TRUE);
            UnicastRemoteCall.this.vec.addElement(new Long(v));
        }

        public void writeShort(int v) throws IOException {
            UnicastRemoteCall.this.vec.addElement(Boolean.TRUE);
            UnicastRemoteCall.this.vec.addElement(new Short((short)v));
        }

        public void writeObject(Object obj) throws IOException {
            UnicastRemoteCall.this.vec.addElement(Boolean.FALSE);
            UnicastRemoteCall.this.vec.addElement(obj);
        }

        public void write(byte[] b) throws IOException {
            throw new IOException("not required");
        }

        public void write(byte[] b, int off, int len) throws IOException {
            throw new IOException("not required");
        }

        public void write(int b) throws IOException {
            throw new IOException("not required");
        }

        public void writeBytes(String s) throws IOException {
            throw new IOException("not required");
        }

        public void writeChars(String s) throws IOException {
            throw new IOException("not required");
        }

        public void writeUTF(String str) throws IOException {
            throw new IOException("not required");
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }

        DummyObjectOutputStream() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class DummyObjectInputStream
    implements ObjectInput {
        public boolean readBoolean() throws IOException {
            Object obj = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Boolean)obj;
        }

        public byte readByte() throws IOException {
            Object obj = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Byte)obj;
        }

        public char readChar() throws IOException {
            Object obj = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return ((Character)obj).charValue();
        }

        public double readDouble() throws IOException {
            Object obj = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Double)obj;
        }

        public float readFloat() throws IOException {
            Object obj = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return ((Float)obj).floatValue();
        }

        public int readInt() throws IOException {
            Object obj = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Integer)obj;
        }

        public long readLong() throws IOException {
            Object obj = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Long)obj;
        }

        public short readShort() throws IOException {
            Object obj = UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
            return (Short)obj;
        }

        public Object readObject() throws IOException {
            return UnicastRemoteCall.this.vec.elementAt(UnicastRemoteCall.this.ptr++);
        }

        public int read(byte[] b) throws IOException {
            throw new IOException("not required");
        }

        public int read(byte[] b, int off, int len) throws IOException {
            throw new IOException("not required");
        }

        public int read() throws IOException {
            throw new IOException("not required");
        }

        public long skip(long n) throws IOException {
            throw new IOException("not required");
        }

        public int available() throws IOException {
            throw new IOException("not required");
        }

        public void readFully(byte[] b) throws IOException {
            throw new IOException("not required");
        }

        public void readFully(byte[] b, int off, int len) throws IOException {
            throw new IOException("not required");
        }

        public String readLine() throws IOException {
            throw new IOException("not required");
        }

        public String readUTF() throws IOException {
            throw new IOException("not required");
        }

        public int readUnsignedByte() throws IOException {
            throw new IOException("not required");
        }

        public int readUnsignedShort() throws IOException {
            throw new IOException("not required");
        }

        public int skipBytes(int n) throws IOException {
            throw new IOException("not required");
        }

        public void close() throws IOException {
        }

        DummyObjectInputStream() {
        }
    }
}

