/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset.iconv;

import gnu.classpath.Pointer;
import gnu.java.nio.charset.iconv.IconvMetaData;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

final class IconvEncoder
extends CharsetEncoder {
    private Pointer data;
    private int inremaining;
    private int outremaining;

    private final native void openIconv(String var1);

    private final native int encode(char[] var1, byte[] var2, int var3, int var4, int var5, int var6);

    private final native void closeIconv();

    protected final CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
        int ret;
        char[] inArr;
        int inPos = in.position();
        int outPos = out.position();
        int remIn = in.remaining();
        int remOut = out.remaining();
        if (in.hasArray()) {
            inArr = in.array();
        } else {
            inArr = new char[remIn];
            in.get(inArr);
        }
        if (out.hasArray()) {
            ret = this.encode(inArr, out.array(), inPos, remIn, outPos, remOut);
            out.position(outPos + (remOut - this.outremaining));
        } else {
            byte[] outArr = new byte[remOut];
            ret = this.encode(inArr, outArr, inPos, remIn, outPos, remOut);
            out.put(outArr, 0, remOut - this.outremaining);
        }
        in.position(inPos + (remIn - this.inremaining));
        if (ret == 1) {
            return CoderResult.malformedForLength(1);
        }
        if (in.remaining() == 0) {
            return CoderResult.UNDERFLOW;
        }
        return CoderResult.OVERFLOW;
    }

    protected final void finalize() {
        this.closeIconv();
    }

    IconvEncoder(Charset cs, IconvMetaData info) {
        super(cs, info.averageBytesPerChar(), info.maxBytesPerChar());
        this.openIconv(info.iconvName());
    }
}

