/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QMatrix;
import gnu.java.awt.peer.qt.QtGraphics;
import gnu.java.awt.peer.qt.QtImage;
import gnu.java.awt.peer.qt.QtImageGraphics;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.VolatileImage;
import java.util.Hashtable;
import java.util.WeakHashMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class QtVolatileImage
extends VolatileImage {
    static ColorModel nativeModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    int width;
    int height;
    Hashtable props;
    long nativeObject;
    WeakHashMap painters;
    boolean killFlag;

    public native void clear();

    private final native int[] getPixels();

    private final native void createImage();

    private final native void freeImage();

    public native void blit(QtImage var1);

    public native void blit(QtImage var1, int var2, int var3, int var4, int var5);

    private final native void createScaledImage(QtVolatileImage var1, int var2);

    private final native void drawPixels(QtGraphics var1, int var2, int var3, int var4, int var5, int var6, boolean var7);

    private final native void drawPixelsScaled(QtGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private final native void drawPixelsTransformed(QtGraphics var1, QMatrix var2);

    native void drawPixelsScaledFlipped(QtGraphics var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14, boolean var15);

    public void finalize() {
        this.dispose();
    }

    public void dispose() {
        if (this.painters == null || this.painters.isEmpty()) {
            this.freeImage();
        } else {
            this.killFlag = true;
        }
    }

    public int getWidth(ImageObserver observer) {
        return this.getWidth();
    }

    public int getHeight(ImageObserver observer) {
        return this.getHeight();
    }

    public Object getProperty(String name, ImageObserver observer) {
        Object value = this.props.get(name);
        return value == null ? UndefinedProperty : value;
    }

    public ImageProducer getSource() {
        return new MemoryImageSource(this.width, this.height, nativeModel, this.getPixels(), 0, this.width);
    }

    void putPainter(QtImageGraphics g) {
        if (this.painters == null) {
            this.painters = new WeakHashMap();
        }
        this.painters.put(g, "dummy");
    }

    void removePainter(QtImageGraphics g) {
        this.painters.remove(g);
        if (this.killFlag && this.painters.isEmpty()) {
            this.freeImage();
        }
    }

    public Graphics getGraphics() {
        QtImageGraphics g = new QtImageGraphics(this);
        this.putPainter(g);
        return g;
    }

    public Image getScaledInstance(int width, int height, int hints) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height of scaled bitmapmust be >= 0");
        }
        return new QtVolatileImage(this, width, height, hints);
    }

    public void flush() {
    }

    public int checkImage(ImageObserver observer) {
        return 35;
    }

    public boolean drawImage(QtGraphics g, QMatrix matrix, ImageObserver observer) {
        this.drawPixelsTransformed(g, matrix);
        return true;
    }

    public boolean drawImage(QtGraphics g, int x, int y, Color bgcolor, ImageObserver observer) {
        if (bgcolor != null) {
            this.drawPixels(g, bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue(), x, y, true);
        } else {
            this.drawPixels(g, 0, 0, 0, x, y, false);
        }
        return true;
    }

    public boolean drawImage(QtGraphics g, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (bgcolor != null) {
            this.drawPixelsScaled(g, bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue(), x, y, width, height, true);
        } else {
            this.drawPixelsScaled(g, 0, 0, 0, x, y, width, height, false);
        }
        return true;
    }

    public boolean drawImage(QtGraphics g, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        int dstY;
        boolean bl = false;
        if (dx1 > dx2) {
            bl = true;
        }
        boolean bl2 = false;
        if (sx1 > sx2) {
            bl2 = true;
        }
        boolean flipX = bl ^ bl2;
        boolean bl3 = false;
        if (dy1 > dy2) {
            bl3 = true;
        }
        boolean bl4 = false;
        if (sy1 > sy2) {
            bl4 = true;
        }
        boolean flipY = bl3 ^ bl4;
        int dstWidth = Math.abs(dx2 - dx1);
        int dstHeight = Math.abs(dy2 - dy1);
        int srcWidth = Math.abs(sx2 - sx1);
        int srcHeight = Math.abs(sy2 - sy1);
        int srcX = sx1 < sx2 ? sx1 : sx2;
        int srcY = sy1 < sy2 ? sy1 : sy2;
        int dstX = dx1 < dx2 ? dx1 : dx2;
        int n = dstY = dy1 < dy2 ? dy1 : dy2;
        if (srcWidth > this.width) {
            dstWidth = (int)((double)dstWidth * ((double)this.width / (double)srcWidth));
            srcWidth = this.width - srcX;
        }
        if (srcHeight > this.height) {
            dstHeight = (int)((double)dstHeight * ((double)this.height / (double)srcHeight));
            srcHeight = this.height - srcY;
        }
        if (srcWidth + srcX > this.width) {
            dstWidth = (int)((double)dstWidth * (double)(this.width - srcX) / (double)srcWidth);
            srcWidth = this.width - srcX;
        }
        if (srcHeight + srcY > this.height) {
            dstHeight = (int)((double)dstHeight * (double)(this.width - srcY) / (double)srcHeight);
            srcHeight = this.height - srcY;
        }
        if (srcWidth <= 0 || srcHeight <= 0 || dstWidth <= 0 || dstHeight <= 0) {
            return true;
        }
        if (bgcolor != null) {
            this.drawPixelsScaledFlipped(g, bgcolor.getRed(), bgcolor.getGreen(), bgcolor.getBlue(), flipX, flipY, srcX, srcY, srcWidth, srcHeight, dstX, dstY, dstWidth, dstHeight, true);
        } else {
            this.drawPixelsScaledFlipped(g, 0, 0, 0, flipX, flipY, srcX, srcY, srcWidth, srcHeight, dstX, dstY, dstWidth, dstHeight, false);
        }
        return true;
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public boolean contentsLost() {
        return false;
    }

    public Graphics2D createGraphics() {
        QtImageGraphics g = new QtImageGraphics(this);
        this.putPainter(g);
        return g;
    }

    public ImageCapabilities getCapabilities() {
        return new ImageCapabilities(false){

            public final boolean isTrueVolatile() {
                return false;
            }
        };
    }

    public int getHeight() {
        return this.height;
    }

    public BufferedImage getSnapshot() {
        BufferedImage bi = new BufferedImage(this.width, this.height, 3);
        bi.setRGB(0, 0, this.width, this.height, this.getPixels(), 0, this.width);
        return bi;
    }

    public int getWidth() {
        return this.width;
    }

    public int validate(GraphicsConfiguration gc) {
        return 0;
    }

    private final /* synthetic */ void this() {
        this.width = -1;
        this.height = -1;
    }

    public QtVolatileImage(int width, int height) {
        this.this();
        this.width = width;
        this.height = height;
        this.props = new Hashtable();
        this.createImage();
        this.clear();
    }

    private QtVolatileImage(QtVolatileImage src, int width, int height, int hints) {
        this.this();
        this.width = width;
        this.height = height;
        this.props = new Hashtable();
        this.createScaledImage(src, hints);
    }
}

