/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;

public class ArrayTypeCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeNewInstance(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in ArrayType Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    public void executeNewInstance(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class arrayType = refId.getType();
        Class componentType = arrayType.getComponentType();
        int length = bb.getInt();
        Object newArray = Array.newInstance(componentType, length);
        ObjectId oid = this.idMan.getObjectId(newArray);
        oid.disableCollection();
        oid.writeTagged(os);
    }
}

